/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachmentCapability;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtNetwork;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

public class DataAttachments
implements DataAttachmentCapability,
INBTSerializable<CompoundTag> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public String fishing = "";
    public List<FishCaughtCounter> fishesCaught = List.of(new FishCaughtCounter(FishProperties.DEFAULT, 0, 0, 0.0f));
    public List<TrophyProperties> trophiesCaught = List.of(TrophyProperties.DEFAULT);
    public List<FishProperties> notifications = List.of(FishProperties.DEFAULT);
    private final Player player;

    public DataAttachments(Player player) {
        this.player = player;
    }

    public static DataAttachmentCapability get(Player player) {
        return (DataAttachmentCapability)player.getCapability(PLAYER_DATA).orElse(null);
    }

    @Override
    public String fishing() {
        return this.fishing;
    }

    @Override
    public void setFishing(String s) {
        this.fishing = s;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Payloads.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sp), (Object)new Payloads.FishingBobUUIDPayload(this.player, s));
        }
    }

    @Override
    public List<FishCaughtCounter> fishesCaught() {
        return this.fishesCaught;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setFishesCaughtClient(List<FishCaughtNetwork> fishCaughtNetworks) {
        ArrayList<FishCaughtCounter> list = new ArrayList<FishCaughtCounter>();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (FishCaughtNetwork fishCaughtNetwork : fishCaughtNetworks) {
            FishProperties fp = FishProperties.getByRL(fishCaughtNetwork.rl(), player.m_9236_());
            if (fp == null) {
                fp = FishProperties.DEFAULT;
            }
            list.add(new FishCaughtCounter(fp, fishCaughtNetwork.count(), fishCaughtNetwork.fastestTicks(), fishCaughtNetwork.averageTicks()));
        }
        DataAttachments.get((Player)player).setFishesCaught(list);
    }

    @Override
    public void setFishesCaught(List<FishCaughtCounter> list) {
        this.fishesCaught = list;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Payloads.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new Payloads.FishesCaughtPayload(list, (Player)sp));
        }
    }

    @Override
    public List<TrophyProperties> trophiesCaught() {
        return this.trophiesCaught;
    }

    @Override
    public void setTrophiesCaught(List<TrophyProperties> list) {
        this.trophiesCaught = list;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Payloads.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new Payloads.TrophiesCaughtPayload(this.trophiesCaught));
        }
    }

    @Override
    public List<FishProperties> fishNotifications() {
        return this.notifications;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setFishNotificationsClient(List<ResourceLocation> listRLs) {
        ArrayList<FishProperties> notifications = new ArrayList<FishProperties>();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (ResourceLocation rl : listRLs) {
            FishProperties fp = FishProperties.getByRL(rl, player.m_9236_());
            if (fp == null) {
                fp = FishProperties.DEFAULT;
            }
            notifications.add(fp);
        }
        DataAttachments.get((Player)player).setFishNotifications(notifications);
    }

    @Override
    public void setFishNotifications(List<FishProperties> list) {
        this.notifications = list;
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Payloads.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new Payloads.FishesNotificationPayload(this.notifications, (Player)sp));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        FishCaughtCounter.LIST_CODEC.encode(this.fishesCaught, (DynamicOps)NbtOps.f_128958_, (Object)new ListTag()).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).ifPresent(tag -> compoundTag.m_128365_("fishes_caught", tag));
        TrophyProperties.LIST_CODEC.encode(this.trophiesCaught, (DynamicOps)NbtOps.f_128958_, (Object)new ListTag()).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).ifPresent(tag -> compoundTag.m_128365_("trophies_caught", tag));
        FishProperties.LIST_CODEC.encode(this.notifications, (DynamicOps)NbtOps.f_128958_, (Object)new ListTag()).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).ifPresent(tag -> compoundTag.m_128365_("notifications", tag));
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("fishes_caught", 9)) {
            this.fishesCaught = (List)((Pair)FishCaughtCounter.LIST_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128437_("fishes_caught", 10)).result().get()).getFirst();
        }
        if (tag.m_128425_("trophies_caught", 9)) {
            this.trophiesCaught = (List)((Pair)TrophyProperties.LIST_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128437_("trophies_caught", 10)).result().get()).getFirst();
        }
        if (tag.m_128425_("notifications", 9)) {
            this.notifications = (List)((Pair)FishProperties.LIST_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128437_("notifications", 10)).result().get()).getFirst();
        }
    }
}

