/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.bob.FishingBobEntity;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public record FishProperties(Item fish, int baseChance, String customName, Rarity rarity, WorldRestrictions wr, BaitRestrictions br, Difficulty dif, Daytime daytime, Weather weather, int mustBeCaughtBelowY, int mustBeCaughtAboveY, boolean skipMinigame, boolean hasGuideEntry) {
    public static final Codec<FishProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("fish").forGetter(FishProperties::fish), (App)Codec.INT.optionalFieldOf("base_chance", (Object)5).forGetter(FishProperties::baseChance), (App)Codec.STRING.optionalFieldOf("custom_name", (Object)"").forGetter(FishProperties::customName), (App)Rarity.CODEC.optionalFieldOf("rarity", (Object)Rarity.COMMON).forGetter(FishProperties::rarity), (App)WorldRestrictions.CODEC.optionalFieldOf("world_restrictions", (Object)WorldRestrictions.DEFAULT).forGetter(FishProperties::wr), (App)BaitRestrictions.CODEC.optionalFieldOf("bait_restrictions", (Object)BaitRestrictions.DEFAULT).forGetter(FishProperties::br), (App)Difficulty.CODEC.optionalFieldOf("difficulty", (Object)Difficulty.DEFAULT).forGetter(FishProperties::dif), (App)Daytime.CODEC.optionalFieldOf("daytime", (Object)Daytime.ALL).forGetter(FishProperties::daytime), (App)Weather.CODEC.optionalFieldOf("weather", (Object)Weather.ALL).forGetter(FishProperties::weather), (App)Codec.INT.optionalFieldOf("below_y", (Object)Integer.MAX_VALUE).forGetter(FishProperties::mustBeCaughtBelowY), (App)Codec.INT.optionalFieldOf("above_y", (Object)Integer.MIN_VALUE).forGetter(FishProperties::mustBeCaughtAboveY), (App)Codec.BOOL.optionalFieldOf("skips_minigame", (Object)false).forGetter(FishProperties::skipMinigame), (App)Codec.BOOL.optionalFieldOf("has_guide_entry", (Object)true).forGetter(FishProperties::hasGuideEntry)).apply((Applicative)instance, FishProperties::new));
    public static final Codec<List<FishProperties>> LIST_CODEC = CODEC.listOf();
    public static final FishProperties DEFAULT = new FishProperties(Items.f_42329_, 5, "", Rarity.COMMON, WorldRestrictions.DEFAULT, BaitRestrictions.DEFAULT, Difficulty.DEFAULT, Daytime.ALL, Weather.ALL, Integer.MAX_VALUE, Integer.MIN_VALUE, false, true);

    public static FishProperties getByRL(ResourceLocation resourceLocation, Level level) {
        return (FishProperties)level.m_9598_().m_175515_(Starcatcher.FISH_REGISTRY).m_7745_(resourceLocation);
    }

    public FishProperties withFish(Item fish) {
        return new FishProperties(fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withBaseChance(int baseChance) {
        return new FishProperties(this.fish, baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withCustomName(String customName) {
        return new FishProperties(this.fish, this.baseChance, customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withRarity(Rarity rarity) {
        return new FishProperties(this.fish, this.baseChance, this.customName, rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withWorldRestrictions(WorldRestrictions wr) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withBaitRestrictions(BaitRestrictions br) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withDifficulty(Difficulty dif) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withDaytime(Daytime daytime) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withWeather(Weather weather) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withMustBeCaughtBelowY(int mustBeCaughtBelowY) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withMustBeCaughtAboveY(int mustBeCaughtAboveY) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, mustBeCaughtAboveY, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withSkipMinigame(boolean skipMinigame) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withHasGuideEntry(boolean hasGuideEntry) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY, this.skipMinigame, hasGuideEntry);
    }

    public static List<ResourceLocation> getBiomesAsList(FishProperties fp, Level level) {
        level.m_9598_().m_6632_(Registries.f_256952_);
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : fp.wr.biomesTags) {
            TagKey biomeBeingChecked = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl);
            Optional optional = level.m_9598_().m_255025_(Registries.f_256952_).m_254901_(biomeBeingChecked);
            if (!optional.isPresent()) continue;
            for (Holder biomeHolder : (HolderSet.Named)optional.get()) {
                String biomeString = ((ResourceKey)biomeHolder.m_203543_().get()).m_135782_().toString();
                rls.add(ResourceLocation.parse((String)biomeString));
            }
        }
        for (ResourceLocation rl : fp.wr.biomes) {
            Optional optional = level.m_9598_().m_255025_(Registries.f_256952_).m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl));
            if (!optional.isPresent() || rls.contains(rl)) continue;
            rls.add(rl);
        }
        return rls;
    }

    public static List<ResourceLocation> getBiomesBlacklistAsList(FishProperties fp, Level level) {
        level.m_9598_().m_6632_(Registries.f_256952_);
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : fp.wr.biomesBlacklistTags) {
            TagKey biomeBeingChecked = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl);
            Optional optional = level.m_9598_().m_255025_(Registries.f_256952_).m_254901_(biomeBeingChecked);
            if (!optional.isPresent()) continue;
            for (Holder biomeHolder : (HolderSet.Named)optional.get()) {
                String biomeString = ((ResourceKey)biomeHolder.m_203543_().get()).m_135782_().toString();
                rls.add(ResourceLocation.parse((String)biomeString));
            }
        }
        for (ResourceLocation rl : fp.wr.biomesBlacklist) {
            Optional optional = level.m_9598_().m_255025_(Registries.f_256952_).m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl));
            if (!optional.isPresent() || rls.contains(rl)) continue;
            rls.add(rl);
        }
        return rls;
    }

    public static List<FishProperties> getFPs(Level level) {
        return FishProperties.getFPs(level.m_9598_());
    }

    public static List<FishProperties> getFPs(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Starcatcher.FISH_REGISTRY).m_123024_().toList();
    }

    public static int getChance(FishProperties fp, Entity entity, ItemStack rod) {
        Level level = entity.m_9236_();
        int chance = fp.baseChance();
        ItemStack bobber = ModDataComponents.getItemInSlot(rod, ModDataComponents.Slots.BOBBER);
        ItemStack bait = ModDataComponents.getItemInSlot(rod, ModDataComponents.Slots.BAIT);
        if (!fp.wr.dims.isEmpty() && !fp.wr().dims().contains(level.m_46472_().m_135782_())) {
            return 0;
        }
        if (fp.wr.dimsBlacklist.contains(level.m_46472_().m_135782_())) {
            return 0;
        }
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, level);
        List<ResourceLocation> blacklist = FishProperties.getBiomesBlacklistAsList(fp, level);
        ResourceLocation currentBiome = ((ResourceKey)level.m_204166_(entity.m_20183_()).m_203543_().get()).m_135782_();
        if (!biomes.isEmpty() && !biomes.contains(currentBiome)) {
            return 0;
        }
        if (!blacklist.isEmpty() && blacklist.contains(currentBiome)) {
            return 0;
        }
        boolean fluid = fp.wr.fluids.contains(BuiltInRegistries.f_257020_.m_7981_((Object)FishProperties.getSource(level.m_6425_(entity.m_20183_()).m_76152_())));
        boolean fluidAbove = fp.wr.fluids.contains(BuiltInRegistries.f_257020_.m_7981_((Object)FishProperties.getSource(level.m_6425_(entity.m_20183_().m_7494_()).m_76152_())));
        boolean fluidBelow = fp.wr.fluids.contains(BuiltInRegistries.f_257020_.m_7981_((Object)FishProperties.getSource(level.m_6425_(entity.m_20183_().m_7495_()).m_76152_())));
        if (!fluid && !fluidAbove && !fluidBelow && entity instanceof FishingBobEntity) {
            return 0;
        }
        if (fp.br().incorrectBaits().contains(BuiltInRegistries.f_257033_.m_7981_((Object)bait.m_41720_()))) {
            return 0;
        }
        if (entity.m_20182_().f_82480_ > (double)fp.mustBeCaughtBelowY()) {
            return 0;
        }
        if (entity.m_20182_().f_82480_ < (double)fp.mustBeCaughtAboveY()) {
            return 0;
        }
        if (fp.daytime() != Daytime.ALL) {
            long time = level.m_46468_() % 24000L;
            switch (fp.daytime()) {
                case DAY: {
                    if (time > 23000L || time < 12700L) break;
                    return 0;
                }
                case NOON: {
                    if (time > 3500L && time < 8500L) break;
                    return 0;
                }
                case NIGHT: {
                    if (time < 23000L && time > 12700L) break;
                    return 0;
                }
                case MIDNIGHT: {
                    if (time > 16500L && time < 19500L) break;
                    return 0;
                }
            }
        }
        if (!bait.m_150930_((Item)ModItems.METEOROLOGICAL_BAIT.get())) {
            if (fp.weather() == Weather.CLEAR && ((double)level.m_46722_(0.0f) > 0.5 || (double)level.m_46661_(0.0f) > 0.5)) {
                return 0;
            }
            if (fp.weather() == Weather.RAIN && (double)level.m_46722_(0.0f) < 0.5) {
                return 0;
            }
            if (fp.weather() == Weather.THUNDER && (double)level.m_46661_(0.0f) < 0.5) {
                return 0;
            }
        }
        if (fp.br().mustHaveCorrectBait() && !fp.br().correctBait().contains(BuiltInRegistries.f_257033_.m_7981_((Object)bait.m_41720_()))) {
            return 0;
        }
        if (fp.br().correctBait().contains(BuiltInRegistries.f_257033_.m_7981_((Object)bait.m_41720_()))) {
            chance += fp.br().correctBaitChanceAdded();
        }
        if (!fp.br().correctBobber().isEmpty() && !fp.br().correctBobber().contains(BuiltInRegistries.f_257033_.m_7981_((Object)bobber.m_41720_()))) {
            return 0;
        }
        return chance;
    }

    public static List<FishProperties> getFpsWithGuideEntryForArea(Entity entity) {
        ArrayList<FishProperties> list = new ArrayList<FishProperties>();
        for (FishProperties fp : entity.m_9236_().m_9598_().m_175515_(Starcatcher.FISH_REGISTRY)) {
            if (FishProperties.getChance(fp, entity, new ItemStack((ItemLike)ModItems.ROD.get())) <= 0 || !fp.hasGuideEntry) continue;
            list.add(fp);
        }
        return list;
    }

    public static Fluid getSource(Fluid fluid1) {
        if (fluid1 instanceof FlowingFluid) {
            FlowingFluid fluid = (FlowingFluid)fluid1;
            return fluid.m_5613_();
        }
        return fluid1;
    }

    public static enum Rarity implements StringRepresentable
    {
        COMMON("common"),
        UNCOMMON("uncommon"),
        RARE("rare"),
        EPIC("epic"),
        LEGENDARY("legendary");

        public static final Codec<Rarity> CODEC;
        private final String key;

        private Rarity(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Rarity::values);
        }
    }

    public record WorldRestrictions(List<ResourceLocation> dims, List<ResourceLocation> dimsBlacklist, List<ResourceLocation> biomes, List<ResourceLocation> biomesTags, List<ResourceLocation> biomesBlacklist, List<ResourceLocation> biomesBlacklistTags, List<ResourceLocation> fluids) {
        public static final Codec<WorldRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("dimensions", List.of()).forGetter(WorldRestrictions::dims), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("dimensions_blacklist", List.of()).forGetter(WorldRestrictions::dimsBlacklist), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("biomes", List.of()).forGetter(WorldRestrictions::biomes), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("biomes_tags", List.of()).forGetter(WorldRestrictions::biomesTags), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("biomes_blacklist", List.of()).forGetter(WorldRestrictions::biomesBlacklist), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("biomes_blacklist_tags", List.of()).forGetter(WorldRestrictions::biomesBlacklistTags), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("fluids", List.of(ResourceLocation.withDefaultNamespace((String)"water"))).forGetter(WorldRestrictions::fluids)).apply((Applicative)instance, WorldRestrictions::new));
        public static final WorldRestrictions DEFAULT = new WorldRestrictions(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(ResourceLocation.withDefaultNamespace((String)"water")));
        public static final WorldRestrictions OVERWORLD = DEFAULT.withDims(Level.f_46428_.m_135782_());
        public static final WorldRestrictions OVERWORLD_LUSH_CAVES = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomes(Biomes.f_151785_.m_135782_());
        public static final WorldRestrictions OVERWORLD_DRIPSTONE_CAVES = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomes(Biomes.f_151784_.m_135782_());
        public static final WorldRestrictions OVERWORLD_DEEP_DARK = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomes(Biomes.f_220594_.m_135782_());
        public static final WorldRestrictions OVERWORLD_RIVER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_RIVER);
        public static final WorldRestrictions OVERWORLD_OCEAN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_OCEAN);
        public static final WorldRestrictions OVERWORLD_WARM_OCEAN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_WARM_OCEAN);
        public static final WorldRestrictions OVERWORLD_DEEP_OCEAN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_DEEP_OCEAN);
        public static final WorldRestrictions OVERWORLD_LAKE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesBlacklistTags(List.of(StarcatcherTags.IS_OCEAN, StarcatcherTags.IS_RIVER));
        public static final WorldRestrictions OVERWORLD_FRESHWATER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesBlacklistTags(StarcatcherTags.IS_OCEAN);
        public static final WorldRestrictions OVERWORLD_COLD_FRESHWATER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(List.of(StarcatcherTags.IS_COLD_LAKE, StarcatcherTags.IS_COLD_RIVER));
        public static final WorldRestrictions OVERWORLD_WARM_FRESHWATER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(List.of(StarcatcherTags.IS_WARM_LAKE, StarcatcherTags.IS_WARM_RIVER));
        public static final WorldRestrictions OVERWORLD_WARM_LAKE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_WARM_LAKE);
        public static final WorldRestrictions OVERWORLD_COLD_RIVER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_COLD_RIVER);
        public static final WorldRestrictions OVERWORLD_COLD_OCEAN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_COLD_OCEAN);
        public static final WorldRestrictions OVERWORLD_COLD_LAKE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_COLD_LAKE);
        public static final WorldRestrictions OVERWORLD_BEACH = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_BEACH);
        public static final WorldRestrictions OVERWORLD_MUSHROOM_FIELDS = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_MUSHROOM_FIELDS);
        public static final WorldRestrictions OVERWORLD_JUNGLE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(BiomeTags.f_207610_.f_203868_());
        public static final WorldRestrictions OVERWORLD_TAIGA = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(BiomeTags.f_207609_.f_203868_());
        public static final WorldRestrictions OVERWORLD_CHERRY_GROVE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_CHERRY_GROVE);
        public static final WorldRestrictions OVERWORLD_SWAMP = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_SWAMP);
        public static final WorldRestrictions OVERWORLD_DARK_FOREST = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_DARK_FOREST);
        public static final WorldRestrictions OVERWORLD_LAVA = DEFAULT.withDims(Level.f_46428_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA = DEFAULT.withDims(Level.f_46429_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions END = DEFAULT.withDims(Level.f_46430_.m_135782_());

        public WorldRestrictions withDims(ResourceLocation dims) {
            return new WorldRestrictions(List.of(dims), this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withDims(List<ResourceLocation> dims) {
            return new WorldRestrictions(dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withDimsBlacklist(ResourceLocation dimsBlacklist) {
            return new WorldRestrictions(this.dims, List.of(dimsBlacklist), this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withDimsBlacklist(List<ResourceLocation> dimsBlacklist) {
            return new WorldRestrictions(this.dims, dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomes(ResourceLocation biome) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, List.of(biome), this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomes(List<ResourceLocation> biomes) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesTags(ResourceLocation biomesTag) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, List.of(biomesTag), this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesTags(List<ResourceLocation> biomesTags) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesBlacklist(List<ResourceLocation> biomesBlacklist) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, biomesBlacklist, this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesBlacklist(ResourceLocation biomesBlacklist) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, List.of(biomesBlacklist), this.biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesBlacklistTags(List<ResourceLocation> biomesBlacklistTags) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, biomesBlacklistTags, this.fluids);
        }

        public WorldRestrictions withBiomesBlacklistTags(ResourceLocation biomesBlacklistTags) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, List.of(biomesBlacklistTags), this.fluids);
        }

        public WorldRestrictions withFluids(List<ResourceLocation> fluids) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, fluids);
        }

        public WorldRestrictions withFluids(ResourceLocation fluids) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, List.of(fluids));
        }
    }

    public record BaitRestrictions(List<ResourceLocation> correctBobber, List<ResourceLocation> correctBait, boolean consumesBait, int correctBaitChanceAdded, List<ResourceLocation> incorrectBaits, boolean mustHaveCorrectBait) {
        public static final Codec<BaitRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("correct_bobbers", List.of()).forGetter(BaitRestrictions::correctBobber), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("correct_baits", List.of()).forGetter(BaitRestrictions::correctBait), (App)Codec.BOOL.optionalFieldOf("consumes_bait", (Object)true).forGetter(BaitRestrictions::consumesBait), (App)Codec.INT.optionalFieldOf("correct_bait_chance_added", (Object)0).forGetter(BaitRestrictions::correctBaitChanceAdded), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("incorrect_baits", List.of()).forGetter(BaitRestrictions::incorrectBaits), (App)Codec.BOOL.optionalFieldOf("must_have_correct_bait", (Object)false).forGetter(BaitRestrictions::mustHaveCorrectBait)).apply((Applicative)instance, BaitRestrictions::new));
        public static final BaitRestrictions DEFAULT = new BaitRestrictions(List.of(), List.of(), true, 0, List.of(), false);
        public static final BaitRestrictions CHERRY_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.CHERRY_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions LUSH_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.LUSH_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions SCULK_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.SCULK_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions DRIPSTONE_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.DRIPSTONE_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions MURKWATER_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.MURKWATER_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions LEGENDARY_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.LEGENDARY_BAIT.getId()), true, 15, List.of(), false);

        public BaitRestrictions withCorrectBobber(ResourceLocation correctBobber) {
            return new BaitRestrictions(List.of(correctBobber), this.correctBait, this.consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withCorrectBobber(List<ResourceLocation> correctBobber) {
            return new BaitRestrictions(correctBobber, this.correctBait, this.consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withCorrectBait(ResourceLocation correctBait) {
            return new BaitRestrictions(this.correctBobber, List.of(correctBait), this.consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withCorrectBait(List<ResourceLocation> correctBait) {
            return new BaitRestrictions(this.correctBobber, correctBait, this.consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withConsumesBait(boolean consumesBait) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withCorrectBaitChanceAdded(int correctBaitChanceAdded) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, this.consumesBait, correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withIncorrectBaits(ResourceLocation incorrectBaits) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, this.consumesBait, this.correctBaitChanceAdded, List.of(incorrectBaits), this.mustHaveCorrectBait);
        }

        public BaitRestrictions withIncorrectBaits(List<ResourceLocation> incorrectBaits) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, this.consumesBait, this.correctBaitChanceAdded, incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withMustHaveCorrectBait(boolean mustHaveCorrectBait) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, this.consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, mustHaveCorrectBait);
        }
    }

    public record Difficulty(int speed, int reward, int rewardThin, int penalty, int decay, boolean hasFirstMarker, boolean hasSecondMarker, boolean hasFirstThinMarker, boolean hasSecondThinMarker, Treasure treasure, boolean changeRotationOnEveryHit) {
        public static final Difficulty DEFAULT = new Difficulty(9, 20, 0, 6, 1, true, true, false, false, Treasure.DEFAULT, true);
        public static final Difficulty MEDIUM = new Difficulty(10, 15, 35, 15, 1, true, false, true, false, Treasure.UNCOMMON, true);
        public static final Difficulty HARD = new Difficulty(12, 15, 35, 25, 2, true, false, true, false, Treasure.HARD, true);
        public static final Difficulty HARD_ONLY_THIN = new Difficulty(9, 15, 20, 25, 2, false, false, true, true, Treasure.HARD, true);
        public static final Difficulty THIN_NO_DECAY = new Difficulty(9, 0, 15, 30, 0, false, false, true, true, Treasure.HARD, false);
        public static final Difficulty THIN_NO_DECAY_NOT_FORGIVING = new Difficulty(9, 0, 15, 999, 0, false, false, true, true, Treasure.HARD, false);
        public static final Difficulty SINGLE_BIG_FAST_NO_DECAY = new Difficulty(15, 5, 0, 15, 0, true, false, false, false, Treasure.HARD, false);
        public static final Difficulty SINGLE_BIG_FAST = new Difficulty(15, 5, 0, 15, 2, true, false, false, false, Treasure.HARD, false);
        public static final Difficulty EVERYTHING = new Difficulty(12, 15, 30, 15, 3, true, true, true, true, Treasure.HARD, false);
        public static final Difficulty EVERYTHING_FLIP = new Difficulty(12, 15, 30, 15, 3, true, true, true, true, Treasure.HARD, true);
        public static final Difficulty NON_STOP_ACTION = new Difficulty(15, 18, 30, 0, 10, true, true, false, false, Treasure.HARD, false);
        public static final Codec<Difficulty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("speed", (Object)Difficulty.DEFAULT.speed).forGetter(Difficulty::speed), (App)Codec.INT.optionalFieldOf("reward", (Object)Difficulty.DEFAULT.reward).forGetter(Difficulty::reward), (App)Codec.INT.optionalFieldOf("reward_thin", (Object)Difficulty.DEFAULT.rewardThin).forGetter(Difficulty::rewardThin), (App)Codec.INT.optionalFieldOf("penalty", (Object)Difficulty.DEFAULT.penalty).forGetter(Difficulty::penalty), (App)Codec.INT.optionalFieldOf("decay", (Object)Difficulty.DEFAULT.decay).forGetter(Difficulty::decay), (App)Codec.BOOL.optionalFieldOf("has_first_marker", (Object)Difficulty.DEFAULT.hasFirstMarker).forGetter(Difficulty::hasFirstMarker), (App)Codec.BOOL.optionalFieldOf("has_second_marker", (Object)Difficulty.DEFAULT.hasSecondMarker).forGetter(Difficulty::hasSecondMarker), (App)Codec.BOOL.optionalFieldOf("has_first_thin_marker", (Object)Difficulty.DEFAULT.hasFirstThinMarker).forGetter(Difficulty::hasFirstThinMarker), (App)Codec.BOOL.optionalFieldOf("has_second_thin_marker", (Object)Difficulty.DEFAULT.hasSecondThinMarker).forGetter(Difficulty::hasSecondThinMarker), (App)Treasure.CODEC.optionalFieldOf("treasure", (Object)Treasure.DEFAULT).forGetter(Difficulty::treasure), (App)Codec.BOOL.optionalFieldOf("change_rotation_every_hit", (Object)Difficulty.DEFAULT.changeRotationOnEveryHit).forGetter(Difficulty::changeRotationOnEveryHit)).apply((Applicative)instance, Difficulty::new));

        public Difficulty withTreasure(Treasure treasure) {
            return new Difficulty(this.speed, this.reward, this.rewardThin, this.penalty, this.decay, this.hasFirstMarker, this.hasSecondMarker, this.hasFirstThinMarker, this.hasSecondThinMarker, treasure, this.changeRotationOnEveryHit);
        }
    }

    public static enum Daytime implements StringRepresentable
    {
        ALL("all"),
        DAY("day"),
        NOON("noon"),
        NIGHT("night"),
        MIDNIGHT("midnight");

        public static final Codec<Daytime> CODEC;
        private final String key;

        private Daytime(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Daytime::values);
        }
    }

    public static enum Weather implements StringRepresentable
    {
        ALL("all"),
        CLEAR("clear"),
        RAIN("rain"),
        THUNDER("thunder");

        public static final Codec<Weather> CODEC;
        private final String key;

        private Weather(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Weather::values);
        }
    }

    public record Treasure(boolean hasTreasure, ResourceLocation loot, int hitReward) {
        public static final Codec<Treasure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("has_treasure", (Object)false).forGetter(Treasure::hasTreasure), (App)ResourceLocation.f_135803_.optionalFieldOf("loot", (Object)Starcatcher.rl("none")).forGetter(Treasure::loot), (App)Codec.INT.optionalFieldOf("hit_reward", (Object)0).forGetter(Treasure::hitReward)).apply((Applicative)instance, Treasure::new));
        public static final Treasure DEFAULT = new Treasure(false, Starcatcher.rl("waterlogged_satchel"), 15);
        public static final Treasure UNCOMMON = new Treasure(true, Starcatcher.rl("waterlogged_satchel"), 15);
        public static final Treasure HARD = new Treasure(true, Starcatcher.rl("treasure"), 15);
        public static final Treasure NETHER = new Treasure(true, Starcatcher.rl("scalding_treasure"), 28);
    }
}

