/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.datagen;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandstuff.FishProperties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public class FishPropertiesProvider
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder REGISTRY = new RegistrySetBuilder().add(Starcatcher.FISH_REGISTRY, bootstrap -> {
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.OBIDONTIEE.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.SILVERVEIL_PERCH.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.ELDERSCALE.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLakeFish((Item)ModItems.DRIFTFIN.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.DOWNFALL_BREAM.get()).withDaytime(FishProperties.Daytime.NIGHT).withWeather(FishProperties.Weather.RAIN));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.DRIFTING_BREAM.get()).withDaytime(FishProperties.Daytime.NIGHT));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.WILLOW_BREAM.get()).withDaytime(FishProperties.Daytime.NIGHT));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.HOLLOWBELLY_DARTER.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.MISTBACK_CHUB.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish((Item)ModItems.SILVERFIN_PIKE.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldRiverFish(Items.SALMON));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyRiverFish((Item)ModItems.FROSTGILL_CHUB.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyRiverFish((Item)ModItems.CRYSTALBACK_MINNOW.get()).withDaytime(FishProperties.Daytime.NIGHT));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldIcyRiverFish((Item)ModItems.AZURE_CRYSTALBACK_MINNOW.get()).withDaytime(FishProperties.Daytime.MIDNIGHT));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(Items.COD));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish(Items.COD).withCustomName("very_cool_cod"));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.IRONJAW_HERRING.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.DEEPJAW_HERRING.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.DUSKTAIL_SNAPPER.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldOceanFish((Item)ModItems.JOEL.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish((Item)ModItems.WHITEVEIL.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish((Item)ModItems.GHOSTLY_PIKE.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish((Item)ModItems.GOLD_FAN.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish((Item)ModItems.BLACK_EEL.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldUndergroundFish((Item)ModItems.AMETHYSTBACK.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.overworldLushCavesFish((Item)ModItems.LUSH_PIKE.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.EMBERGILL.get()));
        FishPropertiesProvider.register((BootstrapContext<FishProperties>)bootstrap, FishPropertiesProvider.netherFish((Item)ModItems.SCALDING_PIKE.get()));
    });

    public FishPropertiesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, REGISTRY, Set.of("starcatcher"));
    }

    public static FishProperties netherFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER);
    }

    public static FishProperties overworldLushCavesFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LUSH_CAVES).withMustBeCaughtBellowY(50);
    }

    public static FishProperties overworldUndergroundFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD).withMustBeCaughtBellowY(50);
    }

    public static FishProperties overworldIcyLakeFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_ICY_LAKE);
    }

    public static FishProperties overworldIcyOceanFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_ICY_OCEAN);
    }

    public static FishProperties overworldIcyRiverFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_ICY_RIVER);
    }

    public static FishProperties overworldLakeFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAKE);
    }

    public static FishProperties overworldOceanFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_OCEAN);
    }

    public static FishProperties overworldRiverFish(Item fish) {
        return FishProperties.DEFAULT.withFish(FishPropertiesProvider.getKey(fish)).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_RIVER);
    }

    public static Holder.Reference<FishProperties> register(BootstrapContext<FishProperties> bootstrap, FishProperties fp) {
        if (fp.customName().isEmpty()) {
            return bootstrap.register(FishPropertiesProvider.key(fp.fish().getNamespace(), fp.fish().getPath()), (Object)fp);
        }
        return bootstrap.register(FishPropertiesProvider.key("starcatcher", fp.customName()), (Object)fp);
    }

    public static ResourceLocation getKey(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceKey<FishProperties> key(String namespace, String path) {
        return ResourceKey.create(Starcatcher.FISH_REGISTRY, (ResourceLocation)Starcatcher.rl(namespace + "_" + path));
    }
}

