/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandstuff.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandstuff.FishProperties;
import com.wdiscute.starcatcher.networkandstuff.ModDataAttachments;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FishingGuideScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = Starcatcher.rl("textures/gui/guide/background.png");
    private static final ResourceLocation ARROW_PREVIOUS = Starcatcher.rl("textures/gui/guide/arrow_previous.png");
    private static final ResourceLocation ARROW_NEXT = Starcatcher.rl("textures/gui/guide/arrow_next.png");
    int uiX;
    int uiY;
    int imageWidth;
    int imageHeight;
    int currentPage;
    ClientLevel level;
    LocalPlayer player;
    List<FishProperties> entries = new ArrayList<FishProperties>(999);

    protected void init() {
        super.init();
        this.entries = new ArrayList<FishProperties>(999);
        this.imageWidth = 512;
        this.imageHeight = 256;
        this.uiX = (this.width - this.imageWidth) / 2;
        this.uiY = (this.height - this.imageHeight) / 2;
        ClientLevel level = Minecraft.getInstance().level;
        this.player = Minecraft.getInstance().player;
        for (FishProperties fp : FishProperties.getFPs((Level)level)) {
            if (!fp.hasGuideEntry()) continue;
            this.entries.add(fp);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        if (this.minecraft.options.keyDrop.isActiveAndMatches(key)) {
            Minecraft.getInstance().player.setData(ModDataAttachments.FISH_SPOTTER, (Object)this.entries.get(this.currentPage));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        if (x > 68.0 && x < 105.0 && y > 230.0 && y < 240.0 && this.currentPage != 0) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            --this.currentPage;
        }
        if (x > 420.0 && x < 440.0 && y > 230.0 && y < 240.0 && this.currentPage <= this.entries.size() / 2) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            ++this.currentPage;
        }
        if (this.currentPage == 0) {
            for (int i = 0; i < this.entries.size(); ++i) {
                int offsetX = i % 7 * 24 + 72;
                int offsetY = i / 7 * 24 + 40;
                if (!(mouseX > (double)(this.uiX + offsetX - 3)) || !(mouseX < (double)(this.uiX + offsetX + 21 - 3)) || !(mouseY > (double)(this.uiY + offsetY - 3)) || !(mouseY < (double)(this.uiY + offsetY + 21 - 3))) continue;
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.currentPage = i / 2 + 1;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean shouldNarrateNavigation() {
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderImage(guiGraphics, BACKGROUND);
        if (this.currentPage > 0) {
            this.renderEntry(guiGraphics, mouseX, mouseY, 70, this.currentPage * 2 - 2);
            this.renderEntry(guiGraphics, mouseX, mouseY, 276, this.currentPage * 2 - 1);
        } else {
            this.renderIndex(guiGraphics, mouseX, mouseY);
        }
        if (this.currentPage != 0) {
            guiGraphics.blit(ARROW_PREVIOUS, this.uiX + 65, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
        }
        if (this.currentPage < this.entries.size() / 2 + 1) {
            guiGraphics.blit(ARROW_NEXT, this.uiX + 420, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
        }
    }

    private void renderIndex(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.entries.size(); ++i) {
            List fishCounterList = (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT);
            ItemStack is = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.entries.get(i).fish()));
            FishProperties fp = this.entries.get(i);
            int caught = 0;
            int offsetX = i % 7 * 24 + 72;
            int offsetY = i / 7 * 24 + 40;
            for (FishCaughtCounter f : fishCounterList) {
                if (!fp.equals(f.fp())) continue;
                caught = f.count();
                break;
            }
            guiGraphics.renderOutline(this.uiX + offsetX - 2, this.uiY + offsetY - 2, 20, 20, -12303292);
            for (FishProperties fpNotif : (List)this.player.getData(ModDataAttachments.FISHES_NOTIFICATION)) {
                if (!fp.equals(fpNotif)) continue;
                guiGraphics.renderOutline(this.uiX + offsetX - 1, this.uiY + offsetY - 1, 8, 7, -12303292);
            }
            guiGraphics.renderOutline(this.uiX + offsetX - 2, this.uiY + offsetY - 2, 20, 20, -12303292);
            if (caught != 0) {
                this.renderItem(is, this.uiX + offsetX, this.uiY + offsetY, 1);
            } else {
                this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), this.uiX + offsetX, this.uiY + offsetY, 1);
            }
            if (mouseX <= this.uiX + offsetX - 3 || mouseX >= this.uiX + offsetX + 21 - 3 || mouseY <= this.uiY + offsetY - 3 || mouseY >= this.uiY + offsetY + 21 - 3) continue;
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            if (caught == 0) {
                components.add(Component.translatable((String)"gui.guide.not_caught_fish_name"));
                components.add(Component.translatable((String)"gui.guide.not_caught").withColor(0xAA0000));
            } else {
                if (fp.customName().isEmpty()) {
                    components.add(Component.translatable((String)("item." + fp.fish().toLanguageKey())));
                } else {
                    components.add(Component.translatable((String)("item.starcatcher." + fp.customName())));
                }
                components.add(Component.translatable((String)"gui.guide.caught").append((Component)Component.literal((String)("[" + caught + "]"))).withColor(43520));
            }
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics guiGraphics, int mouseX, int mouseY, int xOffset, int entry) {
        ResourceLocation rl;
        MutableComponent comp;
        MutableComponent comp2;
        Object c;
        if (this.level == null) {
            this.level = this.getMinecraft().level;
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.entries.size() <= entry) {
            return;
        }
        ItemStack is = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.entries.get(entry).fish()));
        FishProperties fp = this.entries.get(entry);
        List fishCaughtCounterList = (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT);
        int count = 0;
        for (FishCaughtCounter fcc : fishCaughtCounterList) {
            if (!fp.equals(fcc.fp())) continue;
            count = fcc.count();
            break;
        }
        if (count == 0) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught_fish_name"), this.uiX + xOffset + 46, this.uiY + 60, 0, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught").withColor(0xAA0000), this.uiX + xOffset + 46, this.uiY + 70, 0, false);
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), this.uiX + xOffset + 10, this.uiY + 60);
        } else {
            MutableComponent compName = fp.customName().isEmpty() ? Component.translatable((String)("item." + fp.fish().toLanguageKey())) : Component.translatable((String)("item.starcatcher." + fp.customName()));
            guiGraphics.drawString(this.font, (Component)compName, this.uiX + xOffset + 46, this.uiY + 60, 0, false);
            c = Component.literal((String)("[" + count + "]")).withColor(43520);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.caught").append((Component)c).withColor(43520), this.uiX + xOffset + 46, this.uiY + 70, 0, false);
            this.renderItem(is, this.uiX + xOffset + 10, this.uiY + 60);
        }
        int yOffset = 110;
        if (fp.wr().dims().isEmpty()) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction");
        } else if (fp.wr().dims().size() == 1) {
            comp2 = Component.translatable((String)("dimension." + fp.wr().dims().getFirst().toLanguageKey()));
        } else {
            comp2 = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c2 = new ArrayList<MutableComponent>();
                for (int i = 0; i < fp.wr().dims().size(); ++i) {
                    c2.add(Component.translatable((String)("dimension." + fp.wr().dims().get(i).toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c2, Optional.empty(), mouseX, mouseY);
            }
        }
        comp2 = fp.wr().dims().isEmpty() ? comp2.copy().withColor(43520) : (fp.wr().dims().contains(this.level.dimension().location()) ? comp2.copy().withColor(43520) : comp2.copy().withColor(0xAA0000));
        MutableComponent start = Component.translatable((String)"gui.guide.planet");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        if (!fp.wr().dimsBlacklist().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(0xAA0000), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                c = new ArrayList();
                c.add(Component.translatable((String)"gui.guide.blacklisted_dimensions"));
                for (int i = 0; i < fp.wr().dimsBlacklist().size(); ++i) {
                    c.add(Component.literal((String)fp.wr().dimsBlacklist().get(i).toString()));
                }
                guiGraphics.renderTooltip(this.font, (List)c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 15;
        List<ResourceLocation> biomesBL = FishProperties.getBiomesBlacklistAsList(fp, (Level)this.level);
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, (Level)this.level);
        if (biomes.isEmpty()) {
            comp = Component.translatable((String)"gui.guide.no_restriction");
            if (!biomesBL.isEmpty()) {
                comp.append("*");
            }
        } else if (biomes.size() == 1) {
            comp = Component.translatable((String)("biome." + biomes.getFirst().toLanguageKey()));
        } else if (fp.wr().biomesTags().size() == 1) {
            comp = Component.translatable((String)("tag." + fp.wr().biomesTags().getFirst().toLanguageKey()));
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                c = new ArrayList();
                c.add(Component.translatable((String)"gui.guide.biome"));
                for (ResourceLocation rl2 : biomes) {
                    c.add(Component.translatable((String)("biome." + rl2.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        } else {
            comp = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                c = new ArrayList<MutableComponent>();
                c.add(Component.translatable((String)"gui.guide.biome"));
                for (ResourceLocation rl2 : biomes) {
                    c.add(Component.translatable((String)("biome." + rl2.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c, Optional.empty(), mouseX, mouseY);
            }
        }
        comp = biomes.isEmpty() ? comp.copy().withColor(43520) : (biomes.contains(rl = ResourceLocation.parse((String)this.level.getBiome(Minecraft.getInstance().player.blockPosition()).getRegisteredName())) ? comp.copy().withColor(43520) : comp.copy().withColor(0xAA0000));
        Object start2 = Component.translatable((String)"gui.guide.biome");
        guiGraphics.drawString(this.font, (Component)start2.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        if (!biomesBL.isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(0xAA0000), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                ArrayList<MutableComponent> c3 = new ArrayList<MutableComponent>();
                c3.add(Component.translatable((String)"gui.guide.blacklisted_biomes"));
                for (ResourceLocation rl3 : biomesBL) {
                    c3.add(Component.translatable((String)("biome." + rl3.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c3, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 15;
        if (fp.br().correctBait().isEmpty()) {
            guiGraphics.drawString(this.font, I18n.get((String)"gui.guide.bait", (Object[])new Object[0]) + I18n.get((String)"gui.guide.no_restriction", (Object[])new Object[0]), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        } else {
            ItemStack stack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(fp.br().correctBait().getFirst()));
            guiGraphics.drawString(this.font, I18n.get((String)"gui.guide.bait", (Object[])new Object[0]) + I18n.get((String)stack.getDescriptionId(), (Object[])new Object[0]), this.uiX + xOffset, this.uiY + yOffset, 0, false);
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                guiGraphics.renderTooltip(this.font, stack, mouseX, mouseY);
            }
        }
        yOffset += 15;
        if (fp.weather() == FishProperties.Weather.ALL) {
            comp = Component.translatable((String)"gui.guide.no_restriction").withColor(43520);
        } else {
            comp = Component.translatable((String)"gui.guide.no_restriction");
            if (fp.weather() == FishProperties.Weather.RAIN) {
                comp = (double)this.level.getRainLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.raining").withColor(43520) : Component.translatable((String)"gui.guide.raining").withColor(0xAA0000);
            }
            if (fp.weather() == FishProperties.Weather.THUNDER) {
                comp = (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.thundering").withColor(43520) : Component.translatable((String)"gui.guide.thundering").withColor(0xAA0000);
            }
            if (fp.weather() == FishProperties.Weather.CLEAR) {
                comp = (double)this.level.getRainLevel(0.0f) > 0.5 || (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.clear").withColor(0xAA0000) : Component.translatable((String)"gui.guide.clear").withColor(43520);
            }
        }
        start2 = Component.translatable((String)"gui.guide.weather");
        guiGraphics.drawString(this.font, (Component)start2.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        yOffset += 15;
        if (fp.daytime() == FishProperties.Daytime.ALL) {
            comp = Component.translatable((String)"gui.guide.no_restriction").withColor(43520);
        } else {
            long time = this.level.getDayTime() % 24000L;
            comp = switch (fp.daytime()) {
                case FishProperties.Daytime.DAY -> {
                    if (time <= 23000L && time >= 12700L) {
                        yield Component.translatable((String)"gui.guide.day").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.day").withColor(43520);
                }
                case FishProperties.Daytime.NOON -> {
                    if (time <= 3500L || time >= 8500L) {
                        yield Component.translatable((String)"gui.guide.noon").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.noon").withColor(43520);
                }
                case FishProperties.Daytime.NIGHT -> {
                    if (time >= 23000L || time <= 12700L) {
                        yield Component.translatable((String)"gui.guide.night").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.night").withColor(43520);
                }
                case FishProperties.Daytime.MIDNIGHT -> {
                    if (time <= 16500L || time >= 19500L) {
                        yield Component.translatable((String)"gui.guide.midnight").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.midnight").withColor(43520);
                }
                default -> Component.empty();
            };
        }
        MutableComponent start22 = Component.translatable((String)"gui.guide.daytime");
        guiGraphics.drawString(this.font, (Component)start22.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        yOffset += 15;
        if (fp.mustBeCaughtAboveY() != Integer.MIN_VALUE) {
            guiGraphics.drawString(this.font, I18n.get((String)"gui.guide.min_elevation", (Object[])new Object[0]) + fp.mustBeCaughtAboveY(), this.uiX + xOffset, this.uiY + yOffset, 0, false);
            yOffset += 15;
        }
        if (fp.mustBeCaughtBellowY() != Integer.MAX_VALUE) {
            guiGraphics.drawString(this.font, I18n.get((String)"gui.guide.max_elevation", (Object[])new Object[0]) + fp.mustBeCaughtBellowY(), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        }
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl, int yOffset) {
        guiGraphics.blit(rl, this.uiX, this.uiY + yOffset, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void renderItem(ItemStack stack, int x, int y) {
        this.renderItem(stack, x, y, 3);
    }

    private void renderItem(ItemStack stack, int x, int y, int scale) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer entity = Minecraft.getInstance().player;
        if (!stack.isEmpty()) {
            BakedModel bakedmodel = this.minecraft.getItemRenderer().getModel(stack, (Level)level, (LivingEntity)entity, 234234);
            PoseStack pose = new PoseStack();
            pose.pushPose();
            pose.translate((float)(x + 8), (float)(y + 8), 150.0f);
            try {
                boolean flag;
                pose.scale(16.0f * (float)scale, -16.0f * (float)scale, 16.0f * (float)scale);
                boolean bl = flag = !bakedmodel.usesBlockLight();
                if (flag) {
                    Lighting.setupForFlatItems();
                }
                this.minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
                RenderSystem.disableDepthTest();
                Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
                RenderSystem.enableDepthTest();
                if (flag) {
                    Lighting.setupFor3DItems();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashreport);
            }
            pose.popPose();
        }
    }

    public FishingGuideScreen() {
        super((Component)Component.empty());
    }
}

