/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.minigame;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.ModDataComponents;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandstuff.FishProperties;
import com.wdiscute.starcatcher.networkandstuff.Payloads;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Random;

public class FishingMinigameScreen
extends Screen
implements GuiEventListener {
    private static final ResourceLocation TEXTURE = Starcatcher.rl("textures/gui/minigame.png");
    final ItemStack itemBeingFished;
    final ItemStack bobber;
    final ItemStack bait;
    final float speed;
    final int reward;
    final int rewardThin;
    final int penalty;
    final int decay;
    final boolean hasTreasure;
    final boolean changeRotation;
    final InteractionHand hand;
    int pointerPos = 0;
    int pos1;
    int pos2;
    int posThin1;
    int posThin2;
    int posTreasure;
    int currentRotation = 1;
    float partial;
    int completion = 20;
    int completionSmooth = 20;
    boolean treasureActive;
    int treasureProgress = 0;
    int treasureProgressSmooth = 0;
    int tickCount = 0;
    Random r = new Random();

    public FishingMinigameScreen(FishProperties fp, ItemStack rod) {
        super((Component)Component.empty());
        this.itemBeingFished = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(fp.fish()));
        this.bobber = ((ItemContainerContents)rod.get(ModDataComponents.BOBBER)).copyOne();
        this.bait = ((ItemContainerContents)rod.get(ModDataComponents.BAIT)).copyOne();
        this.pos1 = fp.dif().hasFirstMarker() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.pos2 = fp.dif().hasSecondMarker() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.posThin1 = fp.dif().hasFirstThinMarker() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.posThin2 = fp.dif().hasSecondThinMarker() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.posTreasure = Integer.MIN_VALUE;
        this.speed = fp.dif().speed();
        this.reward = fp.dif().reward();
        this.rewardThin = fp.dif().rewardThin();
        this.penalty = fp.dif().penalty();
        this.decay = fp.dif().decay();
        this.hasTreasure = fp.dif().hasTreasure();
        this.changeRotation = fp.dif().changeRotationOnEveryHit();
        this.hand = Minecraft.getInstance().player.getMainHandItem().is(ModItems.STARCATCHER_FISHING_ROD) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    private int getRandomFreePosition() {
        for (int i = 0; i < 100; ++i) {
            int posBeingChecked = this.r.nextInt(360);
            if ((Math.abs(this.pos1 - posBeingChecked) < 50 || Math.abs(this.pos1 - posBeingChecked) > 310) && this.pos1 != Integer.MIN_VALUE || (Math.abs(this.pos2 - posBeingChecked) < 50 || Math.abs(this.pos2 - posBeingChecked) > 310) && this.pos2 != Integer.MIN_VALUE || (Math.abs(this.posThin1 - posBeingChecked) < 50 || Math.abs(this.posThin1 - posBeingChecked) > 310) && this.posThin1 != Integer.MIN_VALUE || (Math.abs(this.posThin2 - posBeingChecked) < 50 || Math.abs(this.posThin2 - posBeingChecked) > 310) && this.posThin2 != Integer.MIN_VALUE || (Math.abs(this.posTreasure - posBeingChecked) < 50 || Math.abs(this.posTreasure - posBeingChecked) > 310) && this.posTreasure != Integer.MIN_VALUE) continue;
            return posBeingChecked;
        }
        return 0;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float centerY;
        float centerX;
        PoseStack poseStack;
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.partial = partialTick;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        if (this.treasureActive) {
            guiGraphics.blit(TEXTURE, this.width / 2 - 158, this.height / 2 - 42 + (int)(64.0f - 64.0f * (float)this.treasureProgressSmooth / 100.0f), 5, 64 * this.treasureProgressSmooth / 100, 141.0f, 70.0f - (float)(64 * this.treasureProgressSmooth) / 100.0f, 5, 64 * this.treasureProgressSmooth / 100, 256, 256);
            guiGraphics.blit(TEXTURE, this.width / 2 - 16 - 155, this.height / 2 - 48, 32, 96, 96.0f, 0.0f, 32, 96, 256, 256);
        }
        guiGraphics.blit(TEXTURE, this.width / 2 - 42 - 100, this.height / 2 - 48, 85, 97, 0.0f, 0.0f, 85, 97, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32, 64, 64, 0.0f, 192.0f, 64, 64, 256, 256);
        if (this.pos1 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.pos1)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, 16.0f, 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        if (this.pos2 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.pos2)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, 16.0f, 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        if (this.posThin1 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.posThin1)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, 48.0f, 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        if (this.posThin2 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.posThin2)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, 48.0f, 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        if (this.posTreasure != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.posTreasure)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, 64.0f, 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32, 64, 64, 64.0f, 192.0f, 64, 64, 256, 256);
        poseStack = guiGraphics.pose();
        poseStack.pushPose();
        centerX = (float)this.width / 2.0f;
        centerY = (float)this.height / 2.0f;
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians((float)this.pointerPos + this.speed * partialTick * (float)this.currentRotation)));
        poseStack.translate(-centerX, -centerY, 0.0f);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32 - 16, 64, 64, 128.0f, 192.0f, 64, 64, 256, 256);
        poseStack.popPose();
        guiGraphics.blit(TEXTURE, this.width / 2 - 16, this.height / 2 - 16, 32, 32, 208.0f, 208.0f, 32, 32, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32 - 70, this.height / 2 - 24 - 57, 64, 48, 192.0f, 0.0f, 64, 48, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 6 - 102, this.height / 2 - 56 - 18, 16, 112 - this.completionSmooth, 176.0f, (float)(0 + this.completionSmooth), 16, 112 - this.completionSmooth, 256, 256);
        guiGraphics.renderItem(this.itemBeingFished, this.width / 2 - 8 - 100, this.height / 2 - 8 + 35 - this.completionSmooth);
        guiGraphics.blit(TEXTURE, this.width / 2 - 16, this.height / 2 + 160, 32, 16, 0.0f, 112.0f, 32, 16, 256, 256);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        if (keyCode == Minecraft.getInstance().options.keyJump.getKey().getValue()) {
            Minecraft.getInstance().player.swing(this.hand, true);
            boolean hitSomething = false;
            Vec3 pos = Minecraft.getInstance().player.position();
            ClientLevel level = Minecraft.getInstance().level;
            float pointerPrecise = (float)this.pointerPos + this.speed * this.partial * (float)this.currentRotation;
            if ((Math.abs((float)this.pos1 - pointerPrecise) < 12.0f || Math.abs((float)this.pos1 - pointerPrecise) > 348.0f) && this.pos1 != Integer.MIN_VALUE) {
                this.pos1 = this.getRandomFreePosition();
                this.completion += this.reward;
                hitSomething = true;
            }
            if ((Math.abs((float)this.pos2 - pointerPrecise) < 12.0f || Math.abs((float)this.pos2 - pointerPrecise) > 348.0f) && this.pos2 != Integer.MIN_VALUE) {
                this.pos2 = this.getRandomFreePosition();
                this.completion += this.reward;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posThin1 - pointerPrecise) < 5.0f || Math.abs((float)this.posThin1 - pointerPrecise) > 355.0f) && this.posThin1 != Integer.MIN_VALUE) {
                this.posThin1 = this.getRandomFreePosition();
                this.completion += this.rewardThin;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posThin2 - pointerPrecise) < 5.0f || Math.abs((float)this.posThin2 - pointerPrecise) > 355.0f) && this.posThin2 != Integer.MIN_VALUE) {
                this.posThin2 = this.getRandomFreePosition();
                this.completion += this.rewardThin;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posTreasure - pointerPrecise) < 7.0f || Math.abs((float)this.posTreasure - pointerPrecise) > 353.0f) && this.posTreasure != Integer.MIN_VALUE) {
                this.posTreasure = this.getRandomFreePosition();
                this.treasureProgress += 15;
                hitSomething = true;
            }
            if (hitSomething) {
                level.playLocalSound(pos.x, pos.y, pos.z, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (this.changeRotation) {
                    this.currentRotation *= -1;
                }
            } else {
                level.playLocalSound(pos.x, pos.y, pos.z, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                this.completion -= this.penalty;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void tick() {
        this.pointerPos += (int)(this.speed * (float)this.currentRotation);
        if (this.pointerPos > 360) {
            this.pointerPos -= 360;
        }
        if (this.pointerPos < 0) {
            this.pointerPos += 360;
        }
        ++this.tickCount;
        this.completionSmooth += (int)Math.signum(this.completion - this.completionSmooth);
        this.treasureProgressSmooth += (int)Math.signum(this.treasureProgress - this.treasureProgressSmooth);
        if (this.tickCount % 5 == 0) {
            this.completion -= this.decay;
        }
        if (this.completionSmooth < 0) {
            this.onClose();
        }
        if (this.completionSmooth > 75) {
            PacketDistributor.sendToServer((CustomPacketPayload)new Payloads.FishingCompletedPayload(this.tickCount), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        }
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new Payloads.FishingCompletedPayload(-1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.popGuiLayer();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

