/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandstuff;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.fishingbob.FishingBobEntity;
import com.wdiscute.starcatcher.minigame.FishingMinigameScreen;
import com.wdiscute.starcatcher.networkandstuff.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandstuff.FishProperties;
import com.wdiscute.starcatcher.networkandstuff.ModDataAttachments;
import com.wdiscute.starcatcher.networkandstuff.Payloads;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PayloadReceiver {
    public static void receiveFishingCompletedServer(Payloads.FishingCompletedPayload data, IPayloadContext context) {
        Player player = context.player();
        ServerLevel level = (ServerLevel)context.player().level();
        List entities = level.getEntities(null, new AABB(-25.0, -65.0, -25.0, 25.0, 65.0, 25.0).move(player.position()));
        for (Entity entity : entities) {
            if (!entity.getUUID().toString().equals(player.getData(ModDataAttachments.FISHING.get())) || !(entity instanceof FishingBobEntity)) continue;
            FishingBobEntity fbe = (FishingBobEntity)entity;
            if (data.time() != -1) {
                FishProperties fp = fbe.fpToFish;
                ItemStack is = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(fbe.fpToFish.fish()));
                if (!fp.customName().isEmpty()) {
                    is.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.starcatcher." + fp.customName())));
                }
                ItemEntity itemFished = new ItemEntity((Level)level, fbe.position().x, fbe.position().y + (double)1.2f, fbe.position().z, is);
                double x = (player.position().x - fbe.position().x) / 25.0;
                double y = (player.position().y - fbe.position().y) / 20.0;
                double z = (player.position().z - fbe.position().z) / 25.0;
                x = Math.clamp(x, -1.0, 1.0);
                y = Math.clamp(y, -1.0, 1.0);
                z = Math.clamp(z, -1.0, 1.0);
                Vec3 vec3 = new Vec3(x, 0.7 + y, z);
                itemFished.setDeltaMovement(vec3);
                level.addFreshEntity((Entity)itemFished);
                Vec3 p = player.position();
                level.playSound(null, p.x, p.y, p.z, SoundEvents.VILLAGER_CELEBRATE, SoundSource.AMBIENT);
                if (FishCaughtCounter.AwardFishCaughtCounter(fbe.fpToFish, player) && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new Payloads.FishCaughtPayload(fp), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                player.setData(ModDataAttachments.FISHES_NOTIFICATION, List.of(fbe.fpToFish));
            } else {
                Vec3 p = player.position();
                level.playSound(null, p.x, p.y, p.z, SoundEvents.VILLAGER_NO, SoundSource.AMBIENT);
            }
            fbe.kill();
        }
        player.setData(ModDataAttachments.FISHING.get(), (Object)"");
    }

    public static void receiveFishCaught(Payloads.FishCaughtPayload data, IPayloadContext context) {
        Starcatcher.fishCaughtToast(data.fp());
    }

    public static void receiveFishingClient(Payloads.FishingPayload data, IPayloadContext context) {
        PayloadReceiver.client(data, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void client(Payloads.FishingPayload data, IPayloadContext context) {
        Minecraft.getInstance().setScreen((Screen)new FishingMinigameScreen(data.fp(), data.rod()));
    }
}

