/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.rod;

import com.wdiscute.starcatcher.ModDataComponents;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandstuff.FishProperties;
import com.wdiscute.starcatcher.networkandstuff.ModDataAttachments;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;

public class FishTrackerLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation BACKGROUND = Starcatcher.rl("textures/gui/fishing/fish_tracker.png");
    int uiX;
    int uiY;
    float offScreen = -150.0f;
    Font font;
    int imageWidth = 150;
    int imageHeight = 100;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        this.font = Minecraft.getInstance().font;
        this.uiX = Minecraft.getInstance().getWindow().getGuiScaledWidth() - this.imageWidth;
        this.uiY = Minecraft.getInstance().getWindow().getGuiScaledHeight() - this.imageHeight - 80;
        if (Minecraft.getInstance().level == null) {
            return;
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        boolean shouldShow = false;
        if (player.getMainHandItem().is(ModItems.FISH_SPOTTER) || player.getOffhandItem().is(ModItems.FISH_SPOTTER)) {
            shouldShow = true;
        } else {
            ItemStack is;
            ItemContainerContents icc = (ItemContainerContents)player.getMainHandItem().get(ModDataComponents.BOBBER);
            if (icc != null && (is = icc.copyOne()).is(ModItems.FISH_SPOTTER)) {
                shouldShow = true;
            }
        }
        FishProperties fp = (FishProperties)player.getData(ModDataAttachments.FISH_SPOTTER);
        if (!shouldShow) {
            this.offScreen -= 15.0f * deltaTracker.getGameTimeDeltaTicks();
            if (this.offScreen < -150.0f) {
                this.offScreen = -150.0f;
            }
        } else {
            this.offScreen += 15.0f * deltaTracker.getGameTimeDeltaTicks();
            if (this.offScreen > 0.0f) {
                this.offScreen = 0.0f;
            }
        }
        ItemStack rod = new ItemStack((ItemLike)ModItems.STARCATCHER_FISHING_ROD.get());
        ItemStack bait = ((ItemContainerContents)rod.get(ModDataComponents.BAIT)).copyOne();
        int total = 0;
        for (FishProperties d : level.registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
            total += FishProperties.getChance(d, (Entity)player, rod);
        }
        int specific = FishProperties.getChance(fp, (Entity)player, rod);
        int chance = (int)((float)specific / (float)total * 100.0f);
        ItemStack fishBeingTracked = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(fp.fish()));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(-this.offScreen, 0.0f, 0.0f);
        this.renderImage(guiGraphics, BACKGROUND);
        guiGraphics.renderItem(fishBeingTracked, this.uiX + 50, this.uiY + 10);
        guiGraphics.drawString(Minecraft.getInstance().font, fishBeingTracked.getItem().getDescription(), this.uiX + 70, this.uiY + 15, 0, false);
        guiGraphics.drawString(Minecraft.getInstance().font, chance + "%", this.uiX + 27, this.uiY + 37, 0, false);
        guiGraphics.drawString(Minecraft.getInstance().font, "(" + specific + "/" + total + ")", this.uiX + 20, this.uiY + 47, 0, false);
        MutableComponent comp = Component.literal((String)"Planet").withColor(43520);
        if (!fp.wr().dims().isEmpty() && !fp.wr().dims().contains(level.dimension().location())) {
            comp.withColor(0xAA0000);
        }
        if (fp.wr().dimsBlacklist().contains(level.dimension().location())) {
            comp.withColor(0xAA0000);
        }
        this.drawComp(guiGraphics, (Component)comp, 70, 30);
        comp = Component.literal((String)"Biome").withColor(43520);
        if (!fp.wr().biomes().isEmpty() && !fp.wr().biomes().contains(level.getBiome(player.blockPosition()).getKey().location())) {
            comp.withColor(0xAA0000);
        }
        if (fp.wr().biomesBlacklist().contains(level.getBiome(player.blockPosition()).getKey().location())) {
            comp.withColor(0xAA0000);
        }
        this.drawComp(guiGraphics, (Component)comp, 70, 40);
        comp = Component.literal((String)"Bait").withColor(43520);
        if (fp.br().mustHaveCorrectBait() && !fp.br().correctBait().contains(BuiltInRegistries.ITEM.getKey((Object)bait.getItem()))) {
            comp.withColor(0xAA0000);
        }
        this.drawComp(guiGraphics, (Component)comp, 70, 50);
        comp = Component.literal((String)"Weather").withColor(43520);
        if (fp.weather() == FishProperties.Weather.CLEAR && ((double)level.getRainLevel(0.0f) > 0.5 || (double)level.getThunderLevel(0.0f) > 0.5)) {
            comp.withColor(0xAA0000);
        }
        if (fp.weather() == FishProperties.Weather.RAIN && (double)level.getRainLevel(0.0f) < 0.5) {
            comp.withColor(0xAA0000);
        }
        if (fp.weather() == FishProperties.Weather.THUNDER && (double)level.getThunderLevel(0.0f) < 0.5) {
            comp.withColor(0xAA0000);
        }
        this.drawComp(guiGraphics, (Component)comp, 70, 60);
        comp = Component.literal((String)"Daytime").withColor(43520);
        if (fp.daytime() != FishProperties.Daytime.ALL) {
            long time = level.getDayTime() % 24000L;
            switch (fp.daytime()) {
                case DAY: {
                    if (time > 23000L || time < 12700L) break;
                    comp.withColor(0xAA0000);
                    break;
                }
                case NOON: {
                    if (time > 3500L && time < 8500L) break;
                    comp.withColor(0xAA0000);
                    break;
                }
                case NIGHT: {
                    if (time < 23000L && time > 12700L) break;
                    comp.withColor(0xAA0000);
                    break;
                }
                case MIDNIGHT: {
                    if (time > 16500L && time < 19500L) break;
                    comp.withColor(0xAA0000);
                }
            }
        }
        this.drawComp(guiGraphics, (Component)comp, 70, 70);
        comp = Component.literal((String)"Elevation").withColor(43520);
        if (fp.mustBeCaughtAboveY() != Integer.MIN_VALUE || fp.mustBeCaughtBellowY() != Integer.MAX_VALUE) {
            if (player.position().y > (double)fp.mustBeCaughtBellowY()) {
                comp.withColor(0xAA0000);
            }
            if (player.position().y < (double)fp.mustBeCaughtAboveY()) {
                comp.withColor(0xAA0000);
            }
            this.drawComp(guiGraphics, (Component)comp, 70, 80);
        }
        guiGraphics.pose().popPose();
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    private void drawComp(GuiGraphics guiGraphics, Component comp, int xOffset, int yOffset) {
        guiGraphics.drawString(this.font, comp, this.uiX + xOffset, this.uiY + yOffset, 0, false);
    }
}

