/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.rod;

import com.wdiscute.starcatcher.ModDataComponents;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.ModMenuTypes;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FishingRodMenu
extends AbstractContainerMenu {
    public final ItemStackHandler inventory = new ItemStackHandler(this, 2){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 64;
        }
    };
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 2;

    public FishingRodMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.getMainHandItem());
    }

    public FishingRodMenu(int containerId, Inventory inv, ItemStack itemStack) {
        super(ModMenuTypes.FISHING_ROD_MENU.get(), containerId);
        int i;
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inv, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
        this.inventory.setStackInSlot(0, ((ItemContainerContents)itemStack.get((DataComponentType)ModDataComponents.BOBBER.get())).copyOne());
        this.inventory.setStackInSlot(1, ((ItemContainerContents)itemStack.get((DataComponentType)ModDataComponents.BAIT.get())).copyOne());
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 0, 53, 35));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 1, 107, 35));
    }

    public void removed(Player player) {
        if (!player.level().isClientSide) {
            player.getMainHandItem().set((DataComponentType)ModDataComponents.BOBBER.get(), (Object)ItemContainerContents.fromItems(List.of(this.inventory.getStackInSlot(0).copy())));
            player.getMainHandItem().set((DataComponentType)ModDataComponents.BAIT.get(), (Object)ItemContainerContents.fromItems(List.of(this.inventory.getStackInSlot(1).copy())));
        }
        super.removed(player);
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 38, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 38) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return player.getMainHandItem().is((Item)ModItems.STARCATCHER_FISHING_ROD.get());
    }
}

