/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.blocks;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.wdiscute.starcatcher.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class TrophyBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private TrophyProperties trophyProperties;

    public TrophyBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.TROPHY.get(), pPos, pBlockState);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.trophyProperties = (TrophyProperties)componentInput.getOrDefault((DataComponentType)ModDataComponents.TROPHY.get(), (Object)TrophyProperties.DEFAULT);
        this.setChanged();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(ModDataComponents.TROPHY, (Object)this.trophyProperties);
        if (!this.trophyProperties.customName().equals(TrophyProperties.DEFAULT.customName())) {
            components.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.trophyProperties.customName()));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        TrophyProperties.CODEC.encode((Object)this.trophyProperties, (DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).ifPresent(tag1 -> tag.put("trophy_properties", tag1));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("trophy_properties")) {
            CompoundTag trophyProperties = tag.getCompound("trophy_properties");
            DataResult decode = TrophyProperties.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)trophyProperties);
            this.trophyProperties = decode.result().orElse(TrophyProperties.DEFAULT);
        }
    }
}

