/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.items.ColorfulBobber;
import com.wdiscute.starcatcher.minigame.HitFakeParticle;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.SingleStackContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Random;
import org.joml.Vector2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsScreen
extends Screen {
    private static final Random r = new Random();
    private static final ResourceLocation TEXTURE = Starcatcher.rl("textures/gui/minigame/minigame.png");
    private static final ResourceLocation TANK = Starcatcher.rl("textures/gui/minigame/surface.png");
    private static final ResourceLocation SETTINGS = Starcatcher.rl("textures/gui/minigame/settings.png");
    private static final ResourceLocation GUI_SCALE = Starcatcher.rl("textures/gui/minigame/gui_scale.png");
    private static final int SIZE_1 = 5;
    private static final int SIZE_2 = 7;
    private static final int SIZE_3 = 12;
    private static final int SIZE_4 = 17;
    private static final Logger log = LoggerFactory.getLogger(SettingsScreen.class);
    final FishProperties fp;
    final ItemStack itemBeingFished;
    final ItemStack bobber;
    final ItemStack bait;
    final ItemStack hook;
    float hitDelay;
    float speed;
    int reward;
    int rewardThin;
    int treasureReward;
    int penalty;
    int decay;
    boolean hasTreasure;
    boolean changeRotation;
    boolean moveMarkers = false;
    int gracePeriod = 80;
    final InteractionHand hand;
    int pointerPos = 0;
    float lastHitMarkerPos = 0.0f;
    float lastLastHitMarkerPos = 0.0f;
    float lastLastLastHitMarkerPos = 0.0f;
    int pos1;
    int pos2;
    int posThin1;
    int posThin2;
    int posTreasure;
    int currentRotation = 1;
    float partial;
    int completion = 20;
    int completionSmooth = 20;
    boolean perfectCatch = true;
    int consecutiveHits = 0;
    boolean treasureActive;
    int treasureProgress = Integer.MIN_VALUE;
    int treasureProgressSmooth = Integer.MIN_VALUE;
    int difficultyBobberOffset = 0;
    int bigForgiving = 12;
    int thinForgiving = 5;
    int treasureForgiving = 7;
    int previousGuiScale;
    Units unitSelected;
    int tickCount = 0;
    List<HitFakeParticle> hitParticles = new ArrayList<HitFakeParticle>();

    public SettingsScreen(FishProperties fp, ItemStack rod) {
        super((Component)Component.empty());
        this.previousGuiScale = (Integer)Minecraft.getInstance().options.guiScale().get();
        Minecraft.getInstance().options.guiScale().set((Object)((Integer)Config.MINIGAME_GUI_SCALE.get()));
        this.hitDelay = ((Double)Config.HIT_DELAY.get()).floatValue();
        this.fp = fp;
        this.itemBeingFished = new ItemStack(fp.fish());
        this.bobber = ((SingleStackContainer)rod.get(ModDataComponents.BOBBER)).stack().copy();
        this.bait = ((SingleStackContainer)rod.get(ModDataComponents.BAIT)).stack().copy();
        this.hook = ((SingleStackContainer)rod.get(ModDataComponents.HOOK)).stack().copy();
        this.posTreasure = Integer.MIN_VALUE;
        this.unitSelected = (Units)((Object)Config.UNIT.get());
        FishProperties.Difficulty difficulty = this.hook.is(ModItems.MOSSY_HOOK) && (fp.rarity() == FishProperties.Rarity.COMMON || fp.rarity() == FishProperties.Rarity.UNCOMMON || fp.rarity() == FishProperties.Rarity.RARE) ? FishProperties.Difficulty.HARD : fp.dif();
        this.speed = difficulty.speed();
        this.reward = difficulty.reward();
        this.rewardThin = difficulty.rewardThin();
        this.treasureReward = difficulty.treasure().hitReward();
        this.penalty = difficulty.penalty();
        this.decay = difficulty.decay();
        this.hasTreasure = difficulty.treasure().hasTreasure();
        this.changeRotation = difficulty.extras().isFlip();
        this.pos1 = difficulty.markers().first() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.pos2 = difficulty.markers().second() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        this.posThin1 = difficulty.markers().firstThin() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        int n = this.posThin2 = difficulty.markers().secondThin() ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        if (this.bobber.is(ModItems.STEADY_BOBBER)) {
            this.bigForgiving = 17;
            this.thinForgiving = 7;
            this.treasureForgiving = 7;
            this.difficultyBobberOffset = 16;
        }
        this.hand = Minecraft.getInstance().player.getMainHandItem().is(ModItems.ROD) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    private int getRandomFreePosition() {
        for (int i = 0; i < 100; ++i) {
            int posBeingChecked = r.nextInt(360);
            if ((Math.abs(this.pos1 - posBeingChecked) < 50 || Math.abs(this.pos1 - posBeingChecked) > 310) && this.pos1 != Integer.MIN_VALUE || (Math.abs(this.pos2 - posBeingChecked) < 50 || Math.abs(this.pos2 - posBeingChecked) > 310) && this.pos2 != Integer.MIN_VALUE || (Math.abs(this.posThin1 - posBeingChecked) < 50 || Math.abs(this.posThin1 - posBeingChecked) > 310) && this.posThin1 != Integer.MIN_VALUE || (Math.abs(this.posThin2 - posBeingChecked) < 50 || Math.abs(this.posThin2 - posBeingChecked) > 310) && this.posThin2 != Integer.MIN_VALUE || (Math.abs(this.posTreasure - posBeingChecked) < 50 || Math.abs(this.posTreasure - posBeingChecked) > 310) && this.posTreasure != Integer.MIN_VALUE) continue;
            return posBeingChecked;
        }
        return 0;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float centerY;
        float centerX;
        PoseStack poseStack;
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.partial = partialTick;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int imageWidth = 512;
        int imageHeight = 256;
        int uiX = (this.width - imageWidth) / 2;
        int uiY = (this.height - imageHeight) / 2;
        double x = mouseX - uiX;
        double y = mouseY - uiY;
        guiGraphics.blit(SETTINGS, this.width / 2 - 100, this.height / 2 - 128, 256, 256, 0.0f, 0.0f, 256, 256, 256, 256);
        guiGraphics.blit(GUI_SCALE, this.width / 2 - 50, 0, 100, 50, 0.0f, 0.0f, 100, 50, 100, 50);
        guiGraphics.drawString(this.font, "Move Markers", this.width / 2 + 72, this.height / 2 - 24, 0, false);
        if (this.moveMarkers) {
            guiGraphics.fill(this.width / 2 + 62, this.height / 2 - 22, this.width / 2 + 67, this.height / 2 - 17, -65281);
        }
        guiGraphics.drawString(this.font, "Flip Rotation", this.width / 2 + 72, this.height / 2 - 3, 0, false);
        if (this.changeRotation) {
            guiGraphics.fill(this.width / 2 + 62, this.height / 2 - 2, this.width / 2 + 67, this.height / 2 + 3, -65281);
        }
        if (x > 350.0 && x < 373.0 && y > 39.0 && y < 66.0) {
            ArrayList<MutableComponent> comp = new ArrayList<MutableComponent>();
            comp.add(Component.literal((String)"This screen serves to help those"));
            comp.add(Component.literal((String)"who might be playing on high input setups"));
            comp.add(Component.literal((String)""));
            comp.add(Component.literal((String)"Use the Hit Delay to adjust the number of ticks"));
            comp.add(Component.literal((String)"the minigame will calculate back in time for your input"));
            comp.add(Component.literal((String)""));
            comp.add(Component.literal((String)"For most people, a delay of 0 works fine."));
            comp.add(Component.literal((String)"Play around and see what feels natural to you"));
            guiGraphics.renderTooltip(this.font, comp, Optional.empty(), mouseX, mouseY);
        }
        guiGraphics.drawString(this.font, "Speed: " + this.speed, this.width / 2 + 78, this.height / 2 + 63, 0, false);
        guiGraphics.drawString(this.font, "Hit Delay: " + this.hitDelay, this.width / 2 + 73, this.height / 2 - 53, 0, false);
        guiGraphics.drawString(this.font, "Markers:", this.width / 2 + 63, this.height / 2 + 13, 0, false);
        if (this.pos1 != Integer.MIN_VALUE) {
            guiGraphics.fill(this.width / 2 + 64, this.height / 2 + 27, this.width / 2 + 69, this.height / 2 + 32, -65281);
        }
        if (this.pos2 != Integer.MIN_VALUE) {
            guiGraphics.fill(this.width / 2 + 83, this.height / 2 + 27, this.width / 2 + 88, this.height / 2 + 32, -65281);
        }
        if (this.posThin1 != Integer.MIN_VALUE) {
            guiGraphics.fill(this.width / 2 + 102, this.height / 2 + 27, this.width / 2 + 107, this.height / 2 + 32, -65281);
        }
        if (this.posThin2 != Integer.MIN_VALUE) {
            guiGraphics.fill(this.width / 2 + 121, this.height / 2 + 27, this.width / 2 + 126, this.height / 2 + 32, -65281);
        }
        if (this.posTreasure != Integer.MIN_VALUE) {
            guiGraphics.fill(this.width / 2 + 140, this.height / 2 + 27, this.width / 2 + 145, this.height / 2 + 32, -65281);
        }
        guiGraphics.drawString(this.font, "Steady Bobber", this.width / 2 + 72, this.height / 2 + 43, 0, false);
        if (this.thinForgiving != 5) {
            guiGraphics.fill(this.width / 2 + 62, this.height / 2 + 44, this.width / 2 + 67, this.height / 2 + 49, -65281);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)this.unitSelected.translationKey), this.width / 2 - 50, this.height / 2 + 102, 0, false);
        if (this.treasureActive) {
            guiGraphics.blit(TEXTURE, this.width / 2 - 158, this.height / 2 - 42 + (int)(64.0f - 64.0f * (float)this.treasureProgressSmooth / 100.0f), 5, 64 * this.treasureProgressSmooth / 100, 141.0f, 70.0f - (float)(64 * this.treasureProgressSmooth) / 100.0f, 5, 64 * this.treasureProgressSmooth / 100, 256, 256);
            guiGraphics.blit(TEXTURE, this.width / 2 - 16 - 155, this.height / 2 - 48, 32, 96, 96.0f, 0.0f, 32, 96, 256, 256);
        }
        guiGraphics.blit(TANK, this.width / 2 - 42 - 100, this.height / 2 - 48, 85, 97, 0.0f, 0.0f, 85, 97, 85, 97);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32, 64, 64, 0.0f, 192.0f, 64, 64, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 16, this.height / 2 + 40, 32, 16, 0.0f, 112.0f, 32, 16, 256, 256);
        if (this.pos1 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.pos1)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, (float)(16 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        if (this.pos2 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.pos2)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, (float)(16 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        if (this.posThin1 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.posThin1)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, (float)(48 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        if (this.posThin2 != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.posThin2)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, (float)(48 - this.difficultyBobberOffset), 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        if (this.posTreasure != Integer.MIN_VALUE) {
            poseStack = guiGraphics.pose();
            poseStack.pushPose();
            centerX = (float)this.width / 2.0f;
            centerY = (float)this.height / 2.0f;
            poseStack.translate(centerX, centerY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.posTreasure)));
            poseStack.translate(-centerX, -centerY, 0.0f);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8 - 25, 16, 16, 64.0f, 160.0f, 16, 16, 256, 256);
            poseStack.popPose();
        }
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32, 64, 64, 64.0f, 192.0f, 64, 64, 256, 256);
        poseStack = guiGraphics.pose();
        poseStack.pushPose();
        centerX = (float)this.width / 2.0f;
        centerY = (float)this.height / 2.0f;
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians((float)this.pointerPos + this.speed * partialTick * (float)this.currentRotation)));
        poseStack.translate(-centerX, -centerY, 0.0f);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32 - 16, 64, 64, 128.0f, 192.0f, 64, 64, 256, 256);
        poseStack.popPose();
        poseStack = guiGraphics.pose();
        poseStack.pushPose();
        centerX = (float)this.width / 2.0f;
        centerY = (float)this.height / 2.0f;
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.lastHitMarkerPos)));
        poseStack.translate(-centerX, -centerY, 0.0f);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32 - 16, 64, 64, 128.0f, 128.0f, 64, 64, 256, 256);
        poseStack.popPose();
        poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        centerX = (float)this.width / 2.0f;
        centerY = (float)this.height / 2.0f;
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.lastLastHitMarkerPos)));
        poseStack.translate(-centerX, -centerY, 0.0f);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32 - 16, 64, 64, 192.0f, 128.0f, 64, 64, 256, 256);
        RenderSystem.disableBlend();
        poseStack.popPose();
        poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        centerX = (float)this.width / 2.0f;
        centerY = (float)this.height / 2.0f;
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(this.lastLastLastHitMarkerPos)));
        poseStack.translate(-centerX, -centerY, 0.0f);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32, this.height / 2 - 32 - 16, 64, 64, 192.0f, 64.0f, 64, 64, 256, 256);
        RenderSystem.disableBlend();
        poseStack.popPose();
        guiGraphics.blit(TEXTURE, this.width / 2 - 16, this.height / 2 - 16, 32, 32, 208.0f, 208.0f, 32, 32, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 32 - 70, this.height / 2 - 24 - 57, 64, 48, 192.0f, 0.0f, 64, 48, 256, 256);
        guiGraphics.blit(TEXTURE, this.width / 2 - 6 - 102, this.height / 2 - 56 - 18, 16, 112 - this.completionSmooth, 176.0f, (float)(0 + this.completionSmooth), 16, 112 - this.completionSmooth, 256, 256);
        guiGraphics.renderItem(this.itemBeingFished, this.width / 2 - 8 - 100, this.height / 2 - 8 + 35 - this.completionSmooth);
        for (HitFakeParticle instance : this.hitParticles) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(instance.pos.x, instance.pos.y, 0.0);
            RenderSystem.setShaderColor((float)instance.r, (float)instance.g, (float)instance.b, (float)instance.a);
            guiGraphics.blit(TEXTURE, this.width / 2 - 8, this.height / 2 - 8, 16, 16, 80.0f, 160.0f, 16, 16, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.pose().popPose();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int current;
        super.mouseClicked(mouseX, mouseY, button);
        int imageWidth = 512;
        int imageHeight = 256;
        int uiX = (this.width - imageWidth) / 2;
        int uiY = (this.height - imageHeight) / 2;
        double x = mouseX - (double)uiX;
        double y = mouseY - (double)uiY;
        if (x > 226.0 && x < 240.0 && mouseY > 20.0 && mouseY < 50.0 && (current = ((Integer)Minecraft.getInstance().options.guiScale().get()).intValue()) > 1) {
            Minecraft.getInstance().options.guiScale().set((Object)(current - 1));
        }
        if (x > 267.0 && x < 280.0 && mouseY > 20.0 && mouseY < 50.0) {
            current = (Integer)Minecraft.getInstance().options.guiScale().get();
            Minecraft.getInstance().options.guiScale().set((Object)(current + 1));
        }
        if (x > 316.0 && x < 328.0 && y > 105.0 && y < 112.0) {
            boolean bl = this.moveMarkers = !this.moveMarkers;
        }
        if (x > 316.0 && x < 328.0 && y > 172.0 && y < 180.0) {
            if (this.thinForgiving == 5) {
                this.thinForgiving = 7;
                this.bigForgiving = 17;
                this.difficultyBobberOffset = 16;
            } else {
                this.thinForgiving = 5;
                this.bigForgiving = 12;
                this.difficultyBobberOffset = 0;
            }
        }
        if (x > 316.0 && x < 328.0 && y > 125.0 && y < 145.0) {
            boolean bl = this.changeRotation = !this.changeRotation;
        }
        if (x > 316.0 && x < 330.0 && y > 185.0 && y < 225.0) {
            this.speed -= 1.0f;
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
        }
        if (x > 395.0 && x < 410.0 && y > 185.0 && y < 225.0) {
            this.speed += 1.0f;
        }
        if (x > 316.0 && x < 325.0 && y > 70.0 && y < 100.0) {
            this.hitDelay = (float)((int)(this.hitDelay * 10.0f)) / 10.0f;
            this.hitDelay -= 0.2f;
            this.hitDelay = (float)((int)(this.hitDelay * 10.0f)) / 10.0f;
        }
        if (x > 396.0 && x < 410.0 && y > 70.0 && y < 100.0) {
            this.hitDelay = (float)((int)(this.hitDelay * 10.0f)) / 10.0f;
            this.hitDelay += 0.2f;
            this.hitDelay = (float)((int)(this.hitDelay * 10.0f)) / 10.0f;
        }
        if (x > 312.0 && x < 330.0 && y > 226.0 && y < 240.0) {
            this.unitSelected = this.unitSelected.next();
            Config.UNIT.set((Object)this.unitSelected);
            Config.UNIT.save();
        }
        if (x > 193.0 && x < 205.0 && y > 226.0 && y < 240.0) {
            this.unitSelected = this.unitSelected.previous();
            Config.UNIT.set((Object)this.unitSelected);
            Config.UNIT.save();
        }
        if (x > 319.0 && x < 330.0 && y > 153.0 && y < 166.0) {
            this.pos1 = this.pos1 == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        if (x > 338.0 && x < 349.0 && y > 153.0 && y < 166.0) {
            this.pos2 = this.pos2 == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        if (x > 357.0 && x < 368.0 && y > 153.0 && y < 166.0) {
            this.posThin1 = this.posThin1 == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        if (x > 376.0 && x < 387.0 && y > 153.0 && y < 166.0) {
            this.posThin2 = this.posThin2 == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        if (x > 395.0 && x < 406.0 && y > 153.0 && y < 166.0) {
            this.posTreasure = this.posTreasure == Integer.MIN_VALUE ? this.getRandomFreePosition() : Integer.MIN_VALUE;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        if (keyCode == Minecraft.getInstance().options.keyJump.getKey().getValue()) {
            if (this.gracePeriod > 0) {
                this.gracePeriod = 0;
            }
            Minecraft.getInstance().player.swing(this.hand, true);
            boolean hitSomething = false;
            Vec3 pos = Minecraft.getInstance().player.position();
            ClientLevel level = Minecraft.getInstance().level;
            float pointerPosPrecise = (float)this.pointerPos + this.speed * this.partial * (float)this.currentRotation;
            this.lastLastLastHitMarkerPos = this.lastLastHitMarkerPos;
            this.lastLastHitMarkerPos = this.lastHitMarkerPos;
            this.lastHitMarkerPos = pointerPosPrecise += this.hitDelay * this.speed * (float)this.currentRotation;
            if ((Math.abs((float)this.pos1 - pointerPosPrecise) < (float)this.bigForgiving || Math.abs((float)this.pos1 - pointerPosPrecise) > (float)(360 - this.bigForgiving)) && this.pos1 != Integer.MIN_VALUE) {
                this.addParticles(this.pos1, 15);
                if (this.moveMarkers) {
                    this.pos1 = this.getRandomFreePosition();
                }
                this.completion += this.reward;
                hitSomething = true;
            }
            if ((Math.abs((float)this.pos2 - pointerPosPrecise) < (float)this.bigForgiving || Math.abs((float)this.pos2 - pointerPosPrecise) > (float)(360 - this.bigForgiving)) && this.pos2 != Integer.MIN_VALUE) {
                this.addParticles(this.pos2, 15);
                if (this.moveMarkers) {
                    this.pos2 = this.getRandomFreePosition();
                }
                this.completion += this.reward;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posThin1 - pointerPosPrecise) < (float)this.thinForgiving || Math.abs((float)this.posThin1 - pointerPosPrecise) > (float)(360 - this.thinForgiving)) && this.posThin1 != Integer.MIN_VALUE) {
                this.addParticles(this.posThin1, 30);
                if (this.moveMarkers) {
                    this.posThin1 = this.getRandomFreePosition();
                }
                this.completion += this.rewardThin;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posThin2 - pointerPosPrecise) < (float)this.thinForgiving || Math.abs((float)this.posThin2 - pointerPosPrecise) > (float)(360 - this.thinForgiving)) && this.posThin2 != Integer.MIN_VALUE) {
                this.addParticles(this.posThin2, 30);
                if (this.moveMarkers) {
                    this.posThin2 = this.getRandomFreePosition();
                }
                this.completion += this.rewardThin;
                hitSomething = true;
            }
            if ((Math.abs((float)this.posTreasure - pointerPosPrecise) < (float)this.treasureForgiving || Math.abs((float)this.posTreasure - pointerPosPrecise) > (float)(360 - this.treasureForgiving)) && this.posTreasure != Integer.MIN_VALUE) {
                this.addParticles(this.posTreasure, 30, true);
                if (this.moveMarkers) {
                    this.posTreasure = this.getRandomFreePosition();
                }
                this.treasureProgress += this.treasureReward;
                hitSomething = true;
            }
            if (hitSomething) {
                ++this.consecutiveHits;
                if (this.hook.is(ModItems.STONE_HOOK)) {
                    if (this.fp.rarity() == FishProperties.Rarity.COMMON) {
                        this.gracePeriod = 40;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.UNCOMMON) {
                        this.gracePeriod = 20;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.RARE) {
                        this.gracePeriod = 15;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.EPIC) {
                        this.gracePeriod = 10;
                    }
                    if (this.fp.rarity() == FishProperties.Rarity.LEGENDARY) {
                        this.gracePeriod = 5;
                    }
                }
                level.playLocalSound(pos.x, pos.y, pos.z, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (this.changeRotation) {
                    this.currentRotation *= -1;
                }
            } else {
                this.consecutiveHits = 0;
                level.playLocalSound(pos.x, pos.y, pos.z, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                this.completion -= this.penalty;
                this.perfectCatch = false;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void tick() {
        this.pointerPos += (int)(this.speed * (float)this.currentRotation);
        if (this.pointerPos > 360) {
            this.pointerPos -= 360;
        }
        if (this.pointerPos < 0) {
            this.pointerPos += 360;
        }
        --this.gracePeriod;
        ++this.tickCount;
        this.completionSmooth += (int)Math.signum(this.completion - this.completionSmooth);
        this.completionSmooth += (int)Math.signum(this.completion - this.completionSmooth);
        this.treasureProgressSmooth += (int)Math.signum(this.treasureProgress - this.treasureProgressSmooth);
        if (this.tickCount % 5 == 0 && this.gracePeriod < 0) {
            this.completion -= this.decay;
        }
        if (this.completionSmooth < 0) {
            this.completion = 0;
            this.completionSmooth = 0;
        }
        if (this.treasureProgressSmooth > 100) {
            this.posTreasure = Integer.MIN_VALUE;
        }
        if (this.completionSmooth > 75) {
            this.completion = 75;
            this.completionSmooth = 75;
        }
        this.hitParticles.removeIf(HitFakeParticle::tick);
    }

    public void onClose() {
        Config.HIT_DELAY.set((Object)this.hitDelay);
        Config.HIT_DELAY.save();
        Config.MINIGAME_GUI_SCALE.set((Object)((Integer)Minecraft.getInstance().options.guiScale().get()));
        Config.MINIGAME_GUI_SCALE.save();
        Minecraft.getInstance().options.guiScale().set((Object)this.previousGuiScale);
        this.minecraft.popGuiLayer();
    }

    private void addParticles(int posInDegrees, int count) {
        this.addParticles(posInDegrees, count, false);
    }

    private void addParticles(int posInDegrees, int count, boolean treasure) {
        int xPos = (int)(30.0 * Math.cos(Math.toRadians(posInDegrees - 90)));
        int yPos = (int)(30.0 * Math.sin(Math.toRadians(posInDegrees - 90)));
        for (int i = 0; i < count; ++i) {
            if (this.bobber.is(ModItems.GLITTER_BOBBER)) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), r.nextFloat(), r.nextFloat(), r.nextFloat(), 1.0f));
                continue;
            }
            if (this.bobber.is(ModItems.COLORFUL_BOBBER)) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), ((ColorfulBobber.BobberColor)this.bobber.get(ModDataComponents.BOBBER_COLOR)).r(), ((ColorfulBobber.BobberColor)this.bobber.get(ModDataComponents.BOBBER_COLOR)).g(), ((ColorfulBobber.BobberColor)this.bobber.get(ModDataComponents.BOBBER_COLOR)).b(), 1.0f));
                continue;
            }
            if (treasure) {
                this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f)), 0.7f + r.nextFloat() / 3.0f, 0.5f, 0.5f, 1.0f));
                continue;
            }
            this.hitParticles.add(new HitFakeParticle(xPos, yPos, new Vector2d((double)(r.nextFloat() * 2.0f - 1.0f), (double)(r.nextFloat() * 2.0f - 1.0f))));
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static enum Units {
        METRIC("gui.guide.units.metric", 1.0f, 1.0f),
        IMPERIAL("gui.guide.units.imperial", 0.3937f, 0.03527396f),
        CHEESEBURGER("gui.guide.units.cheeseburger", 0.09f, 0.0087f),
        FOOTBALL("gui.guide.units.football", 0.04545f, 0.00233f),
        DEVELOPER_HEIGHT("gui.guide.units.developer", 0.00592f, 1.40845E-5f),
        BANANA("gui.guide.units.banana", 0.05f, 0.00833f),
        DUCK("gui.guide.units.duck", 0.02f, 6.667E-4f),
        SPACE_WHALE("gui.guide.units.space_whale", 1.0f, 1.0f),
        SCIENTIFIC("gui.guide.units.scientific", 1.0f, 1.0f);

        private static final Units[] vals;
        private final String translationKey;
        private final float multiplierSize;
        private final float multiplierWeight;

        private Units(String translationKey, float multiplierSize, float multiplierWeight) {
            this.translationKey = translationKey;
            this.multiplierSize = multiplierSize;
            this.multiplierWeight = multiplierWeight;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public float getMultiplierSize() {
            return this.multiplierSize;
        }

        public float getMultiplierWeight() {
            return this.multiplierWeight;
        }

        public Units next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        public Units previous() {
            if (this.ordinal() == 0) {
                return vals[vals.length - 1];
            }
            return vals[(this.ordinal() - 1) % vals.length];
        }

        public String getSizeAsString(int sizeInCm) {
            if (this.equals((Object)SPACE_WHALE)) {
                return "\u221e space whales";
            }
            if (this.equals((Object)SCIENTIFIC)) {
                return "0 AU";
            }
            float size = (float)sizeInCm * this.getMultiplierSize();
            String sizeString = (float)((int)(size * 100.0f)) / 100.0f + " " + I18n.get((String)(this.getTranslationKey() + ".size"), (Object[])new Object[0]);
            if (this.equals((Object)METRIC)) {
                sizeString = (int)size + "cm";
                if (size > 100.0f) {
                    sizeString = (float)((int)(size / 100.0f * 100.0f)) / 100.0f + "m";
                }
            }
            if (this.equals((Object)IMPERIAL)) {
                sizeString = (int)size + "''";
                if (size > 12.0f) {
                    sizeString = (int)(size / 12.0f) + "'" + (int)(size % 12.0f) + "''";
                }
            }
            return sizeString;
        }

        public String getWeightAsString(int weightInGrams) {
            if (this.equals((Object)SPACE_WHALE)) {
                return "\u221e space whales";
            }
            if (this.equals((Object)SCIENTIFIC)) {
                return "0 R136a1's";
            }
            float weight = (float)weightInGrams * this.getMultiplierWeight();
            String weightString = (float)((int)(weight * 100.0f)) / 100.0f + " " + I18n.get((String)(this.getTranslationKey() + ".weight"), (Object[])new Object[0]);
            if (this.equals((Object)METRIC)) {
                if (weight < 1000.0f) {
                    weightString = (int)weight + "g";
                }
                if (weight > 1000.0f) {
                    weightString = (float)((int)(weight / 1000.0f * 100.0f)) / 100.0f + "kg";
                }
            }
            if (this.equals((Object)IMPERIAL)) {
                weightString = (int)weight + "oz";
                if (weight > 12.0f) {
                    weightString = (int)(weight / 16.0f) + " lb " + (int)(weight % 16.0f) + " oz";
                }
            }
            return weightString;
        }

        static {
            vals = Units.values();
        }
    }
}

