/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.libtooltips.Tooltips;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class FishingGuideScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = Starcatcher.rl("textures/gui/guide/background.png");
    private static final ResourceLocation HELP_PAGE_1 = Starcatcher.rl("textures/gui/guide/help_1.png");
    private static final ResourceLocation HELP_PAGE_2 = Starcatcher.rl("textures/gui/guide/help_2.png");
    private static final ResourceLocation ARROW_PREVIOUS = Starcatcher.rl("textures/gui/guide/arrow_previous.png");
    private static final ResourceLocation ARROW_PREVIOUS_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_previous_pressed.png");
    private static final ResourceLocation ARROW_PREVIOUS_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_previous_highlight.png");
    private static final ResourceLocation ARROW_NEXT = Starcatcher.rl("textures/gui/guide/arrow_next.png");
    private static final ResourceLocation ARROW_NEXT_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_next_pressed.png");
    private static final ResourceLocation ARROW_NEXT_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_next_highlight.png");
    private static final ResourceLocation ARROW_INDEX = Starcatcher.rl("textures/gui/guide/arrow_index.png");
    private static final ResourceLocation ARROW_INDEX_PRESSED = Starcatcher.rl("textures/gui/guide/arrow_index_pressed.png");
    private static final ResourceLocation ARROW_INDEX_HIGHLIGHT = Starcatcher.rl("textures/gui/guide/arrow_index_highlight.png");
    private static final ResourceLocation STAR = Starcatcher.rl("textures/gui/guide/star.png");
    private static final ResourceLocation GLOW = Starcatcher.rl("textures/gui/guide/glow.png");
    private static final int MAX_HELP_PAGES = 4;
    private final ItemStack basics;
    private final ItemStack treasures;
    private final ItemStack ironHook;
    private final ItemStack shinyHook;
    private final ItemStack goldHook;
    private final ItemStack mossyHook;
    private final ItemStack crystalHook;
    private final ItemStack stoneHook;
    private final ItemStack splitHook;
    private final ItemStack frugalBobber;
    private final ItemStack creeperBobber;
    private final ItemStack glitterBobber;
    private final ItemStack colorfulBobber;
    private final ItemStack steadyBobber;
    private final ItemStack impatientBobber;
    private final ItemStack frogBobber;
    private final ItemStack fishSpotter;
    private final ItemStack trophies;
    private final ItemStack secrets;
    int uiX;
    int uiY;
    int imageWidth;
    int imageHeight;
    int clickedX;
    int clickedY;
    int clickedXDown;
    int clickedYDown;
    boolean arrowPreviousPressed;
    boolean arrowNextPressed;
    boolean arrowIndexPressed;
    int menu = 0;
    int page = 0;
    boolean hasNextEntryPage;
    ClientLevel level;
    LocalPlayer player;
    List<FishProperties> fpsSeen = new ArrayList<FishProperties>();
    List<FishProperties> entries = new ArrayList<FishProperties>(999);
    List<TrophyProperties> tps = new ArrayList<TrophyProperties>();
    List<FishProperties> fishInArea = new ArrayList<FishProperties>();
    List<FishCaughtCounter> fishCaughtCounterList = new ArrayList<FishCaughtCounter>();

    protected void init() {
        super.init();
        this.entries = new ArrayList<FishProperties>(999);
        this.tps = new ArrayList<TrophyProperties>(999);
        this.imageWidth = 512;
        this.imageHeight = 256;
        this.uiX = (this.width - this.imageWidth) / 2;
        this.uiY = (this.height - this.imageHeight) / 2;
        this.level = Minecraft.getInstance().level;
        this.player = Minecraft.getInstance().player;
        for (FishProperties fp : FishProperties.getFPs((Level)this.level)) {
            if (!fp.hasGuideEntry()) continue;
            this.entries.add(fp);
        }
        for (TrophyProperties tp : this.level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY)) {
            if (tp.type() != TrophyProperties.TrophyType.TROPHY) continue;
            this.tps.add(tp);
        }
        this.fishInArea = FishProperties.getFpsWithGuideEntryForArea((Entity)this.player);
        this.fishCaughtCounterList = (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        this.arrowIndexPressed = false;
        this.arrowNextPressed = false;
        this.arrowPreviousPressed = false;
        if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0) {
            if (this.menu == 0 && this.page != 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                --this.page;
                return true;
            }
            if (this.menu == 1 && this.page == 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 0;
                this.page = 0;
                return true;
            }
            if (this.menu == 1) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                --this.page;
                return true;
            }
            if (this.menu == 2 && this.page == 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 4;
                return true;
            }
            if (this.menu == 2) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                --this.page;
                return true;
            }
        }
        if (x > 420.0 && x < 440.0 && y > 230.0 && y < 240.0) {
            if (this.menu == 0 && this.hasNextEntryPage) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                ++this.page;
                return true;
            }
            if (this.menu == 0) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 0;
                return true;
            }
            if (this.menu == 1 && this.page != 4) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                ++this.page;
                return true;
            }
            if (this.menu == 1) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 2;
                this.page = 0;
                return true;
            }
            if (this.menu == 2 && this.page <= this.entries.size() / 2 - 1) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                ++this.page;
                return true;
            }
            if (this.menu == 2) {
                return true;
            }
        }
        if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            this.menu = 0;
            this.page = 0;
            return true;
        }
        if (this.menu == 0 && button == 0) {
            this.clickedX = (int)mouseX;
            this.clickedY = (int)mouseY;
            this.clickedXDown = 0;
            this.clickedYDown = 0;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double x = mouseX - (double)this.uiX;
        double y = mouseY - (double)this.uiY;
        if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0 && (this.menu != 0 || this.page != 0)) {
            this.arrowPreviousPressed = true;
        }
        if (x > 420.0 && x < 440.0 && y > 230.0 && y < 240.0 && this.page <= this.entries.size() / 2 - 1) {
            this.arrowNextPressed = true;
        }
        if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
            this.arrowIndexPressed = true;
        }
        if (this.page == 0 && button == 0) {
            this.clickedXDown = (int)mouseX;
            this.clickedYDown = (int)mouseY;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderImage(guiGraphics, BACKGROUND);
        if (this.menu == 0) {
            this.renderIndex(guiGraphics, mouseX, mouseY);
        }
        if (this.menu == 1) {
            this.renderTheBasics(guiGraphics, mouseX, mouseY);
        }
        if (this.menu == 2) {
            this.renderEntry(guiGraphics, mouseX, mouseY, 70, this.page * 2);
            this.renderEntry(guiGraphics, mouseX, mouseY, 276, this.page * 2 + 1);
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.menu != 0 || this.page != 0) {
            if (x > 65.0 && x < 95.0 && y > 225.0 && y < 240.0) {
                guiGraphics.blit(ARROW_PREVIOUS_HIGHLIGHT, this.uiX + 65, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            }
            ResourceLocation previous = this.arrowPreviousPressed ? ARROW_PREVIOUS_PRESSED : ARROW_PREVIOUS;
            guiGraphics.blit(previous, this.uiX + 65, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            if (x > 225.0 && x < 245.0 && y > 223.0 && y < 243.0) {
                guiGraphics.blit(ARROW_INDEX_HIGHLIGHT, this.uiX + 225, this.uiY + 223, 0.0f, 0.0f, 20, 20, 20, 20);
            }
            ResourceLocation index = this.arrowIndexPressed ? ARROW_INDEX_PRESSED : ARROW_INDEX;
            guiGraphics.blit(index, this.uiX + 225, this.uiY + 223, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        if (this.page <= this.entries.size() / 2 - 1) {
            if (x > 420.0 && x < 442.0 && y > 227.0 && y < 242.0) {
                guiGraphics.blit(ARROW_NEXT_HIGHLIGHT, this.uiX + 420, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
            }
            ResourceLocation next = this.arrowNextPressed ? ARROW_NEXT_PRESSED : ARROW_NEXT;
            guiGraphics.blit(next, this.uiX + 420, this.uiY + 227, 0.0f, 0.0f, 23, 13, 23, 13);
        }
        this.clickedX = 0;
        this.clickedY = 0;
    }

    private void renderHelpTitle(GuiGraphics guiGraphics, ItemStack is, Component comp, int x, int y) {
        this.renderItem(is, this.uiX + x + 10, this.uiY + y + 10, 2);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(2.0f, 2.0f, 2.0f);
        guiGraphics.drawString(this.font, comp, this.uiX / 2 + x / 2 + 23, this.uiY / 2 + y / 2 + 6, -16777216, false);
        guiGraphics.pose().popPose();
        guiGraphics.renderOutline(this.uiX + x - 2, this.uiY + y - 2, 40, 40, -16777216);
        guiGraphics.renderOutline(this.uiX + x - 1, this.uiY + y - 1, 38, 38, -16777216);
    }

    private void renderHelpText(GuiGraphics guiGraphics) {
        Component comp;
        int i;
        for (i = 0; i < 40 && I18n.exists((String)("gui.guide.page" + this.page + ".left." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey((String)("gui.guide.page" + this.page + ".left." + i));
            guiGraphics.drawString(this.font, comp, this.uiX + 70, this.uiY + 10 * i + 10, -16777216, false);
        }
        for (i = 0; i < 40 && I18n.exists((String)("gui.guide.page" + this.page + ".right." + i)); ++i) {
            comp = Tooltips.decodeTranslationKey((String)("gui.guide.page" + this.page + ".right." + i));
            guiGraphics.drawString(this.font, comp, this.uiX + 278, this.uiY + 10 * i + 10, -16777216, false);
        }
    }

    private void renderItemWithOutlineAndHover(GuiGraphics guiGraphics, ItemStack is, int x, int y, int mouseX, int mouseY) {
        this.renderItem(is, this.uiX + x, this.uiY + y, 1);
        guiGraphics.renderOutline(this.uiX + x - 2, this.uiY + y - 2, 20, 20, -16777216);
        if (mouseX > this.uiX + x - 2 && mouseX < this.uiX + x - 2 + 20 && mouseY > this.uiY + y - 2 - 2 && mouseY < this.uiY + y - 2 + 20) {
            guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
        }
    }

    private void renderTps(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int i = 0; i < this.tps.size(); ++i) {
            ItemStack is;
            int rowSize = Math.min(7, this.tps.size() - i / 7 * 7);
            int x = 90 - rowSize * 23 / 2;
            int xrender = x + i % 7 * 23;
            int y = i / 7 * 25;
            xrender += this.uiX + 280;
            y += this.uiY + 160;
            TrophyProperties tp = this.tps.get(i);
            if (((List)this.player.getData(ModDataAttachments.TROPHIES_CAUGHT)).contains(tp)) {
                is = new ItemStack(tp.baseItem());
                is.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)tp.customName()));
                is.set(ModDataComponents.TROPHY, (Object)tp);
            } else {
                is = new ItemStack((ItemLike)ModItems.MISSINGNO.get());
            }
            guiGraphics.renderOutline(xrender - 10, y - 2, 20, 20, -16777216);
            this.renderItem(is, xrender - 8, y, 1);
            if (mouseX <= xrender - 10 || mouseX >= xrender + 10 || mouseY <= y - 2 || mouseY >= y + 18) continue;
            guiGraphics.renderTooltip(this.font, is, mouseX, mouseY);
        }
    }

    private void renderTheBasics(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderHelpText(guiGraphics);
        if (this.page == 0) {
            this.renderImage(guiGraphics, HELP_PAGE_1);
            this.renderHelpTitle(guiGraphics, this.basics, (Component)Component.translatable((String)"gui.guide.basics"), 70, 15);
        }
        if (this.page == 1) {
            this.renderImage(guiGraphics, HELP_PAGE_2);
            this.renderHelpTitle(guiGraphics, this.treasures, (Component)Component.translatable((String)"gui.guide.treasures"), 70, 15);
        }
        if (this.page == 2) {
            this.renderHelpTitle(guiGraphics, this.ironHook, (Component)Component.translatable((String)"gui.guide.hooks"), 70, 15);
            this.renderItemWithOutlineAndHover(guiGraphics, this.ironHook, 85, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.goldHook, 125, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.shinyHook, 165, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.crystalHook, 205, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.mossyHook, 105, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.splitHook, 145, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.stoneHook, 185, 200, mouseX, mouseY);
            this.renderHelpTitle(guiGraphics, this.frugalBobber, (Component)Component.translatable((String)"gui.guide.bobbers"), 280, 15);
            this.renderItemWithOutlineAndHover(guiGraphics, this.creeperBobber, 288, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.glitterBobber, 328, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.colorfulBobber, 368, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.frugalBobber, 408, 170, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.steadyBobber, 308, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.impatientBobber, 348, 200, mouseX, mouseY);
            this.renderItemWithOutlineAndHover(guiGraphics, this.frogBobber, 388, 200, mouseX, mouseY);
        }
        if (this.page == 3) {
            this.renderHelpTitle(guiGraphics, this.fishSpotter, (Component)Component.translatable((String)"gui.guide.gadgets"), 70, 15);
            this.renderItemWithOutlineAndHover(guiGraphics, this.fishSpotter, 150, 170, mouseX, mouseY);
            this.renderHelpTitle(guiGraphics, this.trophies, (Component)Component.translatable((String)"gui.guide.trophies"), 280, 15);
            this.renderTps(guiGraphics, mouseX, mouseY);
        }
        if (this.page == 4) {
            this.renderHelpTitle(guiGraphics, this.secrets, (Component)Component.translatable((String)"gui.guide.secrets"), 70, 15);
            this.renderHelpText(guiGraphics);
        }
    }

    private void renderIndex(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = this.uiX + 70;
        int y = this.uiY + 30;
        int columnNumber = -1;
        int rowNumber = -1;
        int semiPageNumber = -this.page * 2;
        this.hasNextEntryPage = false;
        if (this.page == 0) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.fishing"), x + 25 + columnNumber * 25 + semiPageNumber * 205, y + 10 + rowNumber * 25, 0, false);
            ++rowNumber;
            int auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.renderOutline(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(new ItemStack((ItemLike)ModItems.ROD.get()), x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.guide.basics"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 0;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.renderOutline(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(new ItemStack((ItemLike)ModItems.WATERLOGGED_SATCHEL.get()), x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.guide.treasures"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 1;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.renderOutline(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(new ItemStack((ItemLike)ModItems.HOOK.get()), x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.guide.hooks"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 2;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.renderOutline(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(new ItemStack((ItemLike)ModItems.FRUGAL_BOBBER.get()), x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.guide.bobbers"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 2;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.renderOutline(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(new ItemStack((ItemLike)ModItems.FISH_SPOTTER.get()), x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.guide.gadgets"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 3;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.renderOutline(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(new ItemStack((ItemLike)ModItems.TROPHY_GOLD.get()), x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.guide.trophies"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 3;
            }
            auxX = x - 2 + ++columnNumber * 25;
            guiGraphics.renderOutline(auxX, y - 2, 20, 20, -16777216);
            this.renderItem(new ItemStack((ItemLike)ModItems.WATERLOGGED_BOTTLE.get()), x + columnNumber * 25, y, 1);
            if (mouseX > auxX && mouseX < auxX + 20 && mouseY > y - 2 && mouseY < y + 20) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.guide.secrets"), mouseX, mouseY);
            }
            if (this.clickedX > auxX && this.clickedX < auxX + 20 && this.clickedY > y - 2 && this.clickedY < y + 20) {
                this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
                this.menu = 1;
                this.page = 4;
            }
        } else {
            ++rowNumber;
        }
        ++rowNumber;
        columnNumber = -1;
        if (this.page == 0) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.available"), x + 25 + columnNumber * 25 + semiPageNumber * 205, y + 10 + rowNumber * 25, 0, false);
        }
        ++rowNumber;
        for (FishProperties fp : this.fishInArea) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, x + columnNumber * 25 + semiPageNumber * 205, y + rowNumber * 25, mouseX, mouseY, fp);
        }
        columnNumber = -1;
        if (++rowNumber > 6) {
            rowNumber = 0;
            ++semiPageNumber;
        }
        if (this.page == 0) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.all"), x + 25 + columnNumber * 25 + semiPageNumber * 205, y + 10 + rowNumber * 25, 0, false);
        }
        ++rowNumber;
        for (FishProperties fp : this.entries) {
            if (++columnNumber > 6) {
                ++rowNumber;
                columnNumber = 0;
            }
            if (rowNumber > 7) {
                ++semiPageNumber;
                rowNumber = 0;
            }
            if (semiPageNumber > 1) break;
            if (semiPageNumber < 0) continue;
            this.renderFishIndex(guiGraphics, x + columnNumber * 25 + semiPageNumber * 205, y + rowNumber * 25, mouseX, mouseY, fp);
        }
        if (semiPageNumber > 1) {
            this.hasNextEntryPage = true;
        }
    }

    private void renderFishIndex(GuiGraphics guiGraphics, int xOffset, int yOffset, int mouseX, int mouseY, FishProperties fp) {
        List fishCounterList = (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT);
        ItemStack is = new ItemStack(fp.fish());
        int caught = 0;
        for (FishCaughtCounter f : fishCounterList) {
            if (!fp.equals(f.fp())) continue;
            caught = f.count();
            break;
        }
        if (this.clickedX > xOffset - 3 && this.clickedX < xOffset + 21 - 3 && this.clickedY > yOffset - 3 && this.clickedY < yOffset + 21 - 3) {
            this.minecraft.player.playSound(SoundEvents.BOOK_PAGE_TURN);
            this.menu = 2;
            this.page = this.entries.indexOf(fp) / 2;
        }
        int outlineColor = -15654349;
        if (this.clickedXDown > xOffset - 3 && this.clickedXDown < xOffset + 21 - 3 && this.clickedYDown > yOffset - 3 && this.clickedYDown < yOffset + 21 - 3) {
            outlineColor = -12277180;
        }
        guiGraphics.renderOutline(xOffset - 2, yOffset - 2, 20, 20, outlineColor);
        switch (fp.rarity()) {
            case COMMON: {
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UNCOMMON: {
                guiGraphics.setColor(0.7f, 1.0f, 0.7f, 1.0f);
                break;
            }
            case RARE: {
                guiGraphics.setColor(0.2f, 0.4f, 0.7f, 0.7f);
                break;
            }
            case EPIC: {
                guiGraphics.setColor(1.0f, 0.0f, 1.0f, 0.5f);
                break;
            }
            case LEGENDARY: {
                Color color = Color.getHSBColor(Tooltips.hue * 2.0f, 1.0f, 1.0f);
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                guiGraphics.setColor(r, g, b, 0.7f);
            }
        }
        RenderSystem.enableBlend();
        guiGraphics.blit(GLOW, xOffset - 1, yOffset - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.disableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (caught != 0) {
            this.renderItem(is, xOffset, yOffset, 1);
        } else {
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), xOffset, yOffset, 1);
        }
        for (FishProperties fpNotif : (List)this.player.getData(ModDataAttachments.FISHES_NOTIFICATION)) {
            if (!fp.equals(fpNotif)) continue;
            guiGraphics.blit(STAR, xOffset + 10, yOffset + 7, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        if (mouseX > xOffset - 3 && mouseX < xOffset + 21 - 3 && mouseY > yOffset - 3 && mouseY < yOffset + 21 - 3) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            if (caught == 0) {
                components.add(Component.translatable((String)"gui.guide.not_caught_fish_name"));
                components.add(Component.translatable((String)"gui.guide.not_caught").withColor(0xAA0000));
            } else {
                if (fp.customName().isEmpty()) {
                    components.add(Component.translatable((String)("item." + fp.fish().getRegisteredName().replace(":", "."))));
                } else {
                    components.add(Component.translatable((String)("item.starcatcher." + fp.customName())));
                }
                components.add(Component.translatable((String)"gui.guide.caught").append((Component)Component.literal((String)("[" + caught + "]"))).withColor(43520));
            }
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics guiGraphics, int mouseX, int mouseY, int xOffset, int entry) {
        List<ResourceLocation> fluids;
        ResourceLocation rl;
        MutableComponent comp;
        MutableComponent comp2;
        Object c;
        if (this.level == null) {
            this.level = this.getMinecraft().level;
        }
        double x = mouseX - this.uiX;
        double y = mouseY - this.uiY;
        if (this.entries.size() <= entry) {
            return;
        }
        ItemStack is = new ItemStack(this.entries.get(entry).fish());
        FishProperties fp = this.entries.get(entry);
        if (!this.fpsSeen.contains(fp)) {
            this.fpsSeen.add(fp);
        }
        FishCaughtCounter fcc = null;
        for (FishCaughtCounter fccAll : this.fishCaughtCounterList) {
            if (!fp.equals(fccAll.fp())) continue;
            fcc = fccAll;
            break;
        }
        if (fcc == null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught_fish_name"), this.uiX + xOffset + 46, this.uiY + 60, 0, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.not_caught").withColor(0xAA0000), this.uiX + xOffset + 46, this.uiY + 70, 0, false);
            this.renderItem(new ItemStack((ItemLike)ModItems.MISSINGNO.get()), this.uiX + xOffset + 10, this.uiY + 60);
        } else {
            MutableComponent compName = fp.customName().isEmpty() ? Component.translatable((String)((Item)fp.fish().value()).getDescriptionId()) : Component.translatable((String)("item.starcatcher." + fp.customName()));
            guiGraphics.drawString(this.font, (Component)compName, this.uiX + xOffset + 46, this.uiY + 55, 0, false);
            c = Component.literal((String)("[" + fcc.count() + "]")).withColor(43520);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.caught").append((Component)c).withColor(43520), this.uiX + xOffset + 46, this.uiY + 65, 0, false);
            Component rarity = Tooltips.decodeTranslationKey((String)("gui.guide.rarity." + fp.rarity().getSerializedName()));
            guiGraphics.drawString(this.font, rarity, this.uiX + xOffset + 46, this.uiY + 75, 0, false);
            this.renderItem(is, this.uiX + xOffset + 10, this.uiY + 60);
            switch (fp.rarity()) {
                case COMMON: {
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case UNCOMMON: {
                    guiGraphics.setColor(0.7f, 1.0f, 0.7f, 1.0f);
                    break;
                }
                case RARE: {
                    guiGraphics.setColor(0.2f, 0.4f, 0.7f, 0.7f);
                    break;
                }
                case EPIC: {
                    guiGraphics.setColor(1.0f, 0.0f, 1.0f, 0.5f);
                    break;
                }
                case LEGENDARY: {
                    Color color = Color.getHSBColor(Tooltips.hue, 1.0f, 1.0f);
                    float r = (float)color.getRed() / 255.0f;
                    float g = (float)color.getGreen() / 255.0f;
                    float b = (float)color.getBlue() / 255.0f;
                    guiGraphics.setColor(r, g, b, 0.7f);
                }
            }
            RenderSystem.enableBlend();
            guiGraphics.blit(GLOW, this.uiX + xOffset - 6, this.uiY + 40, 0.0f, 0.0f, 48, 48, 48, 48);
            RenderSystem.disableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (mouseX > this.uiX + xOffset + 46 && mouseX < this.uiX + xOffset + 150 && mouseY > this.uiY + 57 && mouseY < this.uiY + 80) {
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                components.add(Component.literal((String)("Fastest Catch: " + (float)(fcc.fastestTicks() / 20) + "s")));
                components.add(Component.literal((String)("Average: " + fcc.averageTicks() / 20.0f + "s")));
                guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
            }
        }
        int yOffset = 110;
        if (fp.wr().dims().isEmpty()) {
            comp2 = Component.translatable((String)"gui.guide.no_restriction");
        } else if (fp.wr().dims().size() == 1) {
            comp2 = Component.translatable((String)("dimension." + fp.wr().dims().getFirst().toLanguageKey()));
        } else {
            comp2 = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c2 = new ArrayList<MutableComponent>();
                c2.add(Component.translatable((String)"gui.guide.dimensions"));
                for (int i = 0; i < fp.wr().dims().size(); ++i) {
                    c2.add(Component.translatable((String)("dimension." + fp.wr().dims().get(i).toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c2, Optional.empty(), mouseX, mouseY);
            }
        }
        comp2 = fp.wr().dims().isEmpty() ? comp2.copy().withColor(43520) : (fp.wr().dims().contains(this.level.dimension().location()) ? comp2.copy().withColor(43520) : comp2.copy().withColor(0xAA0000));
        MutableComponent start = Component.translatable((String)"gui.guide.dimension");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp2), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        if (!fp.wr().dimsBlacklist().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(0xAA0000), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                c = new ArrayList();
                c.add(Component.translatable((String)"gui.guide.blacklisted_dimensions"));
                for (int i = 0; i < fp.wr().dimsBlacklist().size(); ++i) {
                    c.add(Component.literal((String)fp.wr().dimsBlacklist().get(i).toString()));
                }
                guiGraphics.renderTooltip(this.font, (List)c, Optional.empty(), mouseX, mouseY);
            }
        }
        yOffset += 15;
        List<ResourceLocation> biomesBL = FishProperties.getBiomesBlacklistAsList(fp, (Level)this.level);
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, (Level)this.level);
        if (biomes.isEmpty()) {
            comp = Component.translatable((String)"gui.guide.no_restriction");
            if (!biomesBL.isEmpty()) {
                comp.append("*");
            }
        } else if (biomes.size() == 1) {
            comp = Component.translatable((String)("biome." + biomes.getFirst().toLanguageKey()));
        } else if (fp.wr().biomesTags().size() == 1) {
            comp = Component.translatable((String)("tag." + fp.wr().biomesTags().getFirst().toLanguageKey()));
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c3 = new ArrayList<MutableComponent>();
                c3.add(Component.translatable((String)"gui.guide.biomes"));
                for (ResourceLocation rl2 : biomes) {
                    c3.add(Component.translatable((String)("biome." + rl2.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c3, Optional.empty(), mouseX, mouseY);
            }
        } else {
            comp = Component.translatable((String)"gui.guide.hover");
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                ArrayList<MutableComponent> c4 = new ArrayList<MutableComponent>();
                c4.add(Component.translatable((String)"gui.guide.biome"));
                for (ResourceLocation rl3 : biomes) {
                    c4.add(Component.translatable((String)("biome." + rl3.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c4, Optional.empty(), mouseX, mouseY);
            }
        }
        comp = biomes.isEmpty() ? comp.copy().withColor(43520) : (biomes.contains(rl = ResourceLocation.parse((String)this.level.getBiome(Minecraft.getInstance().player.blockPosition()).getRegisteredName())) ? comp.copy().withColor(43520) : comp.copy().withColor(0xAA0000));
        MutableComponent start2 = Component.translatable((String)"gui.guide.biome");
        guiGraphics.drawString(this.font, (Component)start2.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        if (!biomesBL.isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"[!]").withColor(0xAA0000), this.uiX + xOffset + 160, this.uiY + yOffset, 0, false);
            if (x > (double)(xOffset + 155) && x < (double)(xOffset + 175) && y > (double)(yOffset - 4) && y < (double)(yOffset + 12)) {
                ArrayList<MutableComponent> c5 = new ArrayList<MutableComponent>();
                c5.add(Component.translatable((String)"gui.guide.blacklisted_biomes"));
                for (ResourceLocation rl4 : biomesBL) {
                    c5.add(Component.translatable((String)("biome." + rl4.toLanguageKey())));
                }
                guiGraphics.renderTooltip(this.font, c5, Optional.empty(), mouseX, mouseY);
            }
        }
        if (!fp.br().correctBait().isEmpty()) {
            yOffset += 15;
            ItemStack bait = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(fp.br().correctBait().getFirst()));
            int bonus = fp.br().correctBaitChanceAdded() / fp.baseChance() * 100;
            MutableComponent extra = Component.literal((String)(" (+" + bonus + "%)"));
            if (bait.is((Item)ModItems.LEGENDARY_BAIT.get())) {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bait").append(Tooltips.RGBEachLetter((String)I18n.get((String)bait.getDescriptionId(), (Object[])new Object[0]))).append((Component)extra), this.uiX + xOffset, this.uiY + yOffset, 0, false);
            } else {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.bait").append((Component)Component.translatable((String)bait.getDescriptionId())).append((Component)extra), this.uiX + xOffset, this.uiY + yOffset, 0, false);
            }
            if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                guiGraphics.renderTooltip(this.font, bait, mouseX, mouseY);
            }
        }
        yOffset += 15;
        if (fp.weather() == FishProperties.Weather.ALL) {
            comp = Component.translatable((String)"gui.guide.no_restriction").withColor(43520);
        } else {
            comp = Component.translatable((String)"gui.guide.no_restriction");
            if (fp.weather() == FishProperties.Weather.RAIN) {
                comp = (double)this.level.getRainLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.raining").withColor(43520) : Component.translatable((String)"gui.guide.raining").withColor(0xAA0000);
            }
            if (fp.weather() == FishProperties.Weather.THUNDER) {
                comp = (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.thundering").withColor(43520) : Component.translatable((String)"gui.guide.thundering").withColor(0xAA0000);
            }
            if (fp.weather() == FishProperties.Weather.CLEAR) {
                comp = (double)this.level.getRainLevel(0.0f) > 0.5 || (double)this.level.getThunderLevel(0.0f) > 0.5 ? Component.translatable((String)"gui.guide.clear").withColor(0xAA0000) : Component.translatable((String)"gui.guide.clear").withColor(43520);
            }
        }
        start = Component.translatable((String)"gui.guide.weather");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        yOffset += 15;
        if (fp.daytime() == FishProperties.Daytime.ALL) {
            comp = Component.translatable((String)"gui.guide.no_restriction").withColor(43520);
        } else {
            long time = this.level.getDayTime() % 24000L;
            comp = switch (fp.daytime()) {
                case FishProperties.Daytime.DAY -> {
                    if (time <= 23000L && time >= 12700L) {
                        yield Component.translatable((String)"gui.guide.day").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.day").withColor(43520);
                }
                case FishProperties.Daytime.NOON -> {
                    if (time <= 3500L || time >= 8500L) {
                        yield Component.translatable((String)"gui.guide.noon").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.noon").withColor(43520);
                }
                case FishProperties.Daytime.NIGHT -> {
                    if (time >= 23000L || time <= 12700L) {
                        yield Component.translatable((String)"gui.guide.night").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.night").withColor(43520);
                }
                case FishProperties.Daytime.MIDNIGHT -> {
                    if (time <= 16500L || time >= 19500L) {
                        yield Component.translatable((String)"gui.guide.midnight").withColor(0xAA0000);
                    }
                    yield Component.translatable((String)"gui.guide.midnight").withColor(43520);
                }
                default -> Component.empty();
            };
        }
        start = Component.translatable((String)"gui.guide.daytime");
        guiGraphics.drawString(this.font, (Component)start.copy().append((Component)comp), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        int above = fp.mustBeCaughtAboveY();
        int below = fp.mustBeCaughtBelowY();
        if (above != Integer.MIN_VALUE || below != Integer.MAX_VALUE) {
            yOffset += 15;
            MutableComponent belowAbove = Component.empty();
            if (above != Integer.MIN_VALUE) {
                belowAbove.append((Component)Component.translatable((String)"gui.guide.above")).append("" + above);
            }
            if (above != Integer.MIN_VALUE && below != Integer.MAX_VALUE) {
                belowAbove.append(", ");
            }
            if (below != Integer.MAX_VALUE) {
                belowAbove.append((Component)Component.translatable((String)"gui.guide.below")).append("" + below);
            }
            MutableComponent comp3 = belowAbove;
            if (above == 100 && below == Integer.MAX_VALUE) {
                comp3 = Component.translatable((String)"gui.guide.mountain");
            } else if (above == 50 && below == 100) {
                comp3 = Component.translatable((String)"gui.guide.surface");
            } else if (above == 0 && below == Integer.MAX_VALUE) {
                comp3 = Component.translatable((String)"gui.guide.surface");
            } else if (above == Integer.MIN_VALUE && below == 50) {
                comp3 = Component.translatable((String)"gui.guide.underground");
            } else if (above == 0 && below == 50) {
                comp3 = Component.translatable((String)"gui.guide.caves");
            } else if (above == Integer.MIN_VALUE && below == 0) {
                comp3 = Component.translatable((String)"gui.guide.deepslate");
            }
            if (this.player.getY() > (double)above && this.player.getY() < (double)below) {
                comp3.withColor(43520);
            } else {
                comp3.withColor(0xAA0000);
            }
            if (x > (double)xOffset && x < (double)(xOffset + 140) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10) && comp3 != belowAbove) {
                guiGraphics.renderTooltip(this.font, (Component)belowAbove, mouseX, mouseY);
            }
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.elevation").append((Component)comp3), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        }
        if (!(fluids = fp.wr().fluids()).equals(FishProperties.WorldRestrictions.DEFAULT.fluids())) {
            MutableComponent comp4;
            yOffset += 15;
            if (fluids.size() == 1) {
                comp4 = Component.translatable((String)("block." + fluids.getFirst().toLanguageKey()));
            } else {
                comp4 = Component.translatable((String)"gui.guide.hover");
                if (x > (double)xOffset && x < (double)(xOffset + 100) && y > (double)(yOffset - 2) && y < (double)(yOffset + 10)) {
                    ArrayList<MutableComponent> c6 = new ArrayList<MutableComponent>();
                    c6.add(Component.translatable((String)"gui.guide.fluids"));
                    for (ResourceLocation rl5 : fluids) {
                        c6.add(Component.translatable((String)("block." + rl5.toLanguageKey())));
                    }
                    guiGraphics.renderTooltip(this.font, c6, Optional.empty(), mouseX, mouseY);
                }
            }
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.guide.fluids").append((Component)comp4), this.uiX + xOffset, this.uiY + yOffset, 0, false);
        }
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, this.uiX, this.uiY, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl, int yOffset) {
        guiGraphics.blit(rl, this.uiX, this.uiY + yOffset, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        this.renderItem(stack, x, y, 3);
    }

    private void renderItem(ItemStack stack, int x, int y, int scale) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer entity = Minecraft.getInstance().player;
        if (!stack.isEmpty()) {
            boolean usesBlockLight;
            BakedModel bakedmodel = this.minecraft.getItemRenderer().getModel(stack, (Level)level, (LivingEntity)entity, 234234);
            PoseStack pose = new PoseStack();
            pose.pushPose();
            pose.translate((float)(x + 8), (float)(y + 8), 150.0f);
            pose.scale(16.0f * (float)scale, -16.0f * (float)scale, 16.0f * (float)scale);
            boolean bl = usesBlockLight = !bakedmodel.usesBlockLight();
            if (usesBlockLight) {
                Lighting.setupForFlatItems();
            }
            this.minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
            RenderSystem.disableDepthTest();
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
            RenderSystem.enableDepthTest();
            if (usesBlockLight) {
                Lighting.setupFor3DItems();
            }
            pose.popPose();
        }
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new Payloads.FPsSeen(this.fpsSeen), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected boolean shouldNarrateNavigation() {
        return false;
    }

    public FishingGuideScreen() {
        super((Component)Component.empty());
        this.basics = new ItemStack((ItemLike)ModItems.ROD.get());
        this.treasures = new ItemStack((ItemLike)ModItems.WATERLOGGED_SATCHEL.get());
        this.ironHook = new ItemStack((ItemLike)ModItems.HOOK.get());
        this.shinyHook = new ItemStack((ItemLike)ModItems.SHINY_HOOK.get());
        this.goldHook = new ItemStack((ItemLike)ModItems.GOLD_HOOK.get());
        this.mossyHook = new ItemStack((ItemLike)ModItems.MOSSY_HOOK.get());
        this.crystalHook = new ItemStack((ItemLike)ModItems.CRYSTAL_HOOK.get());
        this.stoneHook = new ItemStack((ItemLike)ModItems.STONE_HOOK.get());
        this.splitHook = new ItemStack((ItemLike)ModItems.SPLIT_HOOK.get());
        this.frugalBobber = new ItemStack((ItemLike)ModItems.FRUGAL_BOBBER.get());
        this.creeperBobber = new ItemStack((ItemLike)ModItems.CREEPER_BOBBER.get());
        this.glitterBobber = new ItemStack((ItemLike)ModItems.GLITTER_BOBBER.get());
        this.colorfulBobber = new ItemStack((ItemLike)ModItems.COLORFUL_BOBBER.get());
        this.steadyBobber = new ItemStack((ItemLike)ModItems.STEADY_BOBBER.get());
        this.impatientBobber = new ItemStack((ItemLike)ModItems.IMPATIENT_BOBBER.get());
        this.frogBobber = new ItemStack((ItemLike)ModItems.FROG_BOBBER.get());
        this.fishSpotter = new ItemStack((ItemLike)ModItems.FISH_SPOTTER.get());
        this.trophies = new ItemStack((ItemLike)ModItems.TROPHY_GOLD.get());
        this.secrets = new ItemStack((ItemLike)ModItems.WATERLOGGED_BOTTLE.get());
    }
}

