/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.items;

import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class FishingTreasure
extends Item {
    private final ResourceLocation lootTable;

    public FishingTreasure(ResourceLocation rl) {
        super(new Item.Properties().stacksTo(1));
        this.lootTable = rl;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        List curatedTreasureInTag = BuiltInRegistries.ITEM.getTag(StarcatcherTags.CURATED_TREASURE).map(holders -> holders.stream().toList()).orElse(List.of());
        if (!curatedTreasureInTag.isEmpty()) {
            ArrayList<Item> curatedTreasureNotAlreadyCaught = new ArrayList<Item>();
            ArrayList<ResourceLocation> treasuresCaught = new ArrayList<ResourceLocation>((Collection)player.getData(ModDataAttachments.TREASURES_CAUGHT));
            for (Holder holder : curatedTreasureInTag) {
                if (treasuresCaught.contains(holder.getKey().location())) continue;
                curatedTreasureNotAlreadyCaught.add((Item)holder.value());
            }
            if (!curatedTreasureNotAlreadyCaught.isEmpty()) {
                Item item = (Item)curatedTreasureNotAlreadyCaught.get(level.random.nextIntBetweenInclusive(0, curatedTreasureNotAlreadyCaught.size() - 1));
                treasuresCaught.add(BuiltInRegistries.ITEM.getKey((Object)item));
                player.setData(ModDataAttachments.TREASURES_CAUGHT, treasuresCaught);
                player.setItemInHand(usedHand, new ItemStack((ItemLike)item));
                return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
            }
        }
        ResourceKey lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable);
        LootParams params = new LootParams.Builder((ServerLevel)level).create(LootContextParamSets.EMPTY);
        ObjectArrayList arrayOfItemStacks = level.getServer().reloadableRegistries().getLootTable(lootTable).getRandomItems(params);
        player.setItemInHand(usedHand, (ItemStack)arrayOfItemStacks.get(level.random.nextIntBetweenInclusive(0, arrayOfItemStacks.size() - 1)));
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }
}

