/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public record FishCaughtCounter(FishProperties fp, int count, int fastestTicks, float averageTicks) {
    public static final Codec<FishCaughtCounter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FishProperties.CODEC.fieldOf("fps").forGetter(FishCaughtCounter::fp), (App)Codec.INT.optionalFieldOf("count", (Object)0).forGetter(FishCaughtCounter::count), (App)Codec.INT.optionalFieldOf("fastest_ticks", (Object)0).forGetter(FishCaughtCounter::fastestTicks), (App)Codec.FLOAT.optionalFieldOf("average_ticks", (Object)Float.valueOf(0.0f)).forGetter(FishCaughtCounter::averageTicks)).apply((Applicative)instance, FishCaughtCounter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FishCaughtCounter> STREAM_CODEC = StreamCodec.composite(FishProperties.STREAM_CODEC, FishCaughtCounter::fp, (StreamCodec)ByteBufCodecs.VAR_INT, FishCaughtCounter::count, (StreamCodec)ByteBufCodecs.VAR_INT, FishCaughtCounter::fastestTicks, (StreamCodec)ByteBufCodecs.FLOAT, FishCaughtCounter::averageTicks, FishCaughtCounter::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<FishCaughtCounter>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
    public static final Codec<List<FishCaughtCounter>> LIST_CODEC = CODEC.listOf();

    public static boolean AwardFishCaughtCounter(FishProperties fpCaught, Player player, int ticks) {
        List listFishCaughtCounter = (List)player.getData(ModDataAttachments.FISHES_CAUGHT);
        ArrayList<FishCaughtCounter> newlist = new ArrayList<FishCaughtCounter>();
        boolean newFish = true;
        for (FishCaughtCounter fcc : listFishCaughtCounter) {
            if (fpCaught.equals(fcc.fp)) {
                int newFastestTicks = Math.min(fcc.fastestTicks, ticks);
                float newAverageTicks = (fcc.averageTicks * (float)fcc.count + (float)ticks) / (float)(fcc.count + 1);
                newlist.add(new FishCaughtCounter(fpCaught, fcc.count + 1, newFastestTicks, newAverageTicks));
                newFish = false;
                continue;
            }
            newlist.add(fcc);
        }
        if (newFish) {
            newlist.add(new FishCaughtCounter(fpCaught, 1, ticks, ticks));
        }
        player.setData(ModDataAttachments.FISHES_CAUGHT, newlist);
        return newFish;
    }
}

