/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.ModItems;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public record TrophyProperties(TrophyType type, Holder<Item> baseItem, String customName, int uniqueFishCount, int totalCaughtCount, int chanceToCatch) {
    public static final TrophyProperties DEFAULT = new TrophyProperties(TrophyType.TROPHY, (Holder<Item>)ModItems.TROPHY_GOLD, "Missingno Trophy", Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final Codec<TrophyProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TrophyType.CODEC.fieldOf("trophy_type").forGetter(TrophyProperties::type), (App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("base_item").forGetter(TrophyProperties::baseItem), (App)Codec.STRING.optionalFieldOf("custom_name", (Object)TrophyProperties.DEFAULT.customName).forGetter(TrophyProperties::customName), (App)Codec.INT.optionalFieldOf("unique_fishes", (Object)TrophyProperties.DEFAULT.uniqueFishCount).forGetter(TrophyProperties::uniqueFishCount), (App)Codec.INT.optionalFieldOf("total_fishes", (Object)TrophyProperties.DEFAULT.totalCaughtCount).forGetter(TrophyProperties::totalCaughtCount), (App)Codec.INT.optionalFieldOf("chance_to_catch", (Object)TrophyProperties.DEFAULT.chanceToCatch).forGetter(TrophyProperties::chanceToCatch)).apply((Applicative)instance, TrophyProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrophyProperties> STREAM_CODEC = StreamCodec.composite(TrophyType.STREAM_CODEC, TrophyProperties::type, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), TrophyProperties::baseItem, (StreamCodec)ByteBufCodecs.STRING_UTF8, TrophyProperties::customName, (StreamCodec)ByteBufCodecs.VAR_INT, TrophyProperties::uniqueFishCount, (StreamCodec)ByteBufCodecs.VAR_INT, TrophyProperties::totalCaughtCount, (StreamCodec)ByteBufCodecs.VAR_INT, TrophyProperties::chanceToCatch, TrophyProperties::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<TrophyProperties>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
    public static final Codec<List<TrophyProperties>> LIST_CODEC = CODEC.listOf();

    public static enum TrophyType implements StringRepresentable
    {
        TROPHY("trophy"),
        SECRET("secret"),
        TRASH("trash");

        public static final Codec<TrophyType> CODEC;
        public static final StreamCodec<FriendlyByteBuf, TrophyType> STREAM_CODEC;
        private final String key;

        private TrophyType(String key) {
            this.key = key;
        }

        @NotNull
        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TrophyType::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(TrophyType.class);
        }
    }
}

