/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.emi;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.emi.StarcatcherEmiRecipe;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

@EmiEntrypoint
public class StarcatcherEmiPlugin
implements EmiPlugin {
    public static final ResourceLocation MY_SPRITE_SHEET = Starcatcher.rl("textures/gui/emi_simplified_textures.png");
    public static final EmiStack MY_WORKSTATION = EmiStack.of(ModItems.ROD);
    public static final EmiRecipeCategory STARCATCHER_CATEGORY = new EmiRecipeCategory(Starcatcher.rl("fishing"), (EmiRenderable)MY_WORKSTATION);

    public void register(EmiRegistry registry) {
        registry.addCategory(STARCATCHER_CATEGORY);
        registry.addWorkstation(STARCATCHER_CATEGORY, (EmiIngredient)MY_WORKSTATION);
        Registry fps = Minecraft.getInstance().level.registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY);
        for (FishProperties fp : fps) {
            registry.addRecipe((EmiRecipe)new StarcatcherEmiRecipe(fps.getKey((Object)fp), fp));
        }
        Registry trophies = Minecraft.getInstance().level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY);
        for (TrophyProperties fp : trophies) {
            if (!fp.trophyType().equals((Object)TrophyProperties.TrophyType.TROPHY) && !fp.trophyType().equals((Object)TrophyProperties.TrophyType.SECRET)) continue;
            registry.addRecipe((EmiRecipe)new StarcatcherEmiRecipe(trophies.getKey((Object)fp), fp));
        }
    }
}

