/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.emi;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.emi.StarcatcherEmiPlugin;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class StarcatcherEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiStack> output;
    private final FishProperties fp;
    private final TrophyProperties tp;
    private static final List<EmiIngredient> INPUT = List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.GUIDE})), EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.ROD})));

    public StarcatcherEmiRecipe(ResourceLocation id, FishProperties fp) {
        this.output = List.of(EmiStack.of((ItemLike)((ItemLike)fp.fish().value())));
        this.id = id;
        this.fp = fp;
        this.tp = null;
    }

    public StarcatcherEmiRecipe(ResourceLocation id, TrophyProperties tp) {
        this.output = List.of(EmiStack.of((ItemLike)((ItemLike)tp.fp().fish().value())));
        this.id = id;
        this.fp = tp.fp();
        this.tp = tp;
    }

    public EmiRecipeCategory getCategory() {
        return StarcatcherEmiPlugin.STARCATCHER_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return Starcatcher.rl("/" + this.id.getPath());
    }

    public List<EmiIngredient> getInputs() {
        return List.of();
    }

    public List<EmiIngredient> getCatalysts() {
        return INPUT;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 100;
    }

    public int getDisplayHeight() {
        return 22;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(INPUT.get(0), 5, 2);
        widgets.addSlot(INPUT.get(1), 23, 2);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 45, 2);
        ItemStack is = new ItemStack(this.fp.fish());
        if (!this.fp.customName().equals(FishProperties.DEFAULT.customName())) {
            is.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.fp.customName()));
        }
        if (this.tp != null) {
            if (!this.tp.customName().equals(TrophyProperties.DEFAULT.customName()) && this.tp.trophyType().equals((Object)TrophyProperties.TrophyType.TROPHY)) {
                is.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.tp.customName()));
            }
            is.set(ModDataComponents.TROPHY, (Object)this.tp);
        }
        widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{is})), 73, 2).recipeContext((EmiRecipe)this);
    }
}

