/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.compat;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.compat.StarcatcherEmiPlugin;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class StarcatcherEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiStack> output;
    private final FishProperties fp;
    private final TrophyProperties tp;
    private static final List<EmiIngredient> input = List.of(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.GUIDE.get()})), EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ROD.get()})));
    private final ItemStack is;

    public StarcatcherEmiRecipe(ResourceLocation id, FishProperties fp) {
        this.output = List.of(EmiStack.of((ItemLike)((ItemLike)fp.fish().m_203334_())));
        this.id = id;
        this.fp = fp;
        this.tp = null;
        this.is = new ItemStack(fp.fish());
        if (!this.fp.customName().equals(FishProperties.DEFAULT.customName())) {
            this.is.m_41714_((Component)Component.m_237115_((String)fp.customName()));
        }
    }

    public StarcatcherEmiRecipe(ResourceLocation id, TrophyProperties tp) {
        this.output = List.of(EmiStack.of((ItemLike)((ItemLike)tp.fp().fish().m_203334_())));
        this.id = id;
        this.fp = tp.fp();
        this.tp = tp;
        this.is = new ItemStack(this.fp.fish());
        if (!this.tp.customName().equals(TrophyProperties.DEFAULT.customName()) && tp.trophyType().equals((Object)TrophyProperties.TrophyType.TROPHY)) {
            this.is.m_41714_((Component)Component.m_237115_((String)tp.customName()));
        }
        DataComponents.setTrophyProperties(this.is, this.tp);
    }

    public EmiRecipeCategory getCategory() {
        return StarcatcherEmiPlugin.STARCATCHER_CATEGORY;
    }

    public ResourceLocation getId() {
        return Starcatcher.rl("/" + this.id.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        return List.of();
    }

    public List<EmiIngredient> getCatalysts() {
        return input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 100;
    }

    public int getDisplayHeight() {
        return 22;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(input.get(0), 5, 2);
        widgets.addSlot(input.get(1), 23, 2);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 45, 2);
        widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.is})), 73, 2).recipeContext((EmiRecipe)this);
    }
}

