/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.bob.FishingBobEntity;
import com.wdiscute.starcatcher.compat.EclipticSeasonsCompat;
import com.wdiscute.starcatcher.compat.SereneSeasonsCompat;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.ModList;

public record FishProperties(Holder<Item> fish, int baseChance, String customName, SizeAndWeight sw, Rarity rarity, WorldRestrictions wr, BaitRestrictions br, Difficulty dif, Daytime daytime, Weather weather, boolean skipMinigame, boolean hasGuideEntry) {
    public static final Codec<FishProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_206110_().fieldOf("fish").forGetter(FishProperties::fish), (App)Codec.INT.optionalFieldOf("base_chance", (Object)5).forGetter(FishProperties::baseChance), (App)Codec.STRING.optionalFieldOf("custom_name", (Object)"").forGetter(FishProperties::customName), (App)SizeAndWeight.CODEC.optionalFieldOf("size_and_weight", (Object)SizeAndWeight.DEFAULT).forGetter(FishProperties::sw), (App)Rarity.CODEC.optionalFieldOf("rarity", (Object)Rarity.COMMON).forGetter(FishProperties::rarity), (App)WorldRestrictions.CODEC.optionalFieldOf("world_restrictions", (Object)WorldRestrictions.DEFAULT).forGetter(FishProperties::wr), (App)BaitRestrictions.CODEC.optionalFieldOf("bait_restrictions", (Object)BaitRestrictions.DEFAULT).forGetter(FishProperties::br), (App)Difficulty.CODEC.optionalFieldOf("difficulty", (Object)Difficulty.DEFAULT).forGetter(FishProperties::dif), (App)Daytime.CODEC.optionalFieldOf("daytime", (Object)Daytime.ALL).forGetter(FishProperties::daytime), (App)Weather.CODEC.optionalFieldOf("weather", (Object)Weather.ALL).forGetter(FishProperties::weather), (App)Codec.BOOL.optionalFieldOf("skips_minigame", (Object)false).forGetter(FishProperties::skipMinigame), (App)Codec.BOOL.optionalFieldOf("has_guide_entry", (Object)true).forGetter(FishProperties::hasGuideEntry)).apply((Applicative)instance, FishProperties::new));
    public static final Codec<List<FishProperties>> LIST_CODEC = CODEC.listOf();
    public static final FishProperties DEFAULT = new FishProperties((Holder<Item>)((Holder)ModItems.MISSINGNO.getHolder().orElse(Items.f_41852_.m_204114_())), 5, "", SizeAndWeight.DEFAULT, Rarity.COMMON, WorldRestrictions.DEFAULT, BaitRestrictions.DEFAULT, Difficulty.DEFAULT, Daytime.ALL, Weather.ALL, false, true);

    public static FishProperties getByRL(ResourceLocation resourceLocation, Level level) {
        return (FishProperties)level.m_9598_().m_175515_(Starcatcher.FISH_REGISTRY).m_7745_(resourceLocation);
    }

    public FishProperties withFish(Holder<Item> fish) {
        return new FishProperties(fish, this.baseChance, this.customName, this.sw, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withBaseChance(int baseChance) {
        return new FishProperties(this.fish, baseChance, this.customName, this.sw, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withCustomName(String customName) {
        return new FishProperties(this.fish, this.baseChance, customName, this.sw, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withSizeAndWeight(SizeAndWeight sizeAndWeight) {
        return new FishProperties(this.fish, this.baseChance, this.customName, sizeAndWeight, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withRarity(Rarity rarity) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withWorldRestrictions(WorldRestrictions wr) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, this.rarity, wr, this.br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withBaitRestrictions(BaitRestrictions br) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, this.rarity, this.wr, br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withDifficulty(Difficulty dif) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, this.rarity, this.wr, this.br, dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withDaytime(Daytime daytime) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, this.rarity, this.wr, this.br, this.dif, daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withWeather(Weather weather) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, this.rarity, this.wr, this.br, this.dif, this.daytime, weather, this.skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withSkipMinigame(boolean skipMinigame) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, skipMinigame, this.hasGuideEntry);
    }

    public FishProperties withHasGuideEntry(boolean hasGuideEntry) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, this.rarity, this.wr, this.br, this.dif, this.daytime, this.weather, this.skipMinigame, hasGuideEntry);
    }

    public FishProperties withSeasons(WorldRestrictions.Seasons ... seasons) {
        return new FishProperties(this.fish, this.baseChance, this.customName, this.sw, this.rarity, this.wr.withSeasons(seasons), this.br, this.dif, this.daytime, this.weather, this.skipMinigame, this.hasGuideEntry);
    }

    public static List<ResourceLocation> getBiomesAsList(FishProperties fp, Level level) {
        level.m_9598_().m_6632_(Registries.f_256952_);
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : fp.wr.biomesTags) {
            TagKey biomeBeingChecked = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl);
            Optional optional = level.m_9598_().m_255025_(Registries.f_256952_).m_254901_(biomeBeingChecked);
            if (!optional.isPresent()) continue;
            for (Holder biomeHolder : (HolderSet.Named)optional.get()) {
                String biomeString = ((ResourceKey)biomeHolder.m_203543_().get()).m_135782_().toString();
                rls.add(ResourceLocation.parse((String)biomeString));
            }
        }
        for (ResourceLocation rl : fp.wr.biomes) {
            Optional optional = level.m_9598_().m_255025_(Registries.f_256952_).m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl));
            if (!optional.isPresent() || rls.contains(rl)) continue;
            rls.add(rl);
        }
        return rls;
    }

    public static List<ResourceLocation> getBiomesBlacklistAsList(FishProperties fp, Level level) {
        level.m_9598_().m_6632_(Registries.f_256952_);
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : fp.wr.biomesBlacklistTags) {
            TagKey biomeBeingChecked = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl);
            Optional optional = level.m_9598_().m_255025_(Registries.f_256952_).m_254901_(biomeBeingChecked);
            if (!optional.isPresent()) continue;
            for (Holder biomeHolder : (HolderSet.Named)optional.get()) {
                String biomeString = ((ResourceKey)biomeHolder.m_203543_().get()).m_135782_().toString();
                rls.add(ResourceLocation.parse((String)biomeString));
            }
        }
        for (ResourceLocation rl : fp.wr.biomesBlacklist) {
            Optional optional = level.m_9598_().m_255025_(Registries.f_256952_).m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl));
            if (!optional.isPresent() || rls.contains(rl)) continue;
            rls.add(rl);
        }
        return rls;
    }

    public static List<FishProperties> getFPs(Level level) {
        return FishProperties.getFPs(level.m_9598_());
    }

    public static List<FishProperties> getFPs(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Starcatcher.FISH_REGISTRY).m_123024_().toList();
    }

    public static int getChance(FishProperties fp, Entity entity, ItemStack rod) {
        Level level = entity.m_9236_();
        int chance = fp.baseChance();
        ItemStack bobber = DataComponents.getItemInSlot(rod, DataComponents.Slots.BOBBER).m_41777_();
        ItemStack bait = DataComponents.getItemInSlot(rod, DataComponents.Slots.BAIT).m_41777_();
        if (ModList.get().isLoaded("sereneseasons") && !SereneSeasonsCompat.canCatch(fp, level)) {
            return 0;
        }
        if (ModList.get().isLoaded("eclipticseasons") && !EclipticSeasonsCompat.canCatch(fp, level)) {
            return 0;
        }
        if (!fp.wr.dims.isEmpty() && !fp.wr().dims().contains(level.m_46472_().m_135782_())) {
            return 0;
        }
        if (fp.wr.dimsBlacklist.contains(level.m_46472_().m_135782_())) {
            return 0;
        }
        List<ResourceLocation> biomes = FishProperties.getBiomesAsList(fp, level);
        List<ResourceLocation> blacklist = FishProperties.getBiomesBlacklistAsList(fp, level);
        ResourceLocation currentBiome = ((ResourceKey)level.m_204166_(entity.m_20183_()).m_203543_().get()).m_135782_();
        if (!biomes.isEmpty() && !biomes.contains(currentBiome)) {
            return 0;
        }
        if (!blacklist.isEmpty() && blacklist.contains(currentBiome)) {
            return 0;
        }
        boolean fluid = fp.wr.fluids.contains(BuiltInRegistries.f_257020_.m_7981_((Object)FishProperties.getSource(level.m_6425_(entity.m_20183_()).m_76152_())));
        boolean fluidAbove = fp.wr.fluids.contains(BuiltInRegistries.f_257020_.m_7981_((Object)FishProperties.getSource(level.m_6425_(entity.m_20183_().m_7494_()).m_76152_())));
        boolean fluidBelow = fp.wr.fluids.contains(BuiltInRegistries.f_257020_.m_7981_((Object)FishProperties.getSource(level.m_6425_(entity.m_20183_().m_7495_()).m_76152_())));
        if (!fluid && !fluidAbove && !fluidBelow && entity instanceof FishingBobEntity) {
            return 0;
        }
        if (fp.br().incorrectBaits().contains(BuiltInRegistries.f_257033_.m_7981_((Object)bait.m_41720_()))) {
            return 0;
        }
        if (entity.m_20182_().f_82480_ > (double)fp.wr.mustBeCaughtBelowY()) {
            return 0;
        }
        if (entity.m_20182_().f_82480_ < (double)fp.wr.mustBeCaughtAboveY()) {
            return 0;
        }
        if (fp.daytime() != Daytime.ALL) {
            long time = level.m_46468_() % 24000L;
            switch (fp.daytime()) {
                case DAY: {
                    if (time > 23000L || time < 12700L) break;
                    return 0;
                }
                case NOON: {
                    if (time > 3500L && time < 8500L) break;
                    return 0;
                }
                case NIGHT: {
                    if (time < 23000L && time > 12700L) break;
                    return 0;
                }
                case MIDNIGHT: {
                    if (time > 16500L && time < 19500L) break;
                    return 0;
                }
            }
        }
        if (!bait.m_150930_((Item)ModItems.METEOROLOGICAL_BAIT.get())) {
            if (fp.weather() == Weather.CLEAR && ((double)level.m_46722_(0.0f) > 0.5 || (double)level.m_46661_(0.0f) > 0.5)) {
                return 0;
            }
            if (fp.weather() == Weather.RAIN && (double)level.m_46722_(0.0f) < 0.5) {
                return 0;
            }
            if (fp.weather() == Weather.THUNDER && (double)level.m_46661_(0.0f) < 0.5) {
                return 0;
            }
        }
        if (fp.br().mustHaveCorrectBait() && !fp.br().correctBait().contains(BuiltInRegistries.f_257033_.m_7981_((Object)bait.m_41720_()))) {
            return 0;
        }
        if (fp.br().correctBait().contains(BuiltInRegistries.f_257033_.m_7981_((Object)bait.m_41720_()))) {
            chance += fp.br().correctBaitChanceAdded();
        }
        if (!fp.br().correctBobber().isEmpty() && !fp.br().correctBobber().contains(BuiltInRegistries.f_257033_.m_7981_((Object)bobber.m_41720_()))) {
            return 0;
        }
        return chance;
    }

    public static List<FishProperties> getFpsWithGuideEntryForArea(Entity entity) {
        ArrayList<FishProperties> list = new ArrayList<FishProperties>();
        for (FishProperties fp : entity.m_9236_().m_9598_().m_175515_(Starcatcher.FISH_REGISTRY)) {
            if (FishProperties.getChance(fp, entity, new ItemStack((ItemLike)ModItems.ROD.get())) <= 0 || !fp.hasGuideEntry) continue;
            list.add(fp);
        }
        return list;
    }

    public static Fluid getSource(Fluid fluid1) {
        if (fluid1 instanceof FlowingFluid) {
            FlowingFluid fluid = (FlowingFluid)fluid1;
            return fluid.m_5613_();
        }
        return fluid1;
    }

    public static SizeAndWeight sw(float s, float s1, float w, float w1, int g, int g1) {
        return new SizeAndWeight(s, s1, w, w1, g, g1);
    }

    public record SizeAndWeight(float sizeAverage, float sizeDeviation, float weightAverage, float weightDeviation, int goldenChance, int goldenIncrease) {
        public static final SizeAndWeight DEFAULT = new SizeAndWeight(41.0f, 21.0f, 2001.0f, 701.0f, 11, 21);
        public static final Codec<SizeAndWeight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("average_size_cm", (Object)Float.valueOf(SizeAndWeight.DEFAULT.sizeAverage)).forGetter(SizeAndWeight::sizeAverage), (App)Codec.FLOAT.optionalFieldOf("deviation_size_cm", (Object)Float.valueOf(SizeAndWeight.DEFAULT.sizeDeviation)).forGetter(SizeAndWeight::sizeDeviation), (App)Codec.FLOAT.optionalFieldOf("average_weight_grams", (Object)Float.valueOf(SizeAndWeight.DEFAULT.weightAverage)).forGetter(SizeAndWeight::weightAverage), (App)Codec.FLOAT.optionalFieldOf("deviation_weight_grams", (Object)Float.valueOf(SizeAndWeight.DEFAULT.weightDeviation)).forGetter(SizeAndWeight::weightDeviation), (App)Codec.INT.optionalFieldOf("golden_chance_percentage", (Object)SizeAndWeight.DEFAULT.goldenChance).forGetter(SizeAndWeight::goldenChance), (App)Codec.INT.optionalFieldOf("golden_state_increase", (Object)SizeAndWeight.DEFAULT.goldenIncrease).forGetter(SizeAndWeight::goldenIncrease)).apply((Applicative)instance, SizeAndWeight::new));
    }

    public static enum Rarity implements StringRepresentable
    {
        COMMON("common"),
        UNCOMMON("uncommon"),
        RARE("rare"),
        EPIC("epic"),
        LEGENDARY("legendary");

        public static final Codec<Rarity> CODEC;
        private final String key;

        private Rarity(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Rarity::values);
        }
    }

    public record WorldRestrictions(List<ResourceLocation> dims, List<ResourceLocation> dimsBlacklist, List<ResourceLocation> biomes, List<ResourceLocation> biomesTags, List<ResourceLocation> biomesBlacklist, List<ResourceLocation> biomesBlacklistTags, List<ResourceLocation> fluids, List<Seasons> seasons, int mustBeCaughtBelowY, int mustBeCaughtAboveY) {
        public static final WorldRestrictions DEFAULT = new WorldRestrictions(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(ResourceLocation.withDefaultNamespace((String)"water")), List.of(Seasons.ALL), Integer.MAX_VALUE, Integer.MIN_VALUE);
        public static final Codec<WorldRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("dimensions", WorldRestrictions.DEFAULT.dims).forGetter(WorldRestrictions::dims), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("dimensions_blacklist", WorldRestrictions.DEFAULT.dimsBlacklist).forGetter(WorldRestrictions::dimsBlacklist), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("biomes", WorldRestrictions.DEFAULT.biomes).forGetter(WorldRestrictions::biomes), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("biomes_tags", WorldRestrictions.DEFAULT.biomesTags).forGetter(WorldRestrictions::biomesTags), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("biomes_blacklist", WorldRestrictions.DEFAULT.biomesBlacklist).forGetter(WorldRestrictions::biomesBlacklist), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("biomes_blacklist_tags", WorldRestrictions.DEFAULT.biomesBlacklistTags).forGetter(WorldRestrictions::biomesBlacklistTags), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("fluids", WorldRestrictions.DEFAULT.fluids).forGetter(WorldRestrictions::fluids), (App)Seasons.LIST_CODEC.optionalFieldOf("seasons", WorldRestrictions.DEFAULT.seasons).forGetter(WorldRestrictions::seasons), (App)Codec.INT.optionalFieldOf("below_y", (Object)WorldRestrictions.DEFAULT.mustBeCaughtBelowY).forGetter(WorldRestrictions::mustBeCaughtBelowY), (App)Codec.INT.optionalFieldOf("above_y", (Object)WorldRestrictions.DEFAULT.mustBeCaughtAboveY).forGetter(WorldRestrictions::mustBeCaughtAboveY)).apply((Applicative)instance, WorldRestrictions::new));
        public static final WorldRestrictions OVERWORLD = DEFAULT.withDims(Level.f_46428_.m_135782_());
        public static final WorldRestrictions OVERWORLD_LUSH_CAVES = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomes(Biomes.f_151785_.m_135782_()).withMustBeCaughtBelowY(50);
        public static final WorldRestrictions OVERWORLD_CAVES = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomes(Biomes.f_151785_.m_135782_()).withMustBeCaughtBelowY(50).withMustBeCaughtAboveY(0);
        public static final WorldRestrictions OVERWORLD_DEEPSLATE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withMustBeCaughtBelowY(0);
        public static final WorldRestrictions OVERWORLD_DRIPSTONE_CAVES = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomes(Biomes.f_151784_.m_135782_()).withMustBeCaughtBelowY(50).withMustBeCaughtAboveY(0);
        public static final WorldRestrictions OVERWORLD_DEEP_DARK = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomes(Biomes.f_220594_.m_135782_()).withMustBeCaughtBelowY(50);
        public static final WorldRestrictions OVERWORLD_RIVER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_OCEAN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_WARM_OCEAN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_WARM_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_DEEP_OCEAN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_DEEP_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_LAKE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesBlacklistTags(StarcatcherTags.IS_OCEAN, StarcatcherTags.IS_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_FRESHWATER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesBlacklistTags(StarcatcherTags.IS_OCEAN).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_COLD_FRESHWATER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_COLD_LAKE, StarcatcherTags.IS_COLD_RIVER).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_WARM_FRESHWATER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_WARM_LAKE, StarcatcherTags.IS_WARM_RIVER).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_WARM_LAKE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_WARM_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_COLD_RIVER = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_COLD_RIVER).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_COLD_OCEAN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_COLD_OCEAN).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_COLD_LAKE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_COLD_LAKE).withMustBeCaughtAboveY(50).withMustBeCaughtBelowY(100);
        public static final WorldRestrictions OVERWORLD_COLD_MOUNTAIN = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_COLD_LAKE).withMustBeCaughtAboveY(100);
        public static final WorldRestrictions OVERWORLD_BEACH = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_BEACH).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_MUSHROOM_FIELDS = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_MUSHROOM_FIELDS).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_JUNGLE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(BiomeTags.f_207610_.f_203868_()).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_TAIGA = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(BiomeTags.f_207609_.f_203868_()).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_CHERRY_GROVE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_CHERRY_GROVE).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_SWAMP = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_SWAMP).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_DARK_FOREST = DEFAULT.withDims(Level.f_46428_.m_135782_()).withBiomesTags(StarcatcherTags.IS_DARK_FOREST).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_LAVA_SURFACE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava")).withMustBeCaughtAboveY(50);
        public static final WorldRestrictions OVERWORLD_LAVA_UNDERGROUND = DEFAULT.withDims(Level.f_46428_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava")).withMustBeCaughtBelowY(50);
        public static final WorldRestrictions OVERWORLD_UNDERGROUND = DEFAULT.withDims(Level.f_46428_.m_135782_()).withMustBeCaughtBelowY(50);
        public static final WorldRestrictions OVERWORLD_LAVA_DEEPSLATE = DEFAULT.withDims(Level.f_46428_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava")).withMustBeCaughtBelowY(0);
        public static final WorldRestrictions NETHER_LAVA = DEFAULT.withDims(Level.f_46429_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA_CRIMSON_FOREST = DEFAULT.withDims(Level.f_46429_.m_135782_()).withBiomes(Biomes.f_48200_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA_WARPED_FOREST = DEFAULT.withDims(Level.f_46429_.m_135782_()).withBiomes(Biomes.f_48201_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA_SOUL_SAND_VALLEY = DEFAULT.withDims(Level.f_46429_.m_135782_()).withBiomes(Biomes.f_48199_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions NETHER_LAVA_BASALT_DELTAS = DEFAULT.withDims(Level.f_46429_.m_135782_()).withBiomes(Biomes.f_48175_.m_135782_()).withFluids(ResourceLocation.withDefaultNamespace((String)"lava"));
        public static final WorldRestrictions END = DEFAULT.withDims(Level.f_46430_.m_135782_());
        public static final WorldRestrictions END_OUTER_ISLANDS = DEFAULT.withDims(Level.f_46430_.m_135782_()).withBiomesTags(BiomeTags.f_215818_.f_203868_()).withBiomesBlacklist(Biomes.f_48210_.m_135782_());

        public WorldRestrictions withDims(ResourceLocation ... dims) {
            return new WorldRestrictions(List.of(dims), this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withDimsBlacklist(ResourceLocation ... dimsBlacklist) {
            return new WorldRestrictions(this.dims, List.of(dimsBlacklist), this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withBiomes(ResourceLocation ... biome) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, List.of(biome), this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withBiomesTags(ResourceLocation ... biomesTag) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, List.of(biomesTag), this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withBiomesBlacklist(ResourceLocation ... biomesBlacklist) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, List.of(biomesBlacklist), this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withBiomesBlacklistTags(ResourceLocation ... biomesBlacklistTags) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, List.of(biomesBlacklistTags), this.fluids, this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withFluids(ResourceLocation ... fluids) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, List.of(fluids), this.seasons, this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withSeasons(Seasons ... seasons) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, Arrays.stream(seasons).toList(), this.mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withMustBeCaughtBelowY(int mustBeCaughtBelowY) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, mustBeCaughtBelowY, this.mustBeCaughtAboveY);
        }

        public WorldRestrictions withMustBeCaughtAboveY(int mustBeCaughtAboveY) {
            return new WorldRestrictions(this.dims, this.dimsBlacklist, this.biomes, this.biomesTags, this.biomesBlacklist, this.biomesBlacklistTags, this.fluids, this.seasons, this.mustBeCaughtBelowY, mustBeCaughtAboveY);
        }

        public static enum Seasons implements StringRepresentable
        {
            ALL("all"),
            SPRING("spring"),
            EARLY_SPRING("early_spring"),
            MID_SPRING("mid_spring"),
            LATE_SPRING("late_spring"),
            SUMMER("summer"),
            EARLY_SUMMER("early_summer"),
            MID_SUMMER("mid_summer"),
            LATE_SUMMER("late_summer"),
            AUTUMN("autumn"),
            EARLY_AUTUMN("early_autumn"),
            MID_AUTUMN("mid_autumn"),
            LATE_AUTUMN("late_autumn"),
            WINTER("winter"),
            EARLY_WINTER("early_winter"),
            MID_WINTER("mid_winter"),
            LATE_WINTER("late_winter");

            public static final Codec<Seasons> CODEC;
            public static final Codec<List<Seasons>> LIST_CODEC;
            private final String key;

            private Seasons(String key) {
                this.key = key;
            }

            public String m_7912_() {
                return this.key;
            }

            static {
                CODEC = StringRepresentable.m_216439_(Seasons::values);
                LIST_CODEC = CODEC.listOf();
            }
        }
    }

    public record BaitRestrictions(List<ResourceLocation> correctBobber, List<ResourceLocation> correctBait, boolean consumesBait, int correctBaitChanceAdded, List<ResourceLocation> incorrectBaits, boolean mustHaveCorrectBait) {
        public static final Codec<BaitRestrictions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("correct_bobbers", List.of()).forGetter(BaitRestrictions::correctBobber), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("correct_baits", List.of()).forGetter(BaitRestrictions::correctBait), (App)Codec.BOOL.optionalFieldOf("consumes_bait", (Object)true).forGetter(BaitRestrictions::consumesBait), (App)Codec.INT.optionalFieldOf("correct_bait_chance_added", (Object)0).forGetter(BaitRestrictions::correctBaitChanceAdded), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("incorrect_baits", List.of()).forGetter(BaitRestrictions::incorrectBaits), (App)Codec.BOOL.optionalFieldOf("must_have_correct_bait", (Object)false).forGetter(BaitRestrictions::mustHaveCorrectBait)).apply((Applicative)instance, BaitRestrictions::new));
        public static final BaitRestrictions DEFAULT = new BaitRestrictions(List.of(), List.of(), true, 0, List.of(), false);
        public static final BaitRestrictions CHERRY_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.CHERRY_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions LUSH_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.LUSH_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions SCULK_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.SCULK_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions DRIPSTONE_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.DRIPSTONE_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions MURKWATER_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.MURKWATER_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions LEGENDARY_BAIT = new BaitRestrictions(List.of(), List.of(ModItems.LEGENDARY_BAIT.getId()), true, 15, List.of(), false);
        public static final BaitRestrictions LEGENDARY_BAIT_VOIDBITER = new BaitRestrictions(List.of(), List.of(ModItems.LEGENDARY_BAIT.getId()), true, 50, List.of(), false);

        public BaitRestrictions withCorrectBobber(ResourceLocation ... correctBobber) {
            return new BaitRestrictions(List.of(correctBobber), this.correctBait, this.consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withCorrectBait(ResourceLocation ... correctBait) {
            return new BaitRestrictions(this.correctBobber, List.of(correctBait), this.consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withConsumesBait(boolean consumesBait) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withCorrectBaitChanceAdded(int correctBaitChanceAdded) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, this.consumesBait, correctBaitChanceAdded, this.incorrectBaits, this.mustHaveCorrectBait);
        }

        public BaitRestrictions withIncorrectBaits(ResourceLocation ... incorrectBaits) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, this.consumesBait, this.correctBaitChanceAdded, List.of(incorrectBaits), this.mustHaveCorrectBait);
        }

        public BaitRestrictions withMustHaveCorrectBait(boolean mustHaveCorrectBait) {
            return new BaitRestrictions(this.correctBobber, this.correctBait, this.consumesBait, this.correctBaitChanceAdded, this.incorrectBaits, mustHaveCorrectBait);
        }
    }

    public record Difficulty(int speed, int reward, int rewardThin, int penalty, int decay, Markers markers, Treasure treasure, Extras extras) {
        public static final Difficulty DEFAULT = new Difficulty(9, 20, 0, 6, 1, Markers.DEFAULT, Treasure.DEFAULT, Extras.DEFAULT);
        public static final Difficulty EASY_VANISHING = new Difficulty(9, 20, 0, 6, 1, Markers.DEFAULT, Treasure.DEFAULT, Extras.TTF);
        public static final Difficulty EASY_MOVING = new Difficulty(9, 20, 0, 6, 1, Markers.DEFAULT, Treasure.DEFAULT, Extras.TTF);
        public static final Difficulty REALLY_HEAVY_FISH = new Difficulty(10, 1, 0, 6, 0, Markers.TTFF, Treasure.DEFAULT, Extras.FFF);
        public static final Difficulty EASY_NO_FLIP_VANISHING = new Difficulty(9, 20, 0, 6, 1, Markers.DEFAULT, Treasure.DEFAULT, Extras.FTF);
        public static final Difficulty EASY_FAST_FISH = new Difficulty(13, 15, 0, 6, 2, Markers.TTFF, Treasure.DEFAULT, Extras.FFF);
        public static final Difficulty MEDIUM_FAST_FISH_VANISHING = new Difficulty(13, 10, 0, 12, 2, Markers.TTFF, Treasure.DEFAULT, Extras.FTF);
        public static final Difficulty MEDIUM = new Difficulty(10, 15, 35, 15, 1, Markers.TFTF, Treasure.UNCOMMON, Extras.DEFAULT);
        public static final Difficulty MEDIUM_MOVING = new Difficulty(10, 15, 35, 15, 1, Markers.TFTF, Treasure.UNCOMMON, Extras.TFT);
        public static final Difficulty MEDIUM_MOVING_NO_FLIP = new Difficulty(10, 15, 35, 15, 1, Markers.TFTF, Treasure.UNCOMMON, Extras.FFT);
        public static final Difficulty MEDIUM_VANISHING = new Difficulty(10, 15, 35, 15, 1, Markers.TFTF, Treasure.UNCOMMON, Extras.TTF);
        public static final Difficulty MEDIUM_VANISHING_MOVING = new Difficulty(10, 15, 35, 15, 1, Markers.TTTF, Treasure.UNCOMMON, Extras.TTT);
        public static final Difficulty HARD = new Difficulty(12, 15, 35, 25, 2, Markers.TFTF, Treasure.HARD, Extras.TFF);
        public static final Difficulty HARD_VANISHING = new Difficulty(12, 15, 35, 25, 2, Markers.TFTF, Treasure.HARD, Extras.TTF);
        public static final Difficulty HARD_MOVING = new Difficulty(12, 15, 35, 25, 2, Markers.TFTF, Treasure.HARD, Extras.TFT);
        public static final Difficulty FAT_CATCH = new Difficulty(12, 1, 0, 5, 0, Markers.TTFF, Treasure.HARD, Extras.FFF);
        public static final Difficulty HARD_ONLY_THIN = new Difficulty(9, 15, 20, 25, 2, Markers.FFTT, Treasure.HARD, Extras.TFF);
        public static final Difficulty HARD_ONLY_THIN_MOVING = new Difficulty(9, 15, 20, 25, 2, Markers.FFTT, Treasure.HARD, Extras.TFT);
        public static final Difficulty THIN_NO_DECAY = new Difficulty(9, 0, 15, 30, 0, Markers.FFTT, Treasure.HARD, Extras.TFF);
        public static final Difficulty MOVING_THIN_NO_DECAY = new Difficulty(9, 0, 15, 30, 0, Markers.FFTT, Treasure.HARD, Extras.TFT);
        public static final Difficulty VOIDBITER = new Difficulty(12, 0, 10, 20, 2, Markers.FFTT, Treasure.HARD, Extras.TTT);
        public static final Difficulty THIN_NO_DECAY_NOT_FORGIVING = new Difficulty(9, 0, 15, 999, 0, Markers.FFTT, Treasure.HARD, Extras.TFF);
        public static final Difficulty THIN_NO_DECAY_NOT_FORGIVING_MOVING = new Difficulty(9, 0, 15, 999, 0, Markers.FFTT, Treasure.HARD, Extras.TFT);
        public static final Difficulty SINGLE_BIG_FAST_NO_DECAY = new Difficulty(15, 5, 0, 15, 0, Markers.TFFF, Treasure.HARD, Extras.FFF);
        public static final Difficulty SINGLE_BIG_FAST_NO_DECAY_VANISHING = new Difficulty(15, 5, 0, 15, 0, Markers.TFFF, Treasure.HARD, Extras.FTF);
        public static final Difficulty SINGLE_BIG_FAST = new Difficulty(15, 5, 0, 15, 2, Markers.TFFF, Treasure.HARD, Extras.FFF);
        public static final Difficulty SINGLE_BIG_FAST_MOVING = new Difficulty(15, 5, 0, 15, 2, Markers.TFFF, Treasure.HARD, Extras.FFT);
        public static final Difficulty EVERYTHING = new Difficulty(12, 15, 30, 15, 3, Markers.TTTT, Treasure.HARD, Extras.FFF);
        public static final Difficulty EVERYTHING_VANISHING = new Difficulty(12, 15, 30, 15, 3, Markers.TTTT, Treasure.HARD, Extras.FTF);
        public static final Difficulty EVERYTHING_FLIP = new Difficulty(12, 15, 30, 15, 3, Markers.TTTT, Treasure.HARD, Extras.TFF);
        public static final Difficulty EVERYTHING_FLIP_MOVING = new Difficulty(12, 15, 30, 15, 3, Markers.TTTT, Treasure.HARD, Extras.TFT);
        public static final Difficulty NON_STOP_ACTION = new Difficulty(15, 18, 30, 0, 10, Markers.TTFF, Treasure.HARD, Extras.FFF);
        public static final Difficulty NON_STOP_ACTION_VANISHING = new Difficulty(15, 18, 30, 0, 10, Markers.TTFF, Treasure.HARD, Extras.FTF);
        public static final Difficulty NON_STOP_ACTION_VANISHING_MOVING = new Difficulty(15, 18, 30, 0, 10, Markers.TTFF, Treasure.HARD, Extras.FTF);
        public static final Codec<Difficulty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("speed", (Object)Difficulty.DEFAULT.speed).forGetter(Difficulty::speed), (App)Codec.INT.optionalFieldOf("reward", (Object)Difficulty.DEFAULT.reward).forGetter(Difficulty::reward), (App)Codec.INT.optionalFieldOf("reward_thin", (Object)Difficulty.DEFAULT.rewardThin).forGetter(Difficulty::rewardThin), (App)Codec.INT.optionalFieldOf("penalty", (Object)Difficulty.DEFAULT.penalty).forGetter(Difficulty::penalty), (App)Codec.INT.optionalFieldOf("decay", (Object)Difficulty.DEFAULT.decay).forGetter(Difficulty::decay), (App)Markers.CODEC.optionalFieldOf("markers", (Object)Difficulty.DEFAULT.markers).forGetter(Difficulty::markers), (App)Treasure.CODEC.optionalFieldOf("treasure", (Object)Difficulty.DEFAULT.treasure).forGetter(Difficulty::treasure), (App)Extras.CODEC.optionalFieldOf("extras", (Object)Difficulty.DEFAULT.extras).forGetter(Difficulty::extras)).apply((Applicative)instance, Difficulty::new));

        public Difficulty withTreasure(Treasure treasure) {
            return new Difficulty(this.speed, this.reward, this.rewardThin, this.penalty, this.decay, this.markers, treasure, this.extras);
        }

        public Difficulty withExtras(Extras extras) {
            return new Difficulty(this.speed, this.reward, this.rewardThin, this.penalty, this.decay, this.markers, this.treasure, extras);
        }

        public Difficulty withMarkers(Markers markers) {
            return new Difficulty(this.speed, this.reward, this.rewardThin, this.penalty, this.decay, markers, this.treasure, this.extras);
        }

        public record Markers(boolean first, boolean second, boolean firstThin, boolean secondThin) {
            public static final Markers DEFAULT = new Markers(true, true, false, false);
            public static final Markers TTFF = new Markers(true, true, false, false);
            public static final Markers TTTF = new Markers(true, true, true, false);
            public static final Markers TFTF = new Markers(true, false, true, false);
            public static final Markers FFTT = new Markers(false, false, true, true);
            public static final Markers TFFF = new Markers(true, false, false, false);
            public static final Markers TTTT = new Markers(true, true, true, true);
            public static final Codec<Markers> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("has_first_marker", (Object)Markers.DEFAULT.first).forGetter(Markers::first), (App)Codec.BOOL.optionalFieldOf("has_second_marker", (Object)Markers.DEFAULT.second).forGetter(Markers::second), (App)Codec.BOOL.optionalFieldOf("has_first_thin_marker", (Object)Markers.DEFAULT.firstThin).forGetter(Markers::firstThin), (App)Codec.BOOL.optionalFieldOf("has_second_thin_marker", (Object)Markers.DEFAULT.secondThin).forGetter(Markers::secondThin)).apply((Applicative)instance, Markers::new));
        }

        public record Extras(boolean isFlip, boolean isVanishing, boolean isMoving) {
            public static final Extras TFF = new Extras(true, false, false);
            public static final Extras FFF = new Extras(false, false, false);
            public static final Extras TTT = new Extras(true, true, true);
            public static final Extras TTF = new Extras(true, true, false);
            public static final Extras TFT = new Extras(true, false, true);
            public static final Extras FTF = new Extras(false, true, false);
            public static final Extras FFT = new Extras(false, false, true);
            public static final Extras DEFAULT = TFF;
            public static final Codec<Extras> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("flips_rotation_every_hit", (Object)Extras.DEFAULT.isFlip).forGetter(Extras::isFlip), (App)Codec.BOOL.optionalFieldOf("has_vanishing_markers", (Object)Extras.DEFAULT.isVanishing).forGetter(Extras::isVanishing), (App)Codec.BOOL.optionalFieldOf("has_moving_markers", (Object)Extras.DEFAULT.isMoving).forGetter(Extras::isMoving)).apply((Applicative)instance, Extras::new));
        }
    }

    public static enum Daytime implements StringRepresentable
    {
        ALL("all"),
        DAY("day"),
        NOON("noon"),
        NIGHT("night"),
        MIDNIGHT("midnight");

        public static final Codec<Daytime> CODEC;
        private final String key;

        private Daytime(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Daytime::values);
        }
    }

    public static enum Weather implements StringRepresentable
    {
        ALL("all"),
        CLEAR("clear"),
        RAIN("rain"),
        THUNDER("thunder");

        public static final Codec<Weather> CODEC;
        private final String key;

        private Weather(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Weather::values);
        }
    }

    public record Treasure(boolean hasTreasure, ResourceLocation loot, int hitReward) {
        public static final Codec<Treasure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("has_treasure", (Object)false).forGetter(Treasure::hasTreasure), (App)ResourceLocation.f_135803_.optionalFieldOf("loot", (Object)Starcatcher.rl("none")).forGetter(Treasure::loot), (App)Codec.INT.optionalFieldOf("hit_reward", (Object)0).forGetter(Treasure::hitReward)).apply((Applicative)instance, Treasure::new));
        public static final Treasure DEFAULT = new Treasure(false, Starcatcher.rl("waterlogged_satchel"), 15);
        public static final Treasure UNCOMMON = new Treasure(true, Starcatcher.rl("waterlogged_satchel"), 15);
        public static final Treasure HARD = new Treasure(true, Starcatcher.rl("treasure"), 15);
        public static final Treasure NETHER = new Treasure(true, Starcatcher.rl("scalding_treasure"), 28);
    }
}

