/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.bob.FishingBobEntity;
import com.wdiscute.starcatcher.minigame.FishingMinigameScreen;
import com.wdiscute.starcatcher.networkandcodecs.DataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtNetwork;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.SizeAndWeight;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class Payloads {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)Starcatcher.rl("fishing"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        CHANNEL.registerMessage(Payloads.id(), FishingBobUUIDPayload.class, FishingBobUUIDPayload::encode, FishingBobUUIDPayload::decode, FishingBobUUIDPayload::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(Payloads.id(), FishesCaughtPayload.class, FishesCaughtPayload::encode, FishesCaughtPayload::decode, FishesCaughtPayload::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(Payloads.id(), TrophiesCaughtPayload.class, TrophiesCaughtPayload::encode, TrophiesCaughtPayload::decode, TrophiesCaughtPayload::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(Payloads.id(), FishesNotificationPayload.class, FishesNotificationPayload::encode, FishesNotificationPayload::decode, FishesNotificationPayload::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(Payloads.id(), FishingPayload.class, FishingPayload::encode, FishingPayload::decode, FishingPayload::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(Payloads.id(), FishCaughtPayload.class, FishCaughtPayload::encode, FishCaughtPayload::decode, FishCaughtPayload::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(Payloads.id(), FishingCompletedPayload.class, FishingCompletedPayload::encode, FishingCompletedPayload::decode, FishingCompletedPayload::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(Payloads.id(), FishesSeenPayload.class, FishesSeenPayload::encode, FishesSeenPayload::decode, FishesSeenPayload::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static class FishingBobUUIDPayload {
        private final String playerUUID;
        private final String bobUUID;

        public FishingBobUUIDPayload(Player player, String uuid) {
            this.playerUUID = player.m_20149_();
            this.bobUUID = uuid;
        }

        public FishingBobUUIDPayload(String player, String uuid) {
            this.playerUUID = player;
            this.bobUUID = uuid;
        }

        public static void encode(FishingBobUUIDPayload fishesCaughtPayload, FriendlyByteBuf buf) {
            buf.m_130070_(fishesCaughtPayload.playerUUID);
            buf.m_130070_(fishesCaughtPayload.bobUUID);
        }

        public static FishingBobUUIDPayload decode(FriendlyByteBuf buf) {
            String playerUUID = buf.m_130277_();
            String bobUUID = buf.m_130277_();
            return new FishingBobUUIDPayload(playerUUID, bobUUID);
        }

        public static void handle(FishingBobUUIDPayload fishingBobUUIDPayload, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Player player = Minecraft.m_91087_().f_91073_.m_46003_(UUID.fromString(fishingBobUUIDPayload.playerUUID));
                if (player != null) {
                    DataAttachments.get(player).setFishing(fishingBobUUIDPayload.bobUUID);
                }
            });
            context.get().setPacketHandled(true);
        }
    }

    public static class FishesCaughtPayload {
        private final List<FishCaughtNetwork> fishesCaught;

        public FishesCaughtPayload(List<FishCaughtCounter> fishCaught, Player player) {
            ArrayList<FishCaughtNetwork> fishCaughtNetworks = new ArrayList<FishCaughtNetwork>();
            Registry fishProperties = player.m_9236_().m_9598_().m_175515_(Starcatcher.FISH_REGISTRY);
            for (FishCaughtCounter fcc : fishCaught) {
                ResourceLocation rl = null;
                for (FishProperties fp : fishProperties) {
                    if (!fp.equals(fcc.fp())) continue;
                    rl = fishProperties.m_7981_((Object)fp);
                }
                if (rl == null) {
                    rl = Starcatcher.rl("missingno");
                }
                fishCaughtNetworks.add(new FishCaughtNetwork(rl, fcc.count(), fcc.fastestTicks(), fcc.averageTicks(), fcc.size(), fcc.weight(), fcc.caughtGolden()));
            }
            this.fishesCaught = fishCaughtNetworks;
        }

        public FishesCaughtPayload(List<FishCaughtNetwork> fishCaught) {
            this.fishesCaught = fishCaught;
        }

        public static void encode(FishesCaughtPayload fishesCaughtPayload, FriendlyByteBuf buf) {
            buf.m_272073_(FishCaughtNetwork.LIST_CODEC, fishesCaughtPayload.fishesCaught);
        }

        public static FishesCaughtPayload decode(FriendlyByteBuf buf) {
            List fishesCaught = (List)buf.m_271872_(FishCaughtNetwork.LIST_CODEC);
            return new FishesCaughtPayload(fishesCaught);
        }

        public static void handle(FishesCaughtPayload fishesCaughtPayload, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> FishesCaughtPayload.client(fishesCaughtPayload.fishesCaught));
            context.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void client(List<FishCaughtNetwork> fishesCaught) {
            DataAttachments.setFishesCaughtClient(fishesCaught);
        }
    }

    public static class TrophiesCaughtPayload {
        private final List<TrophyProperties> tps;

        public TrophiesCaughtPayload(List<TrophyProperties> tpsCaught) {
            this.tps = tpsCaught;
        }

        public static void encode(TrophiesCaughtPayload trophiesCaughtPayload, FriendlyByteBuf buf) {
            buf.m_272073_(TrophyProperties.LIST_CODEC, trophiesCaughtPayload.tps);
        }

        public static TrophiesCaughtPayload decode(FriendlyByteBuf buf) {
            List tps = (List)buf.m_271872_(TrophyProperties.LIST_CODEC);
            return new TrophiesCaughtPayload(tps);
        }

        public static void handle(TrophiesCaughtPayload trophiesCaughtPayload, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> TrophiesCaughtPayload.client(trophiesCaughtPayload.tps));
            context.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void client(List<TrophyProperties> tps) {
            DataAttachments.get((Player)Minecraft.m_91087_().f_91074_).setTrophiesCaught(tps);
        }
    }

    public static class FishesNotificationPayload {
        private final List<ResourceLocation> fps;

        public FishesNotificationPayload(List<FishProperties> fps, Player player) {
            ArrayList<ResourceLocation> notifRLs = new ArrayList<ResourceLocation>();
            Registry fishProperties = player.m_9236_().m_9598_().m_175515_(Starcatcher.FISH_REGISTRY);
            for (FishProperties fp : fps) {
                ResourceLocation rl = null;
                for (FishProperties fpRegistry : fishProperties) {
                    if (!fpRegistry.equals(fp)) continue;
                    rl = fishProperties.m_7981_((Object)fpRegistry);
                }
                if (rl == null) {
                    rl = Starcatcher.rl("missingno");
                }
                notifRLs.add(rl);
            }
            this.fps = notifRLs;
        }

        public FishesNotificationPayload(List<ResourceLocation> tpsCaught) {
            this.fps = tpsCaught;
        }

        public static void encode(FishesNotificationPayload fishesNotificationPayload, FriendlyByteBuf buf) {
            buf.m_272073_(ResourceLocation.f_135803_.listOf(), fishesNotificationPayload.fps);
        }

        public static FishesNotificationPayload decode(FriendlyByteBuf buf) {
            List tps = (List)buf.m_271872_(ResourceLocation.f_135803_.listOf());
            return new FishesNotificationPayload(tps);
        }

        public static void handle(FishesNotificationPayload fishesNotificationPayload, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> FishesNotificationPayload.client(fishesNotificationPayload.fps));
            context.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void client(List<ResourceLocation> fps) {
            DataAttachments.setFishNotificationsClient(fps);
        }
    }

    public static class FishingPayload {
        private final FishProperties fp;
        private final ItemStack rod;

        public FishingPayload(FishProperties fp, ItemStack rod) {
            this.fp = fp;
            this.rod = rod;
        }

        public static void encode(FishingPayload fishingPayload, FriendlyByteBuf buf) {
            buf.m_272073_(FishProperties.CODEC, (Object)fishingPayload.fp);
            buf.m_130079_(fishingPayload.rod.serializeNBT());
        }

        public static FishingPayload decode(FriendlyByteBuf buf) {
            FishProperties fp = (FishProperties)buf.m_271872_(FishProperties.CODEC);
            CompoundTag tag = buf.m_130260_();
            ItemStack rod = ItemStack.m_41712_((CompoundTag)tag);
            return new FishingPayload(fp, rod);
        }

        public static void handle(FishingPayload fishingPayload, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> FishingPayload.clientScreen(fishingPayload.fp, fishingPayload.rod));
            context.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void clientScreen(FishProperties fp, ItemStack rod) {
            Minecraft.m_91087_().m_91152_((Screen)new FishingMinigameScreen(fp, rod));
        }
    }

    public static class FishCaughtPayload {
        private final FishProperties fp;
        private final boolean newFish;
        private final int size;
        private final int weight;

        public FishCaughtPayload(FishProperties fp, boolean newFish, int size, int weight) {
            this.fp = fp;
            this.newFish = newFish;
            this.size = size;
            this.weight = weight;
        }

        public static void encode(FishCaughtPayload fishCaughtPayload, FriendlyByteBuf buf) {
            buf.m_272073_(FishProperties.CODEC, (Object)fishCaughtPayload.fp);
            buf.writeBoolean(fishCaughtPayload.newFish);
            buf.writeInt(fishCaughtPayload.size);
            buf.writeInt(fishCaughtPayload.weight);
        }

        public static FishCaughtPayload decode(FriendlyByteBuf buf) {
            FishProperties fp = (FishProperties)buf.m_271872_(FishProperties.CODEC);
            boolean newFish = buf.readBoolean();
            int size = buf.readInt();
            int weight = buf.readInt();
            return new FishCaughtPayload(fp, newFish, size, weight);
        }

        public static void handle(FishCaughtPayload data, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> Starcatcher.fishCaughtToast(data.fp, data.newFish, data.size, data.weight));
            context.get().setPacketHandled(true);
        }
    }

    public static class FishingCompletedPayload {
        private final int time;
        private final boolean completedTreasure;
        private final boolean perfectCatch;
        private final int hits;

        public FishingCompletedPayload(int tickCount, boolean awardTreasure, boolean perfectCatch, int consecutiveHits) {
            this.time = tickCount;
            this.completedTreasure = awardTreasure;
            this.perfectCatch = perfectCatch;
            this.hits = consecutiveHits;
        }

        public static void encode(FishingCompletedPayload fishingCompletedPayload, FriendlyByteBuf buf) {
            buf.writeInt(fishingCompletedPayload.time);
            buf.writeBoolean(fishingCompletedPayload.completedTreasure);
            buf.writeBoolean(fishingCompletedPayload.perfectCatch);
            buf.writeInt(fishingCompletedPayload.hits);
        }

        public static FishingCompletedPayload decode(FriendlyByteBuf buf) {
            int tickCount = buf.readInt();
            boolean awardTreasure = buf.readBoolean();
            boolean perfectCatch = buf.readBoolean();
            int consecutiveHits = buf.readInt();
            return new FishingCompletedPayload(tickCount, awardTreasure, perfectCatch, consecutiveHits);
        }

        public static void handle(FishingCompletedPayload data, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                ServerLevel level = (ServerLevel)player.m_9236_();
                List entities = level.m_45933_(null, new AABB(-25.0, -65.0, -25.0, 25.0, 65.0, 25.0).m_82383_(player.m_20182_()));
                for (Entity entity : entities) {
                    if (!entity.m_20148_().toString().equals(DataAttachments.get((Player)player).fishing()) || !(entity instanceof FishingBobEntity)) continue;
                    FishingBobEntity fbe = (FishingBobEntity)entity;
                    if (data.time != -1) {
                        FishProperties fp = fbe.fpToFish;
                        ItemStack is = new ItemStack(fbe.fpToFish.fish());
                        ItemStack treasure = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(fbe.fpToFish.dif().treasure().loot()));
                        if (!fp.customName().isEmpty()) {
                            is.m_41714_((Component)Component.m_237113_((String)fp.customName()));
                        }
                        DataComponents.setFishProperties(is, fp);
                        int size = FishCaughtCounter.getRandomSize(fp);
                        int weight = FishCaughtCounter.getRandomWeight(fp);
                        DataComponents.setSizeAndWeight(is, new SizeAndWeight(size, weight));
                        FishCaughtCounter.AwardFishCaughtCounter(fbe.fpToFish, (Player)player, data.time, size, weight);
                        if (data.perfectCatch && fbe.hook.m_150930_((Item)ModItems.SPLIT_HOOK.get())) {
                            is.m_41764_(2);
                        }
                        ItemEntity itemFished = new ItemEntity((Level)level, fbe.m_20182_().f_82479_, fbe.m_20182_().f_82480_ + (double)1.2f, fbe.m_20182_().f_82481_, is);
                        ItemEntity treasureFished = new ItemEntity((Level)level, fbe.m_20182_().f_82479_, fbe.m_20182_().f_82480_ + (double)1.2f, fbe.m_20182_().f_82481_, treasure);
                        double x = Mth.m_14008_((double)((player.m_20182_().f_82479_ - fbe.m_20182_().f_82479_) / 25.0), (double)-1.0, (double)1.0);
                        double y = Mth.m_14008_((double)((player.m_20182_().f_82480_ - fbe.m_20182_().f_82480_) / 20.0), (double)-1.0, (double)1.0);
                        double z = Mth.m_14008_((double)((player.m_20182_().f_82481_ - fbe.m_20182_().f_82481_) / 25.0), (double)-1.0, (double)1.0);
                        Vec3 vec3 = new Vec3(x, 0.7 + y, z);
                        itemFished.m_20256_(vec3);
                        treasureFished.m_20256_(vec3);
                        level.m_7967_((Entity)itemFished);
                        if (data.completedTreasure) {
                            level.m_7967_((Entity)treasureFished);
                        }
                        Vec3 p = player.m_20182_();
                        level.m_6263_(null, p.f_82479_, p.f_82480_, p.f_82481_, SoundEvents.f_12504_, SoundSource.AMBIENT, 1.0f, 1.0f);
                        ArrayList<FishProperties> list = new ArrayList<FishProperties>(DataAttachments.get((Player)player).fishNotifications());
                        list.add(fbe.fpToFish);
                        DataAttachments.get((Player)player).setFishNotifications(list);
                        int exp = 4;
                        if (fp.rarity() == FishProperties.Rarity.UNCOMMON) {
                            exp = 8;
                        }
                        if (fp.rarity() == FishProperties.Rarity.RARE) {
                            exp = 12;
                        }
                        if (fp.rarity() == FishProperties.Rarity.EPIC) {
                            exp = 20;
                        }
                        if (fp.rarity() == FishProperties.Rarity.LEGENDARY) {
                            exp = 35;
                        }
                        if (fbe.hook.m_150930_((Item)ModItems.GOLD_HOOK.get())) {
                            exp *= (int)((double)data.hits / 3.0) + 1;
                        }
                        player.m_6756_(exp);
                    } else {
                        Vec3 p = player.m_20182_();
                        level.m_6263_(null, p.f_82479_, p.f_82480_, p.f_82481_, SoundEvents.f_12507_, SoundSource.AMBIENT, 1.0f, 1.0f);
                    }
                    fbe.m_6074_();
                }
                DataAttachments.get((Player)player).setFishing("");
                ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            });
        }
    }

    public static class FishesSeenPayload {
        private final List<ResourceLocation> fishesSeenRLs;

        public FishesSeenPayload(List<ResourceLocation> rls) {
            this.fishesSeenRLs = rls;
        }

        public static void encode(FishesSeenPayload fishesSeenPayload, FriendlyByteBuf buf) {
            buf.m_272073_(ResourceLocation.f_135803_.listOf(), fishesSeenPayload.fishesSeenRLs);
        }

        public static FishesSeenPayload decode(FriendlyByteBuf buf) {
            List rls = (List)buf.m_271872_(ResourceLocation.f_135803_.listOf());
            return new FishesSeenPayload(rls);
        }

        public static void handle(FishesSeenPayload fishesSeenPayload, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                List<FishProperties> currentNotifications = DataAttachments.get((Player)player).fishNotifications();
                Registry registry = player.m_9236_().m_9598_().m_175515_(Starcatcher.FISH_REGISTRY);
                ArrayList<FishProperties> fishesSeen = new ArrayList<FishProperties>();
                for (ResourceLocation rl : fishesSeenPayload.fishesSeenRLs) {
                    FishProperties fp = (FishProperties)registry.m_7745_(rl);
                    if (fp == null) {
                        fp = FishProperties.DEFAULT;
                    }
                    fishesSeen.add(fp);
                }
                ArrayList<FishProperties> newList = new ArrayList<FishProperties>(currentNotifications);
                fishesSeen.stream().forEach(f -> currentNotifications.stream().forEach(n -> {
                    if (n.equals(f)) {
                        newList.remove(n);
                    }
                }));
                DataAttachments.get((Player)player).setFishNotifications(newList);
            });
            context.get().setPacketHandled(true);
        }
    }
}

