/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.blocks;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.wdiscute.starcatcher.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.blocks.TrophyBlockEntity;
import com.wdiscute.starcatcher.networkandcodecs.DataComponents;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class TrophyBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public TrophyBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60953_(state -> 5).m_60918_(SoundType.f_154654_));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity tbe = (TrophyBlockEntity)blockEntity;
            tbe.setTrophyProperties(DataComponents.getTrophyProperties(stack));
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity;
        if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46136_) && (blockentity = level.m_7702_(pos)) instanceof TrophyBlockEntity) {
            TrophyBlockEntity tbe = (TrophyBlockEntity)blockentity;
            ItemStack itemstack = new ItemStack((ItemLike)this);
            CompoundTag tag = itemstack.m_41784_();
            if (!tbe.trophyProperties.equals(TrophyProperties.DEFAULT)) {
                TrophyProperties.CODEC.encode((Object)tbe.trophyProperties, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).ifPresent(tag1 -> tag.m_128365_("trophy_properties", tag1));
                if (!tbe.trophyProperties.customName().equals(TrophyProperties.DEFAULT.customName())) {
                    itemstack.m_41714_((Component)Component.m_237113_((String)tbe.trophyProperties.customName()));
                }
            }
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemstack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_((Property)f_54117_) == Direction.WEST || ((Direction)state.m_61143_((Property)f_54117_)).equals((Object)Direction.EAST)) {
            return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.m_49796_((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.m_49796_((double)6.0, (double)6.0, (double)1.0, (double)10.0, (double)14.0, (double)15.0)});
        }
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), Block.m_49796_((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.m_49796_((double)1.0, (double)6.0, (double)6.0, (double)15.0, (double)14.0, (double)10.0)});
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_});
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState bs = this.m_49966_();
        bs = (BlockState)bs.m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
        bs = (BlockState)bs.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_192917_((Fluid)Fluids.f_76193_)));
        return bs;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ModBlockEntities.TROPHY.get().m_155264_(blockPos, blockState);
    }
}

