/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.wdiscute.starcatcher.items.ColorfulBobber;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.SizeAndWeight;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import com.wdiscute.starcatcher.secretnotes.SecretNote;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class DataComponents {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void setSecretNote(ItemStack is, SecretNote.Note note) {
        is.m_41784_().m_128359_("secret_note", note.m_7912_());
    }

    public static SecretNote.Note getSecretNote(ItemStack is) {
        if (is.m_41782_() && is.m_41783_().m_128423_("secret_note") != null) {
            return SecretNote.Note.getBySerializedName(is.m_41783_().m_128461_("secret_note"));
        }
        return SecretNote.Note.SAMPLE_NOTE;
    }

    public static FishProperties getFishProperties(ItemStack is) {
        if (is.m_41782_() && is.m_41784_().m_128441_("fish_properties")) {
            return (FishProperties)((Pair)FishProperties.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)is.m_41783_().m_128423_("fish_properties")).result().get()).getFirst();
        }
        return FishProperties.DEFAULT;
    }

    public static void setFishProperties(ItemStack is, FishProperties fp) {
        CompoundTag compoundTag = new CompoundTag();
        FishProperties.CODEC.encode((Object)fp, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).ifPresent(tag -> compoundTag.m_128365_("fish_properties", tag));
        is.m_41784_().m_128365_("fish_properties", (Tag)compoundTag);
    }

    public static TrophyProperties getTrophyProperties(ItemStack is) {
        if (is.m_41782_() && is.m_41783_().m_128441_("trophy_properties")) {
            CompoundTag trophyProperties = is.m_41784_().m_128469_("trophy_properties");
            DataResult decode = TrophyProperties.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)trophyProperties);
            return decode.result().orElse(TrophyProperties.DEFAULT);
        }
        return TrophyProperties.DEFAULT;
    }

    public static void setTrophyProperties(ItemStack is, TrophyProperties tp) {
        TrophyProperties.CODEC.encode((Object)tp, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).ifPresent(tag -> is.m_41784_().m_128365_("trophy_properties", tag));
    }

    public static void setSizeAndWeight(ItemStack is, SizeAndWeight sw) {
        is.m_41784_().m_128405_("starcatcher_size", sw.sizeInCentimeters());
        is.m_41784_().m_128405_("starcatcher_weight", sw.weightInGrams());
    }

    public static SizeAndWeight getSizeAndWeight(ItemStack is) {
        if (is.m_41782_() && is.m_41783_().m_128441_("starcatcher_size")) {
            return new SizeAndWeight(is.m_41783_().m_128451_("starcatcher_size"), is.m_41783_().m_128451_("starcatcher_weight"));
        }
        return SizeAndWeight.DEFAULT;
    }

    public static void setBobberColor(ItemStack is, ColorfulBobber.BobberColor bobberColor) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("starcatcher_r", bobberColor.r());
        tag.m_128350_("starcatcher_g", bobberColor.g());
        tag.m_128350_("starcatcher_b", bobberColor.b());
        is.m_41784_().m_128365_("starcatcher_bobber_color", (Tag)tag);
    }

    public static ColorfulBobber.BobberColor getBobberColor(ItemStack is) {
        if (is.m_41782_()) {
            CompoundTag compound = is.m_41783_().m_128469_("starcatcher_bobber_color");
            return new ColorfulBobber.BobberColor(compound.m_128457_("starcatcher_r"), compound.m_128457_("starcatcher_g"), compound.m_128457_("starcatcher_b"));
        }
        return ColorfulBobber.BobberColor.DEFAULT;
    }

    public static void setItemInSlot(ItemStack is, Slots slotToSave, ItemStack stackToSave) {
        CompoundTag tag = new CompoundTag();
        stackToSave.m_41739_(tag);
        is.m_41784_().m_128365_(slotToSave.m_7912_(), (Tag)tag);
    }

    public static ItemStack getItemInSlot(ItemStack is, Slots slotToGet) {
        if (is.m_41782_()) {
            CompoundTag compound = is.m_41783_().m_128469_(slotToGet.m_7912_());
            return ItemStack.m_41712_((CompoundTag)compound);
        }
        return ItemStack.f_41583_;
    }

    public static enum Slots implements StringRepresentable
    {
        BOBBER("bobber"),
        BAIT("bait"),
        HOOK("hook");

        private final String key;

        private Slots(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }
    }
}

