/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.muhammaddaffa.mdlib.commandapi.CommandAPIBukkit;
import com.muhammaddaffa.mdlib.commandapi.CommandAPIHandler;
import com.muhammaddaffa.mdlib.commandapi.arguments.Argument;
import com.muhammaddaffa.mdlib.commandapi.arguments.CommandAPIArgumentType;
import com.muhammaddaffa.mdlib.commandapi.arguments.GreedyArgument;
import com.muhammaddaffa.mdlib.commandapi.arguments.PreviewInfo;
import com.muhammaddaffa.mdlib.commandapi.arguments.Previewable;
import com.muhammaddaffa.mdlib.commandapi.commandsenders.BukkitPlayer;
import com.muhammaddaffa.mdlib.commandapi.exceptions.SpigotNotFoundException;
import com.muhammaddaffa.mdlib.commandapi.exceptions.WrapperCommandSyntaxException;
import com.muhammaddaffa.mdlib.commandapi.executors.CommandArguments;
import com.muhammaddaffa.mdlib.commandapi.wrappers.PreviewableFunction;
import java.util.Optional;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatArgument
extends Argument<BaseComponent[]>
implements GreedyArgument,
Previewable<ChatArgument, BaseComponent[]> {
    private PreviewableFunction<BaseComponent[]> preview;
    private boolean usePreview;

    public ChatArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentChat());
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (ClassNotFoundException e) {
            throw new SpigotNotFoundException(this.getClass());
        }
    }

    @Override
    public Class<BaseComponent[]> getPrimitiveType() {
        return BaseComponent[].class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CHAT;
    }

    @Override
    public <CommandSourceStack> BaseComponent[] parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource();
        BaseComponent[] component = CommandAPIBukkit.get().getChat(cmdCtx, key);
        Optional<PreviewableFunction<BaseComponent[]>> previewOptional = this.getPreview();
        if (this.usePreview && previewOptional.isPresent() && sender instanceof Player) {
            Player player = (Player)sender;
            try {
                BaseComponent[] previewComponent;
                component = previewComponent = previewOptional.get().generatePreview(new PreviewInfo<BaseComponent[]>(new BukkitPlayer(player), CommandAPIHandler.getRawArgumentInput(cmdCtx, key), cmdCtx.getInput(), component));
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
        }
        return component;
    }

    @Override
    public ChatArgument withPreview(PreviewableFunction<BaseComponent[]> preview) {
        this.preview = preview;
        return this;
    }

    @Override
    public Optional<PreviewableFunction<BaseComponent[]>> getPreview() {
        return Optional.ofNullable(this.preview);
    }

    @Override
    public boolean isLegacy() {
        return true;
    }

    @Override
    public ChatArgument usePreview(boolean usePreview) {
        this.usePreview = usePreview;
        return this;
    }
}

