/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.muhammaddaffa.mdlib.commandapi.CommandAPIBukkit;
import com.muhammaddaffa.mdlib.commandapi.arguments.CommandAPIArgumentType;
import com.muhammaddaffa.mdlib.commandapi.arguments.LocationType;
import com.muhammaddaffa.mdlib.commandapi.arguments.SafeOverrideableArgument;
import com.muhammaddaffa.mdlib.commandapi.executors.CommandArguments;
import org.bukkit.Location;

public class LocationArgument
extends SafeOverrideableArgument<Location, Location> {
    private final boolean isPrecise;

    public LocationArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public LocationArgument(String nodeName, LocationType type) {
        this(nodeName, type, true);
    }

    public LocationArgument(String nodeName, LocationType type, boolean centerPosition) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get()._ArgumentPosition() : CommandAPIBukkit.get()._ArgumentVec3(centerPosition), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockY() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getY() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location> getPrimitiveType() {
        return Location.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION;
    }

    @Override
    public <CommandSourceStack> Location parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getLocationPrecise(cmdCtx, key) : CommandAPIBukkit.get().getLocationBlock(cmdCtx, key);
    }
}

