/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import com.muhammaddaffa.mdlib.commandapi.CommandAPI;
import com.muhammaddaffa.mdlib.commandapi.CommandAPIHandler;
import com.muhammaddaffa.mdlib.commandapi.CommandRegistrationStrategy;
import com.muhammaddaffa.mdlib.commandapi.SafeVarHandle;
import com.muhammaddaffa.mdlib.commandapi.SpigotCommandRegistration;
import com.muhammaddaffa.mdlib.commandapi.arguments.ArgumentSubType;
import com.muhammaddaffa.mdlib.commandapi.arguments.SuggestionProviders;
import com.muhammaddaffa.mdlib.commandapi.commandsenders.AbstractCommandSender;
import com.muhammaddaffa.mdlib.commandapi.commandsenders.BukkitCommandSender;
import com.muhammaddaffa.mdlib.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import com.muhammaddaffa.mdlib.commandapi.nms.NMS_CommonWithFunctions;
import com.muhammaddaffa.mdlib.commandapi.wrappers.ComplexRecipeImpl;
import com.muhammaddaffa.mdlib.commandapi.wrappers.FloatRange;
import com.muhammaddaffa.mdlib.commandapi.wrappers.FunctionWrapper;
import com.muhammaddaffa.mdlib.commandapi.wrappers.IntegerRange;
import com.muhammaddaffa.mdlib.commandapi.wrappers.Location2D;
import com.muhammaddaffa.mdlib.commandapi.wrappers.NativeProxyCommandSender;
import com.muhammaddaffa.mdlib.commandapi.wrappers.ParticleData;
import com.muhammaddaffa.mdlib.commandapi.wrappers.ScoreboardSlot;
import com.muhammaddaffa.mdlib.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_20_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftSound;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_20_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionEffectType;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;

public class NMS_1_20_R1
extends NMS_CommonWithFunctions {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final SafeVarHandle<ArgumentPredicateItemStack, NBTTagCompound> itemInput;
    private static final Field serverFunctionLibraryDispatcher;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(MinecraftKey key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.r);
    }

    @Override
    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.ap);
    }

    @Override
    public final Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.20", "1.20.1"};
    }

    @Override
    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).w().m_();
    }

    @Override
    public final String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), particle.data()).a();
    }

    private final SimpleFunctionWrapper convertFunction(CustomFunction commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).aA().a(commandFunction, css);
        CustomFunction.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_20_R1.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    @Override
    public final void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    @Override
    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key).bukkit;
    }

    @Override
    public NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Integer color = ArgumentChatFormat.a(cmdCtx, (String)key).f();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    @Override
    public final Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public final Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        MinecraftKey resourceLocation = ResourceArgument.a(cmdCtx, (String)key, (ResourceKey)Registries.ap).g().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_20_R1.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    @Override
    public final Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).e(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public final BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    @Override
    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender.getSource());
    }

    @Override
    public final World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld();
    }

    @Override
    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return org.bukkit.enchantments.Enchantment.getByKey((NamespacedKey)NMS_1_20_R1.fromResourceLocation(BuiltInRegistries.g.b((Object)((Enchantment)ResourceArgument.g(cmdCtx, (String)key).a()))));
    }

    @Override
    public final Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument.b((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
            }
        }
        return object;
    }

    @Override
    public final EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.a((EntityTypes)((EntityTypes)ResourceArgument.e(cmdCtx, (String)key).a())).a());
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.DoubleRange range = ArgumentCriterionValue.a.a(cmdCtx, (String)key);
        Double lowBoxed = (Double)range.a();
        Double highBoxed = (Double)range.b();
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    @Override
    public final FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction commandFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(commandFunction), css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        Integer lowBoxed = (Integer)range.a();
        Integer highBoxed = (Integer)range.b();
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    @Override
    public final ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key);
        net.minecraft.world.item.ItemStack itemWithMaybeTag = input.a(1, false);
        NBTTagCompound tag = itemInput.get(input);
        if (tag != null) {
            byte count = tag.f("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((net.minecraft.world.item.ItemStack)itemWithMaybeTag));
        return result;
    }

    @Override
    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public final Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.c(), blockPos.d());
    }

    @Override
    public final Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public final Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.c(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    @Override
    public final Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.b(cmdCtx, (String)key).a((CommandListenerWrapper)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    @Override
    public final LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_20_R1.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).aH().getLootTable(resourceLocation));
    }

    @Override
    public final ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)options.c()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<ItemStack>(particle, CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.c()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options.c());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().x() * 255.0f)), (int)((int)(options.d().y() * 255.0f)), (int)((int)(options.d().z() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, Particle particle, VibrationParticleOption options) {
        Vec3D origin = ((CommandListenerWrapper)cmdCtx.getSource()).d();
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        PositionSource positionSource = options.c();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.c()));
            return new ParticleData<Object>(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3D to = (Vec3D)positionSource2.a((net.minecraft.world.level.World)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options.d()));
    }

    @Override
    public Object getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.getByKey((NamespacedKey)NMS_1_20_R1.fromResourceLocation(BuiltInRegistries.e.b((Object)((MobEffectList)ResourceArgument.f(cmdCtx, (String)key).a()))));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_20_R1.fromResourceLocation(ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final Recipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        IRecipe recipe = ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_20_R1.fromResourceLocation(recipe.e()), recipe.toBukkitRecipe());
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft(ArgumentScoreboardSlot.a(cmdCtx, (String)key));
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3D pos = css.d();
        Vec2F rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        Entity proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    @Override
    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                SoundEffect soundEvent = (SoundEffect)BuiltInRegistries.c.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((SoundEffect)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).aA();
                ICompletionProvider.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).az().a().stream().map(Advancement::j), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).aH().a(LootDataType.c), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> CompletionProviders.d;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> ICompletionProvider.a((Iterable)BuiltInRegistries.e.e(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).aA().b(new MinecraftKey(key.getNamespace(), key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (CustomFunction customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction(customFunction);
        }
        return convertedCustomFunctions;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aA().f()) {
            result.add(NMS_1_20_R1.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    @Override
    public final void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).au;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aC();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aB().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aU().F().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aB().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        IRegistryCustom.Dimension registryAccess = ((MinecraftServer)this.getMinecraftServer()).aV();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ResourcePackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aB();
            ArrayList<IResourcePack> packResources = new ArrayList<IResourcePack>();
            for (String packID : collection) {
                ResourcePackLoader pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.e());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ResourceManager resourceManager = new ResourceManager(EnumResourcePackType.b, packResources);
            CompletableFuture simpleReloadInstance = Reloadable.a((IResourceManager)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).as, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).au.close();
            ((MinecraftServer)this.getMinecraftServer()).au = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aB().a(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aB().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aB().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aU().a(new WorldDataConfiguration(new DataPackConfiguration((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).aU().F().b()));
            ((MinecraftServer)this.getMinecraftServer()).au.b().a((IRegistryCustom)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).aT().a((IResourceManager)((MinecraftServer)this.getMinecraftServer()).au.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bl()) {
            ((MinecraftServer)this.getMinecraftServer()).c(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.O);
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.a((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.s);
    }

    @Override
    public CommandRegistrationStrategy<CommandListenerWrapper> createCommandRegistrationStrategy() {
        return new SpigotCommandRegistration<CommandListenerWrapper>(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).aC().a(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = CommandBuildContext.a((IRegistryCustom)server2.getServer().aV(), (FeatureFlagSet)server2.getServer().aU().F().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, "p", "usesSelector");
        itemInput = SafeVarHandle.ofOrNull(ArgumentPredicateItemStack.class, "c", "tag", NBTTagCompound.class);
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(CustomFunctionManager.class, "g", "dispatcher");
    }
}

