/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.utils.updatechecker;

import com.muhammaddaffa.mdlib.utils.updatechecker.DefaultArtifactVersion;
import com.muhammaddaffa.mdlib.utils.updatechecker.ThrowingFunction;
import com.muhammaddaffa.mdlib.utils.updatechecker.UpdateCheckEvent;
import com.muhammaddaffa.mdlib.utils.updatechecker.UpdateCheckListener;
import com.muhammaddaffa.mdlib.utils.updatechecker.UpdateCheckResult;
import com.muhammaddaffa.mdlib.utils.updatechecker.UpdateCheckSource;
import com.muhammaddaffa.mdlib.utils.updatechecker.UpdateCheckSuccess;
import com.muhammaddaffa.mdlib.utils.updatechecker.UserAgentBuilder;
import com.muhammaddaffa.mdlib.utils.updatechecker.VersionMapper;
import com.muhammaddaffa.mdlib.utils.updatechecker.VersionSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker {
    static final String VERSION = "3.0.1";
    private static final String SPIGOT_CHANGELOG_SUFFIX = "/history";
    private static final String SPIGOT_DOWNLOAD_LINK = "https://www.spigotmc.org/resources/";
    private static final String SPIGOT_UPDATE_API = "https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id=%s";
    private static final String POLYMART_CHANGELOG_SUFFIX = "/updates";
    private static final String POLYMART_DOWNLOAD_LINK = "https://polymart.org/resource/";
    private static final String POLYMART_UPDATE_API = "https://api.polymart.org/v1/getResourceInfoSimple/?resource_id=%s&key=version";
    private static final String SPIGET_UPDATE_API = "https://api.spiget.org/v2/resources/%s/versions/latest";
    private static final String GITHUB_RELEASE_API = "https://api.github.com/repos/%s/%s/releases";
    private static final String HANGAR_RELEASE_API = "https://hangar.papermc.io/api/v1/projects/%s/%s/latest?channel=%s";
    private static UpdateChecker instance = null;
    private static boolean listenerAlreadyRegistered = false;
    private final String spigotUserId = "%%__USER__%%";
    private final String apiLink;
    private final ThrowingFunction<BufferedReader, String, IOException> mapper;
    private final UpdateCheckSource updateCheckSource;
    private final VersionSupplier supplier;
    private final Plugin plugin;
    private String changelogLink = null;
    private boolean checkedAtLeastOnce = false;
    private boolean coloredConsoleOutput = false;
    private String donationLink = null;
    private String freeDownloadLink = null;
    private String latestVersion = null;
    private String nameFreeVersion = "Free";
    private String namePaidVersion = "Paid";
    private boolean notifyOpsOnJoin = true;
    private String notifyPermission = null;
    private boolean notifyRequesters = true;
    private String supportLink = null;
    private boolean suppressUpToDateMessage = true;
    private BiConsumer<CommandSender[], Exception> onFail = (requesters, ex) -> ex.printStackTrace();
    private BiConsumer<CommandSender[], String> onSuccess;
    private String paidDownloadLink;
    private int taskId;
    private int timeout;
    private String usedVersion;
    private String userAgentString;
    private boolean usingPaidVersion;

    public UpdateChecker(@NotNull JavaPlugin plugin, @NotNull VersionSupplier supplier) {
        this.onSuccess = (requesters, latestVersion) -> {};
        this.paidDownloadLink = null;
        this.taskId = -1;
        this.timeout = 0;
        this.userAgentString = null;
        this.usingPaidVersion = false;
        instance = this;
        this.plugin = plugin;
        this.apiLink = null;
        this.supplier = supplier;
        this.updateCheckSource = null;
        this.mapper = null;
        this.init();
    }

    private void init() {
        Objects.requireNonNull(this.plugin, "Plugin cannot be null.");
        this.usedVersion = this.plugin.getDescription().getVersion().trim();
        if (this.detectPaidVersion()) {
            this.usingPaidVersion = true;
        }
        if (!listenerAlreadyRegistered) {
            Bukkit.getPluginManager().registerEvents((Listener)new UpdateCheckListener(), this.plugin);
            listenerAlreadyRegistered = true;
        }
    }

    private boolean detectPaidVersion() {
        return "%%__USER__%%".matches("^[0-9]+$");
    }

    public UpdateChecker(@NotNull JavaPlugin plugin, @NotNull UpdateCheckSource updateCheckSource, @NotNull String parameter) {
        ThrowingFunction<BufferedReader, String, IOException> mapper;
        String apiLink;
        this.onSuccess = (requesters, latestVersion) -> {};
        this.paidDownloadLink = null;
        this.taskId = -1;
        this.timeout = 0;
        this.userAgentString = null;
        this.usingPaidVersion = false;
        instance = this;
        this.plugin = plugin;
        this.supplier = null;
        this.updateCheckSource = updateCheckSource;
        switch (this.updateCheckSource) {
            case CUSTOM_URL: {
                apiLink = parameter;
                mapper = VersionMapper.TRIM_FIRST_LINE;
                break;
            }
            case SPIGOT: {
                apiLink = String.format(SPIGOT_UPDATE_API, parameter);
                mapper = VersionMapper.SPIGOT;
                break;
            }
            case POLYMART: {
                apiLink = String.format(POLYMART_UPDATE_API, parameter);
                mapper = VersionMapper.TRIM_FIRST_LINE;
                break;
            }
            case SPIGET: {
                apiLink = String.format(SPIGET_UPDATE_API, parameter);
                mapper = VersionMapper.SPIGET;
                break;
            }
            case GITHUB_RELEASE_TAG: {
                String[] split = parameter.split("/");
                if (split.length < 2) {
                    throw new IllegalArgumentException("Given GitHub repository must be in the format \"<UserOrOrganizationName>/<RepositoryName>\"");
                }
                apiLink = String.format(GITHUB_RELEASE_API, split[0], split[1]);
                mapper = VersionMapper.GITHUB_RELEASE_TAG;
                break;
            }
            case HANGAR: {
                String[] split = parameter.split("/");
                if (split.length < 3) {
                    throw new IllegalArgumentException("Given HangarMC project must be in the format \"<UserOrOrganizationName>/<ProjectName>/<ReleaseChannel>\"");
                }
                apiLink = String.format(HANGAR_RELEASE_API, split[0], split[1], split[2]);
                mapper = VersionMapper.TRIM_FIRST_LINE;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        Objects.requireNonNull(apiLink, "API Link cannot be null.");
        this.apiLink = apiLink;
        this.mapper = mapper;
        this.init();
    }

    @Deprecated
    public static UpdateChecker getInstance() {
        return instance;
    }

    @Deprecated
    public static UpdateChecker init(@NotNull JavaPlugin plugin, int spigotResourceId) {
        return new UpdateChecker(plugin, UpdateCheckSource.SPIGOT, String.valueOf(spigotResourceId));
    }

    @Deprecated
    public static UpdateChecker init(@NotNull JavaPlugin plugin, @NotNull String apiLink) {
        return new UpdateChecker(plugin, UpdateCheckSource.CUSTOM_URL, apiLink);
    }

    private static void checkRelocation() {
        if (Bukkit.getServer().getClass().getName().equals("be.seeseemelk.mockbukkit.ServerMock")) {
            return;
        }
        String defaultPackageDe = new String(new byte[]{100, 101, 46, 106, 101, 102, 102, 95, 109, 101, 100, 105, 97, 46, 117, 112, 100, 97, 116, 101, 99, 104, 101, 99, 107, 101, 114});
        String defaultPackageCom = new String(new byte[]{99, 111, 109, 46, 106, 101, 102, 102, 95, 109, 101, 100, 105, 97, 46, 117, 112, 100, 97, 116, 101, 99, 104, 101, 99, 107, 101, 114});
        String examplePackage = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
        String packageName = UpdateChecker.class.getPackage().getName();
        if (packageName.startsWith(defaultPackageDe) || packageName.startsWith(defaultPackageCom) || packageName.startsWith(examplePackage)) {
            throw new IllegalStateException("SpigotUpdateChecker class has not been relocated correctly! Check the GitHub's README.md for instructions.");
        }
    }

    public boolean isSuppressUpToDateMessage() {
        return this.suppressUpToDateMessage;
    }

    public UpdateChecker checkEveryXHours(double hours) {
        double minutes = hours * 60.0;
        double seconds = minutes * 60.0;
        long ticks = (long)((int)seconds) * 20L;
        this.stop();
        this.taskId = ticks > 0L ? Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> this.checkNow(new CommandSender[]{Bukkit.getConsoleSender()}), ticks, ticks) : -1;
        return this;
    }

    public UpdateChecker stop() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
        this.taskId = -1;
        return this;
    }

    public UpdateChecker checkNow(CommandSender ... requesters) {
        if (this.plugin == null) {
            throw new IllegalStateException("Plugin has not been set.");
        }
        if (this.apiLink == null && this.supplier == null) {
            throw new IllegalStateException("API Link has not been set and no supplier was provided.");
        }
        this.checkedAtLeastOnce = true;
        if (this.userAgentString == null) {
            this.userAgentString = UserAgentBuilder.getDefaultUserAgent().build();
        }
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            UpdateCheckEvent updateCheckEvent;
            try {
                if (this.supplier != null) {
                    this.latestVersion = this.supplier.getLatestVersionString();
                } else {
                    HttpURLConnection httpConnection = (HttpURLConnection)new URL(this.apiLink).openConnection();
                    httpConnection.addRequestProperty("User-Agent", this.userAgentString);
                    if (this.timeout > 0) {
                        httpConnection.setConnectTimeout(this.timeout);
                    }
                    try (InputStreamReader input = new InputStreamReader(httpConnection.getInputStream());
                         BufferedReader reader = new BufferedReader(input);){
                        this.latestVersion = this.mapper.apply(reader);
                    }
                }
                if (!this.isUsingLatestVersion() && !UpdateChecker.isOtherVersionNewer(this.usedVersion, this.latestVersion)) {
                    this.latestVersion = this.usedVersion;
                }
                updateCheckEvent = new UpdateCheckEvent(UpdateCheckSuccess.SUCCESS);
            }
            catch (IOException exception) {
                updateCheckEvent = new UpdateCheckEvent(UpdateCheckSuccess.FAIL);
                Bukkit.getScheduler().runTask(this.plugin, () -> this.getOnFail().accept(requesters, exception));
            }
            UpdateCheckEvent finalUpdateCheckEvent = updateCheckEvent.setRequesters(requesters);
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                if (finalUpdateCheckEvent.getSuccess() == UpdateCheckSuccess.SUCCESS) {
                    this.getOnSuccess().accept(requesters, this.latestVersion);
                }
                Bukkit.getPluginManager().callEvent((Event)finalUpdateCheckEvent);
            });
        });
        return this;
    }

    public boolean isUsingLatestVersion() {
        return this.usedVersion.equals(UpdateChecker.instance.latestVersion);
    }

    public static boolean isOtherVersionNewer(String myVersion, String otherVersion) {
        DefaultArtifactVersion used = new DefaultArtifactVersion(myVersion);
        DefaultArtifactVersion latest = new DefaultArtifactVersion(otherVersion);
        return used.compareTo(latest) < 0;
    }

    public BiConsumer<CommandSender[], Exception> getOnFail() {
        return this.onFail;
    }

    public BiConsumer<CommandSender[], String> getOnSuccess() {
        return this.onSuccess;
    }

    public UpdateChecker checkNow() {
        this.checkNow(new CommandSender[]{Bukkit.getConsoleSender()});
        return this;
    }

    public List<String> getAppropriateDownloadLinks() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.usingPaidVersion) {
            if (this.paidDownloadLink != null) {
                list.add(this.paidDownloadLink);
            } else if (this.freeDownloadLink != null) {
                list.add(this.freeDownloadLink);
            }
        } else {
            if (this.paidDownloadLink != null) {
                list.add(this.paidDownloadLink);
            }
            if (this.freeDownloadLink != null) {
                list.add(this.freeDownloadLink);
            }
        }
        return list;
    }

    public String getChangelogLink() {
        return this.changelogLink;
    }

    public UpdateChecker setChangelogLink(int resourceId) {
        if (this.updateCheckSource == UpdateCheckSource.SPIGOT) {
            return this.setChangelogLink(SPIGOT_DOWNLOAD_LINK + resourceId + SPIGOT_CHANGELOG_SUFFIX);
        }
        if (this.updateCheckSource == UpdateCheckSource.POLYMART) {
            return this.setChangelogLink(POLYMART_DOWNLOAD_LINK + resourceId + POLYMART_CHANGELOG_SUFFIX);
        }
        return this;
    }

    public UpdateChecker setChangelogLink(@Nullable String link) {
        this.changelogLink = link;
        return this;
    }

    @Nullable
    public String getSupportLink() {
        return this.supportLink;
    }

    @NotNull
    public UpdateChecker setSupportLink(@Nullable String link) {
        this.supportLink = link;
        return this;
    }

    public String getDonationLink() {
        return this.donationLink;
    }

    public UpdateChecker setDonationLink(@Nullable String donationLink) {
        this.donationLink = donationLink;
        return this;
    }

    public UpdateCheckResult getLastCheckResult() {
        if (this.latestVersion == null) {
            return UpdateCheckResult.UNKNOWN;
        }
        if (this.latestVersion.equals(this.usedVersion)) {
            return UpdateCheckResult.RUNNING_LATEST_VERSION;
        }
        return UpdateCheckResult.NEW_VERSION_AVAILABLE;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getNameFreeVersion() {
        return this.nameFreeVersion;
    }

    public UpdateChecker setNameFreeVersion(String nameFreeVersion) {
        this.nameFreeVersion = nameFreeVersion;
        return this;
    }

    public String getNamePaidVersion() {
        return this.namePaidVersion;
    }

    public UpdateChecker setNamePaidVersion(String namePaidVersion) {
        this.namePaidVersion = namePaidVersion;
        return this;
    }

    @Nullable
    public String getNotifyPermission() {
        return this.notifyPermission;
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    public String getSpigotUserId() {
        return "%%__USER__%%";
    }

    public String getUsedVersion() {
        return this.usedVersion;
    }

    public UpdateChecker setUsedVersion(String usedVersion) {
        this.usedVersion = usedVersion;
        return this;
    }

    public boolean isCheckedAtLeastOnce() {
        return this.checkedAtLeastOnce;
    }

    public boolean isColoredConsoleOutput() {
        return this.coloredConsoleOutput;
    }

    public UpdateChecker setColoredConsoleOutput(boolean coloredConsoleOutput) {
        this.coloredConsoleOutput = coloredConsoleOutput;
        return this;
    }

    public boolean isNotifyOpsOnJoin() {
        return this.notifyOpsOnJoin;
    }

    public UpdateChecker setNotifyOpsOnJoin(boolean notifyOpsOnJoin) {
        this.notifyOpsOnJoin = notifyOpsOnJoin;
        return this;
    }

    public boolean isNotifyRequesters() {
        return this.notifyRequesters;
    }

    public UpdateChecker setNotifyRequesters(boolean notify) {
        this.notifyRequesters = notify;
        return this;
    }

    public boolean isUsingPaidVersion() {
        return this.usingPaidVersion;
    }

    public UpdateChecker setUsingPaidVersion(boolean paidVersion) {
        this.usingPaidVersion = paidVersion;
        return this;
    }

    public UpdateChecker onFail(BiConsumer<CommandSender[], Exception> onFail) {
        this.onFail = onFail == null ? (requesters, ex) -> ex.printStackTrace() : onFail;
        return this;
    }

    public UpdateChecker onSuccess(BiConsumer<CommandSender[], String> onSuccess) {
        this.onSuccess = onSuccess == null ? (requesters, latestVersion) -> {} : onSuccess;
        return this;
    }

    public UpdateChecker setDownloadLink(int resourceId) {
        if (this.updateCheckSource == UpdateCheckSource.SPIGOT) {
            return this.setDownloadLink(SPIGOT_DOWNLOAD_LINK + resourceId);
        }
        if (this.updateCheckSource == UpdateCheckSource.POLYMART) {
            return this.setDownloadLink(POLYMART_DOWNLOAD_LINK + resourceId);
        }
        return this;
    }

    public UpdateChecker setDownloadLink(@Nullable String downloadLink) {
        this.paidDownloadLink = null;
        this.freeDownloadLink = downloadLink;
        return this;
    }

    public UpdateChecker suppressUpToDateMessage(boolean suppress) {
        this.suppressUpToDateMessage = suppress;
        return this;
    }

    public UpdateChecker setFreeDownloadLink(int resourceId) {
        if (this.updateCheckSource == UpdateCheckSource.SPIGOT) {
            return this.setFreeDownloadLink(SPIGOT_DOWNLOAD_LINK + resourceId);
        }
        if (this.updateCheckSource == UpdateCheckSource.POLYMART) {
            return this.setFreeDownloadLink(POLYMART_DOWNLOAD_LINK + resourceId);
        }
        return this;
    }

    public UpdateChecker setFreeDownloadLink(@Nullable String freeDownloadLink) {
        this.freeDownloadLink = freeDownloadLink;
        return this;
    }

    public UpdateChecker setNotifyByPermissionOnJoin(@Nullable String permission) {
        this.notifyPermission = permission;
        return this;
    }

    public UpdateChecker setPaidDownloadLink(int resourceId) {
        if (this.updateCheckSource == UpdateCheckSource.SPIGOT) {
            return this.setPaidDownloadLink(SPIGOT_DOWNLOAD_LINK + resourceId);
        }
        if (this.updateCheckSource == UpdateCheckSource.POLYMART) {
            return this.setPaidDownloadLink(POLYMART_DOWNLOAD_LINK + resourceId);
        }
        return this;
    }

    public UpdateChecker setPaidDownloadLink(@NotNull String link) {
        this.paidDownloadLink = link;
        return this;
    }

    public UpdateChecker setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public UpdateChecker setUserAgent(@NotNull UserAgentBuilder userAgentBuilder) {
        this.userAgentString = userAgentBuilder.build();
        return this;
    }

    public UpdateChecker setUserAgent(@Nullable String userAgent) {
        this.userAgentString = userAgent;
        return this;
    }

    static {
        UpdateChecker.checkRelocation();
    }
}

