/*
 * Decompiled with CFR 0.152.
 */
package me.aglerr.donations.commands;

import com.muhammaddaffa.mdlib.commandapi.CommandAPICommand;
import com.muhammaddaffa.mdlib.commandapi.arguments.Argument;
import com.muhammaddaffa.mdlib.commandapi.arguments.ArgumentSuggestions;
import com.muhammaddaffa.mdlib.commandapi.arguments.OfflinePlayerArgument;
import com.muhammaddaffa.mdlib.commandapi.arguments.StringArgument;
import com.muhammaddaffa.mdlib.commandapi.executors.ExecutorType;
import com.muhammaddaffa.mdlib.utils.Placeholder;
import me.aglerr.donations.DonationPlugin;
import me.aglerr.donations.managers.ProductManager;
import me.aglerr.donations.managers.QueueManager;
import me.aglerr.donations.objects.Product;
import org.bukkit.OfflinePlayer;

public class MainCommand {
    private CommandAPICommand command = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("donations").withPermission("donations.admin")).executes((sender, args) -> {
        if (sender.hasPermission("donations.admin")) {
            DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.help");
        } else {
            DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.noPermission");
        }
    }, new ExecutorType[0]);

    public MainCommand() {
        this.getSubCommandSend();
        this.getSubCommandReload();
        this.getSubCommandReset();
        this.command.register(DonationPlugin.getInstance());
    }

    private void getSubCommandSend() {
        this.command.withSubcommand((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("send").withArguments(new Argument[]{new OfflinePlayerArgument("target")})).withArguments(new Argument[]{(Argument)new StringArgument("product").replaceSuggestions(ArgumentSuggestions.strings(info -> (String[])DonationPlugin.getInstance().getProductManager().getListOfProductName().toArray(String[]::new)))})).withPermission("donations.admin")).executes((sender, args) -> {
            if (!sender.hasPermission("donations.admin")) {
                DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.noPermission");
                return;
            }
            ProductManager productManager = DonationPlugin.getInstance().getProductManager();
            OfflinePlayer target = (OfflinePlayer)args.get("target");
            String string = (String)args.get("product");
            Product product = productManager.getProduct(string);
            if (product == null) {
                DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.invalidProduct");
                return;
            }
            QueueManager queueManager = DonationPlugin.getInstance().getQueueManager();
            queueManager.addQueue(target, product);
            DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.performDonation", new Placeholder().add("{player}", target.getName()));
        }, new ExecutorType[0]));
    }

    private void getSubCommandReload() {
        this.command.withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("reload").withPermission("donations.admin")).executes((sender, args) -> {
            if (!sender.hasPermission("donations.admin")) {
                DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.noPermission");
                return;
            }
            DonationPlugin.getInstance().reloadEverything();
            DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.reload");
        }, new ExecutorType[0]));
    }

    private void getSubCommandReset() {
        this.command.withSubcommand((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("reset").withPermission("donations.admin")).executes((sender, args) -> {
            if (!sender.hasPermission("donations.admin")) {
                DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.noPermission");
                return;
            }
            DonationPlugin.getInstance().resetDonation();
            DonationPlugin.DEFAULT_CONFIG.sendMessage(sender, "messages.reset");
        }, new ExecutorType[0]));
    }
}

