/*
 * Decompiled with CFR 0.152.
 */
package me.aglerr.donations.managers;

import com.muhammaddaffa.mdlib.utils.Executor;
import java.util.ArrayList;
import java.util.List;
import me.aglerr.donations.api.events.DonationPerformEvent;
import me.aglerr.donations.objects.Product;
import me.aglerr.donations.objects.QueueDonation;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QueueManager {
    private boolean IS_QUEUEING = false;
    private final List<QueueDonation> queueDonations = new ArrayList<QueueDonation>();

    public QueueManager() {
        this.startAnnounceTask();
    }

    public void addQueue(OfflinePlayer player, @NotNull Product product) {
        this.queueDonations.add(new QueueDonation(player, product));
    }

    public void addQueue(QueueDonation donation) {
        this.queueDonations.add(donation);
    }

    public boolean removeDonationFromQueue(QueueDonation donation) {
        return this.queueDonations.remove(donation);
    }

    protected void startAnnounceTask() {
        Executor.asyncTimer(0L, 20L, () -> {
            if (this.IS_QUEUEING) {
                return;
            }
            if (this.queueDonations.isEmpty()) {
                return;
            }
            QueueDonation donation = this.queueDonations.get(0);
            DonationPerformEvent event = new DonationPerformEvent(donation);
            Executor.sync(() -> Bukkit.getPluginManager().callEvent((Event)event));
            if (event.isCancelled()) {
                return;
            }
            this.IS_QUEUEING = true;
            donation.announceDonation();
            this.queueDonations.remove(donation);
            this.IS_QUEUEING = false;
        });
    }
}

