/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib;

import com.muhammaddaffa.mdlib.commandapi.CommandAPI;
import com.muhammaddaffa.mdlib.commandapi.CommandAPIBukkitConfig;
import com.muhammaddaffa.mdlib.customblockdata.CustomBlockData;
import com.muhammaddaffa.mdlib.fastinv.FastInvManager;
import com.muhammaddaffa.mdlib.hooks.VaultEconomy;
import com.muhammaddaffa.mdlib.worldguards.listeners.RegionListener;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class MDLib {
    private static JavaPlugin instance;
    public static boolean VERBOSE_OUTPUT;
    public static boolean SILENT_LOGS;
    public static boolean LISTEN_WORLDGUARD;
    public static boolean CUSTOM_BLOCK_DATA;
    public static boolean COMMANDAPI;
    private static boolean PLACEHOLDER_API;
    private static boolean VAULT;
    private static boolean WORLD_GUARD;

    public static void inject(JavaPlugin plugin) {
        if (COMMANDAPI) {
            CommandAPI.onLoad(((CommandAPIBukkitConfig)new CommandAPIBukkitConfig(plugin).verboseOutput(VERBOSE_OUTPUT)).silentLogs(SILENT_LOGS));
        }
    }

    public static void onEnable(JavaPlugin plugin) {
        if (COMMANDAPI) {
            CommandAPI.onEnable();
        }
        instance = plugin;
        PLACEHOLDER_API = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        VAULT = Bukkit.getPluginManager().getPlugin("Vault") != null;
        WORLD_GUARD = Bukkit.getPluginManager().getPlugin("WorldGuard") != null;
        MDLib.registerListeners();
    }

    public static void shutdown() {
        if (COMMANDAPI) {
            CommandAPI.onDisable();
        }
    }

    private static void registerListeners() {
        PluginManager pm = Bukkit.getPluginManager();
        if (MDLib.usingWorldGuard() && LISTEN_WORLDGUARD) {
            pm.registerEvents((Listener)new RegionListener(), (Plugin)instance);
        }
        if (MDLib.usingVault()) {
            VaultEconomy.init();
        }
        if (CUSTOM_BLOCK_DATA) {
            CustomBlockData.registerListener((Plugin)instance);
        }
        FastInvManager.register((Plugin)instance);
    }

    private static boolean usingWorldGuard() {
        return WORLD_GUARD;
    }

    private static boolean usingPlaceholderAPI() {
        return PLACEHOLDER_API;
    }

    private static boolean usingVault() {
        return VAULT;
    }

    public static void registerWorldGuard() {
        LISTEN_WORLDGUARD = true;
    }

    public static void registerCustomBlockData() {
        CUSTOM_BLOCK_DATA = true;
    }

    public static JavaPlugin instance() {
        return instance;
    }

    static {
        VERBOSE_OUTPUT = false;
        SILENT_LOGS = true;
        LISTEN_WORLDGUARD = false;
        CUSTOM_BLOCK_DATA = false;
        COMMANDAPI = true;
    }
}

