/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.muhammaddaffa.mdlib.commandapi.CommandAPIBukkit;
import com.muhammaddaffa.mdlib.commandapi.CommandAPIHandler;
import com.muhammaddaffa.mdlib.commandapi.arguments.Argument;
import com.muhammaddaffa.mdlib.commandapi.arguments.CommandAPIArgumentType;
import com.muhammaddaffa.mdlib.commandapi.arguments.GreedyArgument;
import com.muhammaddaffa.mdlib.commandapi.arguments.PreviewInfo;
import com.muhammaddaffa.mdlib.commandapi.arguments.Previewable;
import com.muhammaddaffa.mdlib.commandapi.commandsenders.BukkitPlayer;
import com.muhammaddaffa.mdlib.commandapi.exceptions.PaperAdventureNotFoundException;
import com.muhammaddaffa.mdlib.commandapi.exceptions.WrapperCommandSyntaxException;
import com.muhammaddaffa.mdlib.commandapi.executors.CommandArguments;
import com.muhammaddaffa.mdlib.commandapi.wrappers.PreviewableFunction;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdventureChatArgument
extends Argument<Component>
implements GreedyArgument,
Previewable<AdventureChatArgument, Component> {
    private PreviewableFunction<Component> preview;
    private boolean usePreview;

    public AdventureChatArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentChat());
        try {
            Class.forName("net.kyori.adventure.text.Component");
        }
        catch (ClassNotFoundException e) {
            throw new PaperAdventureNotFoundException(this.getClass());
        }
    }

    @Override
    public Class<Component> getPrimitiveType() {
        return Component.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ADVENTURE_CHAT;
    }

    @Override
    public <CommandSourceStack> Component parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource();
        Component component = CommandAPIBukkit.get().getAdventureChat(cmdCtx, key);
        Optional<PreviewableFunction<Component>> previewOptional = this.getPreview();
        if (this.usePreview && previewOptional.isPresent() && sender instanceof Player) {
            Player player = (Player)sender;
            try {
                Component previewComponent;
                component = previewComponent = previewOptional.get().generatePreview(new PreviewInfo<Component>(new BukkitPlayer(player), CommandAPIHandler.getRawArgumentInput(cmdCtx, key), cmdCtx.getInput(), component));
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
        }
        return component;
    }

    @Override
    public AdventureChatArgument withPreview(PreviewableFunction<Component> preview) {
        this.preview = preview;
        return this;
    }

    @Override
    public Optional<PreviewableFunction<Component>> getPreview() {
        return Optional.ofNullable(this.preview);
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    public AdventureChatArgument usePreview(boolean usePreview) {
        this.usePreview = usePreview;
        return this;
    }
}

