/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.muhammaddaffa.mdlib.commandapi.CommandAPIBukkit;
import com.muhammaddaffa.mdlib.commandapi.arguments.CommandAPIArgumentType;
import com.muhammaddaffa.mdlib.commandapi.arguments.LocationType;
import com.muhammaddaffa.mdlib.commandapi.arguments.SafeOverrideableArgument;
import com.muhammaddaffa.mdlib.commandapi.executors.CommandArguments;
import com.muhammaddaffa.mdlib.commandapi.wrappers.Location2D;

public class Location2DArgument
extends SafeOverrideableArgument<Location2D, Location2D> {
    private final boolean isPrecise;

    public Location2DArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public Location2DArgument(String nodeName, LocationType type) {
        this(nodeName, type, true);
    }

    public Location2DArgument(String nodeName, LocationType type, boolean centerPosition) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get()._ArgumentPosition2D() : CommandAPIBukkit.get()._ArgumentVec2(centerPosition), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location2D> getPrimitiveType() {
        return Location2D.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION_2D;
    }

    @Override
    public <CommandSourceStack> Location2D parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getLocation2DPrecise(cmdCtx, key) : CommandAPIBukkit.get().getLocation2DBlock(cmdCtx, key);
    }
}

