/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.fastinv;

import com.muhammaddaffa.mdlib.fastinv.FastInv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PaginatedFastInv
extends FastInv {
    private final List<ItemStack> contentItems = new ArrayList<ItemStack>();
    private final List<Consumer<InventoryClickEvent>> contentHandlers = new ArrayList<Consumer<InventoryClickEvent>>();
    private List<Integer> contentSlots = IntStream.range(0, Math.max(9, this.getInventory().getSize() - 9)).boxed().collect(Collectors.toList());
    private int page = 1;
    private IntFunction<ItemStack> previousPageItem;
    private IntFunction<ItemStack> nextPageItem;
    private int previousPageSlot = -1;
    private int nextPageSlot = -1;

    public PaginatedFastInv(int size) {
        this((PaginatedFastInv owner) -> Bukkit.createInventory((InventoryHolder)owner, (int)size));
    }

    public PaginatedFastInv(int size, String title) {
        this((PaginatedFastInv owner) -> Bukkit.createInventory((InventoryHolder)owner, (int)size, (String)title));
    }

    public PaginatedFastInv(InventoryType type) {
        this((PaginatedFastInv owner) -> Bukkit.createInventory((InventoryHolder)owner, (InventoryType)type));
    }

    public PaginatedFastInv(InventoryType type, String title) {
        this((PaginatedFastInv owner) -> Bukkit.createInventory((InventoryHolder)owner, (InventoryType)type, (String)title));
    }

    public PaginatedFastInv(Function<PaginatedFastInv, Inventory> inventoryFunction) {
        super((FastInv inv) -> (Inventory)inventoryFunction.apply((PaginatedFastInv)inv));
    }

    public void addContent(ItemStack item) {
        this.addContent(item, null);
    }

    public void addContent(ItemStack item, Consumer<InventoryClickEvent> handler) {
        this.contentItems.add(item);
        this.contentHandlers.add(handler);
    }

    public void addContent(Collection<ItemStack> content) {
        this.addContent(content, Collections.nCopies(content.size(), null));
    }

    public void addContent(Collection<ItemStack> content, Collection<Consumer<InventoryClickEvent>> handlers) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(handlers, "handlers");
        if (content.size() != handlers.size()) {
            throw new IllegalArgumentException("The content and handlers lists must have the same size");
        }
        this.contentItems.addAll(content);
        this.contentHandlers.addAll(handlers);
    }

    public void setContent(int index, ItemStack item) {
        this.setContent(index, item, null);
    }

    public void setContent(int index, ItemStack item, Consumer<InventoryClickEvent> handler) {
        this.contentItems.set(index, item);
        this.contentHandlers.set(index, handler);
    }

    public void setContent(List<ItemStack> content) {
        this.clearContent();
        this.addContent(content);
    }

    public void setContent(Collection<ItemStack> content, Collection<Consumer<InventoryClickEvent>> handlers) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(handlers, "handlers");
        if (content.size() != handlers.size()) {
            throw new IllegalArgumentException("The content and handlers lists must have the same size");
        }
        this.clearContent();
        this.addContent(content, handlers);
    }

    public void clearContent() {
        this.contentItems.clear();
        this.contentHandlers.clear();
    }

    public void openPrevious() {
        this.openPage(this.page - 1);
    }

    public void openNext() {
        this.openPage(this.page + 1);
    }

    public void openPage(int page) {
        int lastPage = this.lastPage();
        this.page = Math.max(1, Math.min(page, lastPage));
        int index = this.contentSlots.size() * (this.page - 1);
        for (int slot : this.contentSlots) {
            if (index >= this.contentItems.size()) {
                this.removeItem(slot);
                continue;
            }
            this.setItem(slot, this.contentItems.get(index), this.contentHandlers.get(index++));
        }
        if (this.page > 1 && this.previousPageItem != null) {
            this.setItem(this.previousPageSlot, this.previousPageItem.apply(this.page - 1), e -> this.openPrevious());
        } else if (this.previousPageSlot >= 0) {
            this.removeItem(this.previousPageSlot);
        }
        if (this.page < lastPage && this.nextPageItem != null) {
            this.setItem(this.nextPageSlot, this.nextPageItem.apply(this.page + 1), e -> this.openNext());
        } else if (this.nextPageSlot >= 0) {
            this.removeItem(this.nextPageSlot);
        }
        this.onPageChange(page);
    }

    public void setContentSlots(List<Integer> contentSlots) {
        this.contentSlots = Objects.requireNonNull(contentSlots, "contentSlots");
    }

    public void previousPageItem(int slot, IntFunction<ItemStack> item) {
        if (slot < 0 || slot >= this.getInventory().getSize()) {
            throw new IllegalArgumentException("Invalid slot: " + slot);
        }
        this.previousPageSlot = slot;
        this.previousPageItem = item;
    }

    public void previousPageItem(int slot, ItemStack item) {
        this.previousPageItem(slot, (int page) -> item);
    }

    public void nextPageItem(int slot, IntFunction<ItemStack> item) {
        if (slot < 0 || slot >= this.getInventory().getSize()) {
            throw new IllegalArgumentException("Invalid slot: " + slot);
        }
        this.nextPageSlot = slot;
        this.nextPageItem = item;
    }

    public void nextPageItem(int slot, ItemStack item) {
        this.nextPageItem(slot, (int page) -> item);
    }

    @Override
    public void open(Player player) {
        this.openPage(this.page);
        super.open(player);
    }

    protected void onPageChange(int page) {
    }

    public int currentPage() {
        return this.page;
    }

    public int lastPage() {
        int last = this.contentItems.size() / this.contentSlots.size();
        int remaining = this.contentItems.size() % this.contentSlots.size();
        return remaining == 0 ? last : last + 1;
    }

    public boolean isFirstPage() {
        return this.page == 1;
    }

    public boolean isLastPage() {
        return this.page == this.lastPage();
    }
}

