/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.utils;

import com.muhammaddaffa.mdlib.utils.Placeholder;
import com.muhammaddaffa.mdlib.xseries.XSound;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Common {
    private static final Pattern HEX_PATTERN = Pattern.compile("(?:&#|#)([A-Fa-f0-9]{6})");
    private static final DecimalFormat decimalFormat = new DecimalFormat("###,###,###,###,###.##");

    public static double getRandomNumberBetween(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(max - min) + min;
    }

    public static int getRandomNumberBetween(int min, int max) {
        return ThreadLocalRandom.current().nextInt(max - min) + min;
    }

    public static boolean isValid(List<?> list, int index) {
        try {
            list.get(index);
            return true;
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    public static void playSound(Player player, Sound sound) {
        Common.playSound(player, XSound.of(sound));
    }

    public static void playSound(Player player, String sound) {
        Optional<XSound> optional = XSound.of(sound);
        optional.ifPresent(xSound -> Common.playSound(player, xSound));
    }

    public static void playSound(Player player, XSound sound) {
        sound.play((Entity)player, 1.0f, 1.0f);
    }

    public static void broadcast(String message) {
        Common.broadcast(message, null);
    }

    public static void broadcast(String message, @Nullable Placeholder placeholder) {
        if (placeholder != null) {
            message = placeholder.translate(message);
        }
        Bukkit.broadcastMessage((String)Common.color(message));
    }

    public static void actionBar(Player player, String message) {
        Common.actionBar(player, message, null);
    }

    public static void actionBar(Player player, String message, @Nullable Placeholder placeholder) {
        if (placeholder != null) {
            message = placeholder.translate(message);
        }
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Common.color(message)));
    }

    public static void sendTitle(Player player, String title, String subTitle) {
        Common.sendTitle(player, title, subTitle, null);
    }

    public static void sendTitle(Player player, String title, String subTitle, @Nullable Placeholder placeholder) {
        Common.sendTitle(player, title, subTitle, 20, 40, 20, placeholder);
    }

    public static void sendTitle(Player player, String title, String subTitle, int fadeIn, int stay, int fadeOut) {
        Common.sendTitle(player, title, subTitle, fadeIn, stay, fadeOut, null);
    }

    public static void sendTitle(Player player, String title, String subTitle, int fadeIn, int stay, int fadeOut, @Nullable Placeholder placeholder) {
        if (placeholder != null) {
            title = placeholder.translate(title);
            subTitle = placeholder.translate(subTitle);
        }
        player.sendTitle(Common.color(title), Common.color(subTitle), fadeIn, stay, fadeOut);
    }

    public static String digits(Object o) {
        return decimalFormat.format(o);
    }

    public static String format(FileConfiguration config, double number) {
        if (number >= 1.0E24) {
            return decimalFormat.format(number / 1.0E24) + config.getString("currency-notation.septillion", "Sp");
        }
        if (number >= 1.0E21) {
            return decimalFormat.format(number / 1.0E21) + config.getString("currency-notation.sextillion", "Sx");
        }
        if (number >= 1.0E18) {
            return decimalFormat.format(number / 1.0E18) + config.getString("currency-notation.quintillion", "Qi");
        }
        if (number >= 1.0E15) {
            return decimalFormat.format(number / 1.0E15) + config.getString("currency-notation.quadrillion", "Qa");
        }
        if (number >= 1.0E12) {
            return decimalFormat.format(number / 1.0E12) + config.getString("currency-notation.trillion", "T");
        }
        if (number >= 1.0E9) {
            return decimalFormat.format(number / 1.0E9) + config.getString("currency-notation.billion", "B");
        }
        if (number >= 1000000.0) {
            return decimalFormat.format(number / 1000000.0) + config.getString("currency-notation.million", "M");
        }
        if (number >= 1000.0) {
            return decimalFormat.format(number / 1000.0) + config.getString("currency-notation.thousand", "K");
        }
        return decimalFormat.format(number);
    }

    public static String format(double number) {
        if (number >= 1.0E24) {
            return decimalFormat.format(number / 1.0E24) + "Sp";
        }
        if (number >= 1.0E21) {
            return decimalFormat.format(number / 1.0E21) + "Sx";
        }
        if (number >= 1.0E18) {
            return decimalFormat.format(number / 1.0E18) + "Qi";
        }
        if (number >= 1.0E15) {
            return decimalFormat.format(number / 1.0E15) + "Qa";
        }
        if (number >= 1.0E12) {
            return decimalFormat.format(number / 1.0E12) + "T";
        }
        if (number >= 1.0E9) {
            return decimalFormat.format(number / 1.0E9) + "B";
        }
        if (number >= 1000000.0) {
            return decimalFormat.format(number / 1000000.0) + "M";
        }
        if (number >= 1000.0) {
            return decimalFormat.format(number / 1000.0) + "K";
        }
        return decimalFormat.format(number);
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static void addInventoryItem(Player player, ItemStack stack) {
        int stackAmount;
        Material material = stack.getType();
        int maxStackSize = material.getMaxStackSize();
        ItemStack originalStack = stack.clone();
        HashMap leftovers = new HashMap();
        for (int amount = stack.getAmount(); amount > 0; amount -= stackAmount) {
            stackAmount = Math.min(amount, maxStackSize);
            originalStack.setAmount(stackAmount);
            HashMap left = player.getInventory().addItem(new ItemStack[]{originalStack});
            if (left.isEmpty()) continue;
            leftovers.putAll(left);
        }
        leftovers.values().forEach(item -> player.getWorld().dropItemNaturally(player.getLocation(), item));
    }

    public static void addInventoryItem(Player player, List<ItemStack> items) {
        for (ItemStack stack : items) {
            Common.addInventoryItem(player, stack);
        }
    }

    public static void sendMessage(CommandSender sender, List<String> messages) {
        Common.sendMessage(sender, messages, null);
    }

    public static void sendMessage(CommandSender sender, List<String> messages, Placeholder placeholder) {
        messages.forEach(message -> Common.sendMessage(sender, message, placeholder));
    }

    public static void sendMessage(CommandSender sender, String message) {
        Common.sendMessage(sender, message, null);
    }

    public static void sendMessage(CommandSender sender, String message, Placeholder placeholder) {
        Player player;
        if (message == null || message.isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            player = (Player)sender;
            message = Common.papi(player, message);
        }
        if (placeholder != null) {
            message = placeholder.translate(message);
        }
        if (sender instanceof Player) {
            player = (Player)sender;
            if (message.startsWith("actionbar;")) {
                Common.actionBar(player, Common.color(message.replace("actionbar;", "")));
            } else {
                sender.sendMessage(Common.color(message));
            }
        } else {
            sender.sendMessage(Common.color(message.replace("actionbar;", "")));
        }
    }

    public static List<String> color(List<String> messages) {
        return messages.stream().map(Common::color).collect(Collectors.toList());
    }

    public static String color(String message) {
        int colorChar = 167;
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        String legacyFormatted = matcher.appendTail(buffer).toString();
        return ChatColor.translateAlternateColorCodes((char)'&', (String)legacyFormatted);
    }

    public static String papi(Player player, String message) {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            return message;
        }
        return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
    }
}

