/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.utils;

import com.muhammaddaffa.mdlib.utils.Common;
import com.muhammaddaffa.mdlib.utils.Config;
import com.muhammaddaffa.mdlib.utils.Placeholder;
import com.muhammaddaffa.mdlib.xseries.profiles.builder.XSkull;
import com.muhammaddaffa.mdlib.xseries.profiles.objects.ProfileInputType;
import com.muhammaddaffa.mdlib.xseries.profiles.objects.Profileable;
import com.nexomc.nexo.api.NexoItems;
import dev.lone.itemsadder.api.CustomStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder {
    private final ItemStack item;
    private final ItemMeta meta;

    public ItemBuilder(Material material) {
        this(new ItemStack(material));
    }

    public ItemBuilder(ItemStack item) {
        this.item = Objects.requireNonNull(item, "item");
        this.meta = item.getItemMeta();
        if (this.meta == null) {
            throw new IllegalArgumentException("The type " + String.valueOf(item.getType()) + " doesn't support item meta");
        }
    }

    public ItemMeta getItemMeta() {
        return this.meta;
    }

    public ItemBuilder type(Material material) {
        this.item.setType(material);
        return this;
    }

    public ItemBuilder data(int data) {
        return this.durability((short)data);
    }

    @Deprecated
    public ItemBuilder durability(short durability) {
        this.item.setDurability(durability);
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder enchant(Enchantment enchantment) {
        return this.enchant(enchantment, 1);
    }

    public ItemBuilder enchant(Enchantment enchantment, int level) {
        this.meta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemBuilder removeEnchant(Enchantment enchantment) {
        this.meta.removeEnchant(enchantment);
        return this;
    }

    public ItemBuilder removeEnchants() {
        this.meta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)this.meta).removeEnchant(arg_0));
        return this;
    }

    public ItemBuilder meta(Consumer<ItemMeta> metaConsumer) {
        metaConsumer.accept(this.meta);
        return this;
    }

    public <T extends ItemMeta> ItemBuilder meta(Class<T> metaClass, Consumer<T> metaConsumer) {
        if (metaClass.isInstance(this.meta)) {
            metaConsumer.accept((ItemMeta)metaClass.cast(this.meta));
        }
        return this;
    }

    public ItemBuilder name(String name) {
        this.meta.setDisplayName(Common.color(name));
        return this;
    }

    public ItemBuilder lore(String lore) {
        return this.lore(Collections.singletonList(lore));
    }

    public ItemBuilder lore(String ... lore) {
        return this.lore(Arrays.asList(lore));
    }

    public ItemBuilder lore(List<String> lore) {
        this.meta.setLore(Common.color(lore));
        return this;
    }

    public ItemBuilder addLore(String line) {
        List lore = this.meta.getLore();
        if (lore == null) {
            return this.lore(line);
        }
        lore.add(line);
        return this.lore(lore);
    }

    public ItemBuilder addLore(String ... lines) {
        return this.addLore(Arrays.asList(lines));
    }

    public ItemBuilder addLore(List<String> lines) {
        List lore = this.meta.getLore();
        if (lore == null) {
            return this.lore(lines);
        }
        lore.addAll(lines);
        return this.lore(lore);
    }

    public ItemBuilder flags(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return this;
    }

    public ItemBuilder flags() {
        return this.flags(ItemFlag.values());
    }

    public ItemBuilder removeFlags(ItemFlag ... flags) {
        this.meta.removeItemFlags(flags);
        return this;
    }

    public ItemBuilder removeFlags() {
        return this.removeFlags(ItemFlag.values());
    }

    public ItemBuilder armorColor(Color color) {
        return this.meta(LeatherArmorMeta.class, m -> m.setColor(color));
    }

    public ItemBuilder customModelData(int data) {
        this.meta.setCustomModelData(Integer.valueOf(data));
        return this;
    }

    public ItemBuilder pdc(NamespacedKey key, String s) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)s);
        return this;
    }

    public ItemBuilder pdc(NamespacedKey key, Double d) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.DOUBLE, (Object)d);
        return this;
    }

    public ItemBuilder pdc(NamespacedKey key, Float f) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.FLOAT, (Object)f);
        return this;
    }

    public ItemBuilder pdc(NamespacedKey key, Integer i) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)i);
        return this;
    }

    public ItemBuilder pdc(NamespacedKey key, Long l) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.LONG, (Object)l);
        return this;
    }

    public ItemBuilder pdc(NamespacedKey key, Byte b) {
        this.meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)b);
        return this;
    }

    public ItemBuilder skull(String identifier) {
        ProfileInputType input = ProfileInputType.typeOf(identifier);
        if (input != null) {
            XSkull.of(this.meta).profile(Profileable.of(input, identifier)).apply();
        }
        return this;
    }

    public ItemBuilder skull(OfflinePlayer identifier) {
        XSkull.of(this.meta).profile(Profileable.of(identifier)).apply();
        return this;
    }

    public ItemBuilder skull(UUID identifier) {
        XSkull.of(this.meta).profile(Profileable.of(identifier)).apply();
        return this;
    }

    public ItemBuilder placeholder(Placeholder placeholder) {
        this.name(placeholder.translate(this.meta.getDisplayName()));
        if (this.meta.getLore() != null) {
            this.lore(placeholder.translate(this.meta.getLore()));
        }
        return this;
    }

    public ItemBuilder attribute(Material material, EquipmentSlot slot) {
        this.meta.setAttributeModifiers(material.getDefaultAttributeModifiers(slot));
        return this;
    }

    public ItemBuilder loreCustom(String key, String replacer) {
        return this.loreCustom(key, replacer, null);
    }

    public ItemBuilder loreCustom(String key, String replacer, @Nullable Placeholder placeholder) {
        return this.loreCustom(key, List.of(replacer), placeholder);
    }

    public ItemBuilder loreCustom(String key, List<String> replacer) {
        return this.loreCustom(key, replacer, null);
    }

    public ItemBuilder loreCustom(String key, List<String> replacer, @Nullable Placeholder placeholder) {
        ArrayList<String> lore = new ArrayList<String>();
        if (placeholder != null) {
            replacer = placeholder.translate(replacer);
        }
        if (this.meta != null && this.meta.getLore() != null) {
            for (String line : this.meta.getLore()) {
                if (line.contains(key)) {
                    lore.addAll(replacer);
                    continue;
                }
                lore.add(line);
            }
        }
        this.lore(lore);
        return this;
    }

    @Nullable
    public static ItemBuilder fromConfig(Config config, String path) {
        return ItemBuilder.fromConfig(config, path, null);
    }

    @Nullable
    public static ItemBuilder fromConfig(Config config, String path, @Nullable Placeholder placeholder) {
        return ItemBuilder.fromConfig(config.getConfig(), path, placeholder);
    }

    @Nullable
    public static ItemBuilder fromConfig(FileConfiguration config, String path) {
        return ItemBuilder.fromConfig(config, path, null);
    }

    @Nullable
    public static ItemBuilder fromConfig(FileConfiguration config, String path, @Nullable Placeholder placeholder) {
        ConfigurationSection section = config.getConfigurationSection(path);
        if (section == null) {
            return null;
        }
        return ItemBuilder.fromConfig(section, placeholder);
    }

    @Nullable
    public static ItemBuilder fromConfig(ConfigurationSection section) {
        return ItemBuilder.fromConfig(section, null);
    }

    @Nullable
    public static ItemBuilder fromConfig(ConfigurationSection section, @Nullable Placeholder placeholder) {
        if (section == null) {
            return null;
        }
        String materialString = section.getString("material", "BARRIER");
        if (placeholder != null) {
            materialString = placeholder.translate(materialString);
        }
        Integer cmd = section.get("custom-model-data") == null ? null : Integer.valueOf(section.getInt("custom-model-data"));
        int amount = section.getInt("amount");
        String displayName = section.getString("display-name");
        List lore = section.getStringList("lore");
        List flags = section.getStringList("flags");
        List enchantments = section.getStringList("enchantments");
        if (placeholder != null) {
            materialString = placeholder.translate(materialString);
        }
        if (ItemBuilder.isPlaceholderAPI()) {
            materialString = PlaceholderAPI.setPlaceholders(null, (String)materialString);
            if (displayName != null) {
                displayName = PlaceholderAPI.setPlaceholders(null, (String)displayName);
            }
            lore = PlaceholderAPI.setPlaceholders(null, (List)lore);
        }
        ItemBuilder builder = ItemBuilder.retrieveItemBuilder(materialString);
        builder.amount(Math.max(1, amount));
        if (cmd != null && cmd != 0) {
            builder.customModelData(cmd);
        }
        if (displayName != null) {
            builder.name(displayName);
        }
        builder.lore(lore);
        for (String flag : flags) {
            if (!ItemBuilder.isValidItemFlag(flag)) continue;
            builder.flags(ItemFlag.valueOf((String)flag));
        }
        for (String enchantment : enchantments) {
            String[] split = enchantment.split(";");
            Enchantment enchant = Enchantment.getByName((String)split[0]);
            int level = Integer.parseInt(split[1]);
            builder.enchant(enchant, level);
        }
        if (placeholder != null) {
            builder.placeholder(placeholder);
        }
        if (section.get("color") != null) {
            int r = section.getInt("color.r", 255);
            int g = section.getInt("color.g", 255);
            int b = section.getInt("color.b", 255);
            Color color = Color.fromRGB((int)r, (int)g, (int)b);
            builder.meta(PotionMeta.class, meta -> meta.setColor(color));
            builder.meta(LeatherArmorMeta.class, meta -> meta.setColor(color));
        }
        return builder;
    }

    public static ItemBuilder retrieveItemBuilder(String materialString) {
        Material mat;
        String val;
        String[] parts = materialString.split(";", 2);
        String id = parts[0].trim();
        String string = val = parts.length > 1 ? parts[1].trim() : "";
        if (parts.length == 2) {
            switch (id.toLowerCase()) {
                case "head": {
                    return new ItemBuilder(Material.PLAYER_HEAD).skull(val);
                }
                case "nexo": {
                    if (!Bukkit.getPluginManager().isPluginEnabled("Nexo")) break;
                    return NexoItems.optionalItemFromId((String)val).map(nb -> new ItemBuilder(nb.build())).orElseGet(() -> new ItemBuilder(Material.DIRT));
                }
                case "ia": {
                    CustomStack stack;
                    if (!Bukkit.getPluginManager().isPluginEnabled("ItemsAdder") || (stack = CustomStack.getInstance((String)val)) == null) break;
                    return new ItemBuilder(stack.getItemStack());
                }
                case "hdb": {
                    HeadDatabaseAPI api;
                    ItemStack head;
                    if (!Bukkit.getPluginManager().isPluginEnabled("HeadDatabase") || (head = (api = new HeadDatabaseAPI()).getItemHead(val)) == null) break;
                    return new ItemBuilder(head);
                }
            }
        }
        return new ItemBuilder((mat = Material.matchMaterial((String)materialString)) == null ? Material.DIRT : mat);
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    private static boolean isPlaceholderAPI() {
        return Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    private static boolean isValidItemFlag(String flag) {
        try {
            ItemFlag.valueOf((String)flag.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }
}

