/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.worldguards;

import com.muhammaddaffa.mdlib.utils.Executor;
import com.muhammaddaffa.mdlib.worldguards.MovementWay;
import com.muhammaddaffa.mdlib.worldguards.SimpleWorldGuardAPI;
import com.muhammaddaffa.mdlib.worldguards.events.RegionEnterEvent;
import com.muhammaddaffa.mdlib.worldguards.events.RegionEnteredEvent;
import com.muhammaddaffa.mdlib.worldguards.events.RegionLeaveEvent;
import com.muhammaddaffa.mdlib.worldguards.events.RegionLeftEvent;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class WgEntity {
    private final LivingEntity entity;
    private final List<ProtectedRegion> regions = new ArrayList<ProtectedRegion>();
    private static final Map<UUID, WgEntity> playerCache = new HashMap<UUID, WgEntity>();

    public WgEntity(LivingEntity entity) {
        this.entity = entity;
    }

    public boolean updateRegions(MovementWay way, Location to, Location from) {
        Objects.requireNonNull(way, "MovementWay 'way' can not be null.");
        Objects.requireNonNull(to, "Location 'to' can not be null.");
        Objects.requireNonNull(from, "Location 'from' can not be null.");
        ApplicableRegionSet toRegions = SimpleWorldGuardAPI.getRegions(to);
        ApplicableRegionSet fromRegions = SimpleWorldGuardAPI.getRegions(from);
        if (!toRegions.getRegions().isEmpty()) {
            for (Object region : toRegions) {
                if (this.regions.contains(region)) continue;
                RegionEnterEvent enter = new RegionEnterEvent((ProtectedRegion)region, this.entity, way);
                Bukkit.getPluginManager().callEvent((Event)enter);
                if (enter.isCancelled()) {
                    return true;
                }
                this.regions.add((ProtectedRegion)region);
                Executor.syncLater(1L, () -> this.lambda$updateRegions$0((ProtectedRegion)region, way));
            }
            HashSet<ProtectedRegion> toRemove = new HashSet<ProtectedRegion>();
            for (ProtectedRegion oldRegion : fromRegions) {
                if (toRegions.getRegions().contains(oldRegion)) continue;
                RegionLeaveEvent leave = new RegionLeaveEvent(oldRegion, this.entity, way);
                Bukkit.getPluginManager().callEvent((Event)leave);
                if (leave.isCancelled()) {
                    return true;
                }
                Executor.syncLater(1L, () -> Bukkit.getPluginManager().callEvent((Event)new RegionLeftEvent(oldRegion, this.entity, way)));
                toRemove.add(oldRegion);
            }
            this.regions.removeAll(toRemove);
        } else {
            for (ProtectedRegion region : this.regions) {
                RegionLeaveEvent leave = new RegionLeaveEvent(region, this.entity, way);
                Bukkit.getPluginManager().callEvent((Event)leave);
                if (leave.isCancelled()) {
                    return true;
                }
                Executor.syncLater(1L, () -> Bukkit.getPluginManager().callEvent((Event)new RegionLeftEvent(region, this.entity, way)));
            }
            this.regions.clear();
        }
        return false;
    }

    public List<ProtectedRegion> getRegions() {
        return this.regions;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public static Map<UUID, WgEntity> getPlayerCache() {
        return playerCache;
    }

    public static WgEntity get(UUID uuid) {
        return playerCache.get(uuid);
    }

    public static WgEntity get(LivingEntity entity) {
        return playerCache.computeIfAbsent(entity.getUniqueId(), k -> new WgEntity(entity));
    }

    private /* synthetic */ void lambda$updateRegions$0(ProtectedRegion region, MovementWay way) {
        Bukkit.getPluginManager().callEvent((Event)new RegionEnteredEvent(region, this.entity, way));
    }
}

