/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.worldguards.listeners;

import com.muhammaddaffa.mdlib.worldguards.MovementWay;
import com.muhammaddaffa.mdlib.worldguards.WgEntity;
import com.muhammaddaffa.mdlib.worldguards.events.RegionLeaveEvent;
import com.muhammaddaffa.mdlib.worldguards.events.RegionLeftEvent;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class RegionListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLogin(PlayerLoginEvent e) {
        if (e.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        WgEntity.getPlayerCache().remove(e.getPlayer().getUniqueId());
        WgEntity.getPlayerCache().put(e.getPlayer().getUniqueId(), new WgEntity((LivingEntity)e.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent e) {
        WgEntity we = WgEntity.get(e.getPlayer().getUniqueId());
        if (we != null) {
            we.updateRegions(MovementWay.SPAWN, e.getPlayer().getLocation(), e.getPlayer().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityMove(PlayerMoveEvent event) {
        WgEntity we = WgEntity.get((LivingEntity)event.getPlayer());
        if (we != null) {
            event.setCancelled(we.updateRegions(MovementWay.MOVE, event.getTo(), event.getFrom()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityTeleport(PlayerTeleportEvent event) {
        WgEntity we = WgEntity.get((LivingEntity)event.getPlayer());
        if (we != null) {
            event.setCancelled(we.updateRegions(MovementWay.TELEPORT, event.getTo(), event.getFrom()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onKick(PlayerKickEvent e) {
        WgEntity we = WgEntity.get(e.getPlayer().getUniqueId());
        if (we != null) {
            for (ProtectedRegion region : we.getRegions()) {
                RegionLeaveEvent leaveEvent = new RegionLeaveEvent(region, (LivingEntity)e.getPlayer(), MovementWay.DISCONNECT);
                RegionLeftEvent leftEvent = new RegionLeftEvent(region, (LivingEntity)e.getPlayer(), MovementWay.DISCONNECT);
                Bukkit.getPluginManager().callEvent((Event)leaveEvent);
                Bukkit.getPluginManager().callEvent((Event)leftEvent);
            }
            we.getRegions().clear();
            WgEntity.getPlayerCache().remove(e.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent e) {
        WgEntity we = WgEntity.get(e.getPlayer().getUniqueId());
        if (we != null) {
            for (ProtectedRegion region : we.getRegions()) {
                RegionLeaveEvent leaveEvent = new RegionLeaveEvent(region, (LivingEntity)e.getPlayer(), MovementWay.DISCONNECT);
                RegionLeftEvent leftEvent = new RegionLeftEvent(region, (LivingEntity)e.getPlayer(), MovementWay.DISCONNECT);
                Bukkit.getPluginManager().callEvent((Event)leaveEvent);
                Bukkit.getPluginManager().callEvent((Event)leftEvent);
            }
            we.getRegions().clear();
            WgEntity.getPlayerCache().remove(e.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onRespawn(PlayerRespawnEvent e) {
        WgEntity we = WgEntity.get(e.getPlayer().getUniqueId());
        if (we != null) {
            we.updateRegions(MovementWay.SPAWN, e.getRespawnLocation(), e.getPlayer().getLocation());
        }
    }
}

