/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.worldguards.listeners.entity;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.muhammaddaffa.mdlib.worldguards.MovementWay;
import com.muhammaddaffa.mdlib.worldguards.WgEntity;
import com.muhammaddaffa.mdlib.worldguards.events.RegionLeaveEvent;
import com.muhammaddaffa.mdlib.worldguards.events.RegionLeftEvent;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import io.papermc.paper.event.entity.EntityMoveEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;

public class EntityRegionListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityMove(EntityMoveEvent event) {
        WgEntity we = WgEntity.get(event.getEntity());
        if (we != null) {
            event.setCancelled(we.updateRegions(MovementWay.MOVE, event.getTo(), event.getFrom()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        WgEntity we = WgEntity.get(entity2);
        if (we != null) {
            event.setCancelled(we.updateRegions(MovementWay.TELEPORT, event.getTo(), event.getFrom()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        WgEntity we = WgEntity.get(entity2);
        if (we != null) {
            we.updateRegions(MovementWay.SPAWN, entity2.getLocation(), entity2.getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntitySpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        WgEntity we = WgEntity.get(entity);
        if (we != null) {
            we.updateRegions(MovementWay.SPAWN, entity.getLocation(), entity.getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityRemove(EntityRemoveFromWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        WgEntity we = WgEntity.get(entity2.getUniqueId());
        if (we != null) {
            for (ProtectedRegion region : we.getRegions()) {
                RegionLeaveEvent leaveEvent = new RegionLeaveEvent(region, entity2, MovementWay.DISCONNECT);
                RegionLeftEvent leftEvent = new RegionLeftEvent(region, entity2, MovementWay.DISCONNECT);
                Bukkit.getPluginManager().callEvent((Event)leaveEvent);
                Bukkit.getPluginManager().callEvent((Event)leftEvent);
            }
            we.getRegions().clear();
            WgEntity.getPlayerCache().remove(entity2.getUniqueId());
        }
    }
}

