/*
 * Decompiled with CFR 0.152.
 */
package me.aglerr.donations;

import com.muhammaddaffa.mdlib.MDLib;
import com.muhammaddaffa.mdlib.utils.Config;
import me.aglerr.donations.ConfigValue;
import me.aglerr.donations.commands.MainCommand;
import me.aglerr.donations.managers.DependencyManager;
import me.aglerr.donations.managers.DonationBossBar;
import me.aglerr.donations.managers.DonationGoal;
import me.aglerr.donations.managers.ProductManager;
import me.aglerr.donations.managers.QueueManager;
import me.aglerr.donations.metrics.Metrics;
import me.aglerr.donations.utils.Utils;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.SkinsRestorerProvider;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class DonationPlugin
extends JavaPlugin {
    public static Config DEFAULT_CONFIG;
    public static Config PRODUCT_CONFIG;
    public static Config DATA;
    public static boolean HEX_AVAILABLE;
    private final ProductManager productManager = new ProductManager();
    private QueueManager queueManager;
    private static DonationPlugin instance;

    public void onLoad() {
        MDLib.inject(this);
    }

    public void onEnable() {
        instance = this;
        MDLib.onEnable(this);
        Utils.sendStartupLogo();
        this.queueManager = new QueueManager();
        DependencyManager.checkDependencies();
        this.InitializeConfig();
        ConfigValue.initialize();
        this.productManager.loadProduct();
        DonationGoal.onLoad();
        DonationBossBar.runnableBossBar();
        new MainCommand();
        new Metrics(this, 10310);
        HEX_AVAILABLE = Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17") || Bukkit.getVersion().contains("1.18") || Bukkit.getVersion().contains("1.19") || Bukkit.getVersion().contains("1.20") || Bukkit.getVersion().contains("1.21");
    }

    public void onDisable() {
        MDLib.shutdown();
        DonationGoal.onSave();
    }

    private void InitializeConfig() {
        DEFAULT_CONFIG = new Config("config.yml", null, true);
        DEFAULT_CONFIG.setShouldUpdate(true);
        PRODUCT_CONFIG = new Config("product.yml", null, true);
        DATA = new Config("data.yml", null, false);
        Config.updateConfigs();
        Config.reload();
    }

    public void reloadEverything() {
        DEFAULT_CONFIG.reloadConfig();
        PRODUCT_CONFIG.reloadConfig();
        ConfigValue.initialize();
        this.productManager.reloadProduct();
        if (DonationBossBar.getBossBar() != null) {
            DonationBossBar.getBossBar().removeAll();
        }
        DonationBossBar.resetBossBar();
        DonationGoal.reloadDonationGoal();
        DonationBossBar.runnableBossBar();
    }

    public void resetDonation() {
        DonationGoal.reset();
    }

    public static DonationPlugin getInstance() {
        return instance;
    }

    public static SkinsRestorer getSkinsApi() {
        return SkinsRestorerProvider.get();
    }

    public ProductManager getProductManager() {
        return this.productManager;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    static {
        HEX_AVAILABLE = false;
    }
}

