/*
 * Decompiled with CFR 0.152.
 */
package me.aglerr.donations.managers;

import com.muhammaddaffa.mdlib.utils.Common;
import me.aglerr.donations.ConfigValue;
import me.aglerr.donations.DonationPlugin;
import me.aglerr.donations.managers.DonationGoal;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DonationBossBar {
    private static BossBar bossBar;

    public static void runnableBossBar() {
        if (!DonationPlugin.DEFAULT_CONFIG.getBoolean("bossbar.enabled")) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    DonationBossBar.checkAllPlayer(player);
                    DonationBossBar.getBossBar(player);
                    DonationBossBar.updateBossBar();
                }
            }
        }.runTaskTimer((Plugin)DonationPlugin.getInstance(), 0L, 20L);
    }

    private static void getBossBar(Player player) {
        if (bossBar == null) {
            BarColor barColor = DonationBossBar.getBarColor(ConfigValue.PROGRESS_BOSSBAR_COLOR);
            BarStyle barStyle = DonationBossBar.getBarStyle(ConfigValue.PROGRESS_BOSSBAR_STYLE);
            String title = Common.color(ConfigValue.PROGRESS_BOSSBAR_TITLE.replace("{current}", DonationGoal.getCurrentDonation()).replace("{goal}", DonationGoal.getDonationGoal()).replace("{percentage}", DonationGoal.getDonationPercentage() + "%"));
            bossBar = Bukkit.createBossBar((String)title, (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
        }
        bossBar.addPlayer(player);
        DonationBossBar.updateBossBar();
    }

    private static void checkAllPlayer(Player player) {
        if (bossBar == null) {
            return;
        }
        if (!bossBar.getPlayers().contains(player)) {
            bossBar.addPlayer(player);
        }
    }

    private static void updateBossBar() {
        if (bossBar == null) {
            return;
        }
        String title = ConfigValue.PROGRESS_BOSSBAR_TITLE;
        bossBar.setTitle(Common.color(title.replace("{current}", DonationGoal.getCurrentDonation()).replace("{goal}", DonationGoal.getDonationGoal()).replace("{percentage}", DonationGoal.getDonationPercentage() + "%")));
        try {
            double percentage = Double.parseDouble(DonationGoal.getDonationPercentage());
            double progress = Math.max(0.0, Math.min(1.0, percentage / 100.0));
            bossBar.setProgress(progress);
        }
        catch (NumberFormatException e) {
            Bukkit.getLogger().warning("[TheOnly-Donations] Failed to parse donation percentage! Check config formatting.");
            e.printStackTrace();
        }
    }

    private static BarColor getBarColor(String colorName) {
        try {
            return BarColor.valueOf((String)colorName);
        }
        catch (IllegalArgumentException e) {
            return BarColor.YELLOW;
        }
    }

    private static BarStyle getBarStyle(String styleName) {
        try {
            return BarStyle.valueOf((String)styleName);
        }
        catch (IllegalArgumentException e) {
            return BarStyle.SEGMENTED_10;
        }
    }

    public static void resetBossBar() {
        if (bossBar != null) {
            bossBar.removeAll();
            bossBar = null;
        }
    }

    public static BossBar getBossBar() {
        return bossBar;
    }
}

