/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.commandapi.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.muhammaddaffa.mdlib.commandapi.arguments.Argument;
import com.muhammaddaffa.mdlib.commandapi.arguments.CommandAPIArgumentType;
import com.muhammaddaffa.mdlib.commandapi.arguments.GreedyArgument;
import com.muhammaddaffa.mdlib.commandapi.arguments.StringParser;
import com.muhammaddaffa.mdlib.commandapi.exceptions.WrapperCommandSyntaxException;
import com.muhammaddaffa.mdlib.commandapi.executors.CommandArguments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class MapArgument<K, V>
extends Argument<LinkedHashMap>
implements GreedyArgument {
    private final String delimiter;
    private final String separator;
    private final StringParser<K> keyMapper;
    private final StringParser<V> valueMapper;
    private final ResultList keyList;
    private final ResultList valueList;
    private final boolean allowValueDuplicates;
    private final boolean keyListEmpty;
    private final boolean valueListEmpty;

    MapArgument(String nodeName, String delimiter, String separator, StringParser<K> keyMapper, StringParser<V> valueMapper, List<String> keyList, List<String> valueList, boolean allowValueDuplicates) {
        super(nodeName, (ArgumentType<?>)StringArgumentType.greedyString());
        this.delimiter = delimiter;
        this.separator = separator;
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.keyList = ResultList.formatResults(keyList, delimiter);
        this.valueList = ResultList.formatResults(valueList, separator);
        this.allowValueDuplicates = allowValueDuplicates;
        this.keyListEmpty = keyList == null;
        this.valueListEmpty = valueList == null;
        this.applySuggestions();
    }

    private void applySuggestions() {
        super.replaceSuggestions((info, builder) -> {
            StringReader reader = new StringReader(info.currentArg());
            HashSet<String> givenKeys = new HashSet<String>();
            HashSet givenValues = new HashSet();
            ArrayList<String> unusedKeys = new ArrayList<String>(this.keyList.results);
            ArrayList<String> unusedValues = new ArrayList<String>(this.valueList.results);
            boolean isKey = true;
            while (reader.canRead()) {
                String relevantSeparator;
                String result;
                boolean isQuoted = reader.peek() == '\"';
                try {
                    result = isQuoted ? this.readQuoted(reader, isKey) : this.readUnquoted(reader, isKey);
                }
                catch (CommandSyntaxException ignored) {
                    builder = builder.createOffset(builder.getStart() + reader.getCursor() - (isQuoted ? 1 : 0));
                    if (!(!isKey ? this.valueListEmpty : this.keyListEmpty)) {
                        return this.doResultSuggestions(this.readEscapedUntilEnd(reader), builder, isKey ? unusedKeys : unusedValues, isKey, isQuoted);
                    }
                    return this.doEmptySuggestions(reader.getRemaining(), builder, isKey, isQuoted);
                }
                if (!(!isKey ? this.valueListEmpty : this.keyListEmpty)) {
                    ArrayList<String> relaventList;
                    ArrayList<String> arrayList = relaventList = isKey ? unusedKeys : unusedValues;
                    if (!relaventList.contains(result)) {
                        throw this.invalidResult(result, reader, isKey, isQuoted);
                    }
                    if (isKey || !this.allowValueDuplicates) {
                        relaventList.remove(result);
                    }
                } else if (!(!isKey && this.allowValueDuplicates || (isKey ? givenKeys : givenValues).add(result))) {
                    throw this.invalidResult(result, reader, isKey, isQuoted);
                }
                try {
                    if (isKey) {
                        this.keyMapper.parse(result);
                    } else {
                        this.valueMapper.parse(result);
                    }
                }
                catch (Exception e) {
                    throw this.handleParserException(e, result, reader, isKey, isQuoted);
                }
                String string = relevantSeparator = isKey ? this.delimiter : this.separator;
                if (!reader.canRead(relevantSeparator.length())) {
                    builder = builder.createOffset(builder.getStart() + reader.getCursor());
                    builder.suggest(relevantSeparator);
                    return builder.buildFuture();
                }
                int start = reader.getCursor();
                reader.setCursor(start + relevantSeparator.length());
                String typedSeparator = reader.getString().substring(start, reader.getCursor());
                if (!relevantSeparator.equals(typedSeparator)) {
                    reader.setCursor(start);
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)this.separatorRequiredMessage(isKey));
                }
                isKey = !isKey;
            }
            return this.startSuggestions(builder, isKey ? unusedKeys : unusedValues, isKey);
        });
    }

    private CompletableFuture<Suggestions> startSuggestions(SuggestionsBuilder builder, List<String> unusedResults, boolean isKey) {
        builder = builder.createOffset(builder.getStart() + builder.getRemaining().length());
        ResultList relevantList = isKey ? this.keyList : this.valueList;
        for (String result : unusedResults) {
            String quotedSuggestion;
            String unquotedSuggestion = relevantList.preferredUnquoted.get(result);
            if (unquotedSuggestion != null) {
                builder.suggest(unquotedSuggestion);
            }
            if ((quotedSuggestion = relevantList.preferredQuoted.get(result)) == null) continue;
            builder.suggest("\"" + quotedSuggestion + "\"");
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> doResultSuggestions(String ending, SuggestionsBuilder builder, List<String> unusedResults, boolean isKey, boolean isQuoted) {
        String quotedInsert = isQuoted ? "\"" : "";
        String relevantSeparator = isKey ? this.delimiter : this.separator;
        ResultList relevantList = isKey ? this.keyList : this.valueList;
        Map<String, String> suggestionsMap = isQuoted ? relevantList.quoted : relevantList.unquoted;
        for (String result : unusedResults) {
            boolean sameLength;
            boolean bl = sameLength = result.length() == ending.length();
            if (result.startsWith(ending)) {
                builder.suggest(quotedInsert + suggestionsMap.get(result) + quotedInsert + (sameLength ? relevantSeparator : ""));
            }
            if (sameLength || !ending.startsWith(result)) continue;
            builder.suggest(quotedInsert + suggestionsMap.get(result) + quotedInsert + relevantSeparator);
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> doEmptySuggestions(String ending, SuggestionsBuilder builder, boolean isKey, boolean isQuoted) {
        Object suggestion = ending;
        int length = ((String)suggestion).length();
        if (length != 0 && ((String)suggestion).charAt(length - 1) == '\\') {
            boolean escaped = false;
            for (int i = length - 2; i >= 0 && ((String)suggestion).charAt(i) == '\\'; --i) {
                escaped = !escaped;
            }
            if (!escaped) {
                suggestion = (String)suggestion + "\\";
            }
        }
        if (isQuoted) {
            suggestion = "\"" + (String)suggestion + "\"";
        }
        suggestion = (String)suggestion + (isKey ? this.delimiter : this.separator);
        builder.suggest((String)suggestion);
        return builder.buildFuture();
    }

    @Override
    public Class<LinkedHashMap> getPrimitiveType() {
        return LinkedHashMap.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.MAP;
    }

    @Override
    public <Source> LinkedHashMap<K, V> parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        StringReader reader = new StringReader((String)cmdCtx.getArgument(key, String.class));
        LinkedHashMap<Object, V> results = new LinkedHashMap<Object, V>();
        if (reader.getRemainingLength() == 0) {
            return results;
        }
        Object builtKey = null;
        HashSet<String> givenKeys = new HashSet<String>();
        HashSet givenValues = new HashSet();
        ArrayList<String> unusedKeys = new ArrayList<String>(this.keyList.results);
        ArrayList<String> unusedValues = new ArrayList<String>(this.valueList.results);
        boolean isKey = true;
        while (reader.canRead()) {
            String relevantSeparator;
            String result;
            boolean isQuoted = reader.peek() == '\"';
            try {
                result = isQuoted ? this.readQuoted(reader, isKey) : this.readUnquoted(reader, isKey);
            }
            catch (CommandSyntaxException e) {
                if (!isQuoted && !isKey) {
                    result = this.readEscapedUntilEnd(reader);
                }
                if (!isQuoted) {
                    result = this.readEscapedUntilEnd(reader);
                    if (!(!this.keyListEmpty ? unusedKeys.contains(result) : givenKeys.add(result))) {
                        throw this.invalidResult(result, reader, true, false);
                    }
                    throw e;
                }
                throw e;
            }
            if (!(!isKey ? this.valueListEmpty : this.keyListEmpty)) {
                ArrayList<String> relaventList;
                ArrayList<String> arrayList = relaventList = isKey ? unusedKeys : unusedValues;
                if (!relaventList.contains(result)) {
                    throw this.invalidResult(result, reader, isKey, isQuoted);
                }
                if (isKey || !this.allowValueDuplicates) {
                    relaventList.remove(result);
                }
            } else if (!(!isKey && this.allowValueDuplicates || (isKey ? givenKeys : givenValues).add(result))) {
                throw this.invalidResult(result, reader, isKey, isQuoted);
            }
            try {
                if (isKey) {
                    builtKey = this.keyMapper.parse(result);
                } else {
                    V value = this.valueMapper.parse(result);
                    results.put(builtKey, value);
                }
            }
            catch (Exception e) {
                throw this.handleParserException(e, result, reader, isKey, isQuoted);
            }
            String string = relevantSeparator = isKey ? this.delimiter : this.separator;
            if (!reader.canRead(relevantSeparator.length())) {
                if (!reader.canRead()) {
                    if (!isKey) {
                        return results;
                    }
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)this.separatorRequiredMessage(true));
                }
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)this.separatorRequiredMessage(isKey));
            }
            int start = reader.getCursor();
            reader.setCursor(start + relevantSeparator.length());
            String typedSeparator = reader.getString().substring(start, reader.getCursor());
            if (!relevantSeparator.equals(typedSeparator)) {
                reader.setCursor(start);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)this.separatorRequiredMessage(isKey));
            }
            isKey = !isKey;
        }
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)("Expected a " + (isKey ? "key after the separator" : "value after the delimiter")));
    }

    private String readQuoted(StringReader reader, boolean isKey) throws CommandSyntaxException {
        if (reader.read() != '\"') {
            throw new IllegalStateException("readQuoted was called, but the reader did not start with '\"'");
        }
        String result = this.readUntil(reader, "\"", "A quoted " + (isKey ? "key" : "value") + " must end with a quotation mark");
        reader.skip();
        return result;
    }

    private String readUnquoted(StringReader reader, boolean isKey) throws CommandSyntaxException {
        return this.readUntil(reader, isKey ? this.delimiter : this.separator, this.separatorRequiredMessage(isKey));
    }

    private String readUntil(StringReader reader, String terminator, String reachedEndErrorMessage) throws CommandSyntaxException {
        int start = reader.getCursor();
        char firstTerminatorChar = terminator.charAt(0);
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.peek();
            if (escaped) {
                escaped = false;
            } else {
                if (c == '\\') {
                    escaped = true;
                    reader.skip();
                    continue;
                }
                if (c == firstTerminatorChar && MapArgument.doesReaderContinueWithTerminator(reader, terminator)) {
                    return result.toString();
                }
            }
            result.append(c);
            reader.skip();
        }
        reader.setCursor(start);
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)reachedEndErrorMessage);
    }

    private String readEscapedUntilEnd(StringReader reader) {
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.read();
            if (escaped) {
                result.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private CommandSyntaxException invalidResult(String result, StringReader context, boolean isKey, boolean isQuoted) {
        List<String> relaventList = (isKey ? this.keyList : this.valueList).results;
        String message = (!isKey ? this.valueListEmpty : this.keyListEmpty) || relaventList.contains(result) ? "Duplicate " + (isKey ? "keys" : "values") + " are not allowed!" : "Invalid " + (isKey ? "key" : "value") + ": " + result;
        context.setCursor(context.getCursor() - result.length() - (isQuoted ? 2 : 0));
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)context, (Object)message);
    }

    private String separatorRequiredMessage(boolean isKey) {
        return (isKey ? "Delimiter \"" + this.delimiter : "Separator \"" + this.separator) + "\" required after writing a " + (isKey ? "key" : "value");
    }

    private CommandSyntaxException handleParserException(Exception e, String result, StringReader context, boolean isKey, boolean isQuoted) {
        Message message;
        context.setCursor(context.getCursor() - result.length() - (isQuoted ? 2 : 0));
        if (e instanceof WrapperCommandSyntaxException) {
            WrapperCommandSyntaxException wCSE = (WrapperCommandSyntaxException)e;
            message = wCSE.getRawMessage();
        } else {
            message = new LiteralMessage("Invalid " + (isKey ? "key" : "value") + " (" + result + "): cannot be converted to a " + (isKey ? "key" : "value"));
        }
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)context, (Object)message);
    }

    private static boolean doesReaderContinueWithTerminator(StringReader reader, String terminator) {
        if (!reader.canRead(terminator.length())) {
            return false;
        }
        for (int i = 1; i < terminator.length(); ++i) {
            if (reader.peek(i) == terminator.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private record ResultList(List<String> results, Map<String, String> unquoted, Map<String, String> quoted, Map<String, String> preferredUnquoted, Map<String, String> preferredQuoted) {
        public static ResultList EMPTY = new ResultList(List.of(), Map.of(), Map.of(), Map.of(), Map.of());

        private static ResultList formatResults(List<String> results, String terminator) {
            if (results == null) {
                return EMPTY;
            }
            HashMap<String, String> unquoted = new HashMap<String, String>();
            HashMap<String, String> quoted = new HashMap<String, String>();
            HashMap<String, String> preferredUnquoted = new HashMap<String, String>();
            HashMap<String, String> preferredQuoted = new HashMap<String, String>();
            for (String result : results) {
                StringBuilder unquotedResult = new StringBuilder();
                StringBuilder quotedResult = new StringBuilder();
                boolean preferUnquoted = ResultList.unescapeString(result, terminator, unquotedResult, quotedResult);
                unquoted.put(result, unquotedResult.toString());
                quoted.put(result, quotedResult.toString());
                if (preferUnquoted) {
                    preferredUnquoted.put(result, unquotedResult.toString());
                    continue;
                }
                preferredQuoted.put(result, quotedResult.toString());
            }
            return new ResultList(results, unquoted, quoted, preferredUnquoted, preferredQuoted);
        }

        private static boolean unescapeString(String result, String terminator, StringBuilder unquotedResult, StringBuilder quotedResult) {
            char firstTerminatorChar = terminator.charAt(0);
            StringReader reader = new StringReader(result);
            boolean preferUnquoted = true;
            while (reader.canRead()) {
                char c = reader.peek();
                boolean escapeUnquoted = false;
                boolean escapeQuoted = false;
                if (c == '\\') {
                    escapeUnquoted = true;
                    escapeQuoted = true;
                } else if (c == '\"') {
                    escapeQuoted = true;
                    if (reader.getCursor() == 0) {
                        escapeUnquoted = true;
                    }
                } else if (c == firstTerminatorChar && MapArgument.doesReaderContinueWithTerminator(reader, terminator)) {
                    escapeUnquoted = true;
                    preferUnquoted = false;
                }
                if (escapeUnquoted) {
                    unquotedResult.append('\\');
                }
                unquotedResult.append(c);
                if (escapeQuoted) {
                    quotedResult.append('\\');
                }
                quotedResult.append(c);
                reader.skip();
            }
            return preferUnquoted;
        }
    }
}

