/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.fastinv;

import com.muhammaddaffa.mdlib.fastinv.FastInv;
import com.muhammaddaffa.mdlib.fastinv.PaginatedFastInv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class InventoryScheme {
    private final List<String> masks = new ArrayList<String>();
    private final Map<Character, ItemStack> items = new HashMap<Character, ItemStack>();
    private final Map<Character, Consumer<InventoryClickEvent>> handlers = new HashMap<Character, Consumer<InventoryClickEvent>>();
    private char paginationChar;

    public InventoryScheme mask(String mask) {
        Objects.requireNonNull(mask);
        this.masks.add(mask.length() > 9 ? mask.substring(0, 10) : mask);
        return this;
    }

    public InventoryScheme masks(String ... masks) {
        for (String mask : Objects.requireNonNull(masks)) {
            this.mask(mask);
        }
        return this;
    }

    public InventoryScheme bindItem(char character, ItemStack item, Consumer<InventoryClickEvent> handler) {
        this.items.put(Character.valueOf(character), Objects.requireNonNull(item));
        if (handler != null) {
            this.handlers.put(Character.valueOf(character), handler);
        }
        return this;
    }

    public InventoryScheme bindItem(char character, ItemStack item) {
        return this.bindItem(character, item, null);
    }

    public InventoryScheme bindPagination(char character) {
        this.paginationChar = character;
        return this;
    }

    public InventoryScheme unbindItem(char character) {
        this.items.remove(Character.valueOf(character));
        this.handlers.remove(Character.valueOf(character));
        return this;
    }

    public void apply(FastInv inv) {
        ArrayList<Integer> paginationSlots = new ArrayList<Integer>();
        for (int line = 0; line < this.masks.size(); ++line) {
            String mask = this.masks.get(line);
            for (int slot = 0; slot < mask.length(); ++slot) {
                char c = mask.charAt(slot);
                if (c == this.paginationChar) {
                    paginationSlots.add(9 * line + slot);
                    continue;
                }
                ItemStack item = this.items.get(Character.valueOf(c));
                Consumer<InventoryClickEvent> handler = this.handlers.get(Character.valueOf(c));
                if (item == null) continue;
                inv.setItem(9 * line + slot, item, handler);
            }
        }
        if (inv instanceof PaginatedFastInv && !paginationSlots.isEmpty()) {
            ((PaginatedFastInv)inv).setContentSlots(paginationSlots);
        }
    }
}

