/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class TimeUtils {
    private static final long TICK_MS = 50L;
    private static final long SECOND_MS = 1000L;
    private static final long MINUTE_MS = 60000L;
    private static final long HOUR_MS = 3600000L;
    private static final long DAY_MS = 86400000L;
    private static final long YEAR_MS = 31536000000L;
    private static final int DAYS_IN_SECOND = 86400;
    public static String APPEND_DAYS = "d";
    public static String APPEND_HOURS = "h";
    public static String APPEND_MINUTES = "m";
    public static String APPEND_SECONDS = "s";
    public static boolean SPACE_AFTER_APPEND = true;
    private static final Map<String, Long> unitMultipliers = new HashMap<String, Long>();
    private long milliseconds;

    private static void addTimeMultiplier(long multiplier, String ... keys) {
        for (String key : keys) {
            unitMultipliers.put(key, multiplier);
        }
    }

    public TimeUtils(long time, TimeUnit timeUnit) {
        this(TimeUnit.MILLISECONDS.convert(time, timeUnit));
    }

    private TimeUtils(long milliseconds) {
        if (milliseconds < 0L) {
            throw new IllegalArgumentException("Number of milliseconds cannot be less than 0");
        }
        this.milliseconds = milliseconds;
    }

    public long toMilliseconds() {
        return this.milliseconds;
    }

    public double toTicks() {
        return (double)this.milliseconds / 50.0;
    }

    public double toSeconds() {
        return (double)this.milliseconds / 1000.0;
    }

    public double toMinutes() {
        return (double)this.milliseconds / 60000.0;
    }

    public double toHours() {
        return (double)this.milliseconds / 3600000.0;
    }

    public double toDays() {
        return (double)this.milliseconds / 8.64E7;
    }

    public double toYears() {
        return (double)this.milliseconds / 3.1536E10;
    }

    public String toString() {
        StringBuilder timeString = new StringBuilder();
        long time = this.milliseconds;
        time = this.appendTime(time, 31536000000L, "years", timeString);
        time = this.appendTime(time, 86400000L, "days", timeString);
        time = this.appendTime(time, 3600000L, "hours", timeString);
        time = this.appendTime(time, 60000L, "minutes", timeString);
        if ((time = this.appendTime(time, 1000L, "seconds", timeString)) != 0L) {
            timeString.append(", ").append(time).append(" ms");
        }
        if (timeString.isEmpty()) {
            return "0 seconds";
        }
        return timeString.substring(2);
    }

    private long appendTime(long time, long unitInMS, String name, StringBuilder builder) {
        long timeInUnits = (time - time % unitInMS) / unitInMS;
        if (timeInUnits > 0L) {
            builder.append(", ").append(timeInUnits).append(' ').append(name);
        }
        return time - timeInUnits * unitInMS;
    }

    @Nullable
    public static TimeUtils fromString(String timeString) throws TimeParseException {
        if (timeString == null || timeString.isEmpty()) {
            return null;
        }
        long totalMilliseconds = 0L;
        boolean readingNumber = true;
        StringBuilder number = new StringBuilder();
        StringBuilder unit = new StringBuilder();
        for (char c : timeString.toCharArray()) {
            if (c == ' ' || c == ',') {
                readingNumber = false;
                continue;
            }
            if (c == '.' || c >= '0' && c <= '9') {
                if (!readingNumber) {
                    totalMilliseconds = (long)((double)totalMilliseconds + TimeUtils.parseTimeComponent(number.toString(), unit.toString()));
                    number.setLength(0);
                    unit.setLength(0);
                    readingNumber = true;
                }
                number.append(c);
                continue;
            }
            readingNumber = false;
            unit.append(c);
        }
        if (readingNumber) {
            throw new TimeParseException("Number \"" + String.valueOf(number) + "\" not matched with unit at end of string");
        }
        totalMilliseconds = (long)((double)totalMilliseconds + TimeUtils.parseTimeComponent(number.toString(), unit.toString()));
        return new TimeUtils(totalMilliseconds);
    }

    private static double parseTimeComponent(String magnitudeString, String unit) throws TimeParseException {
        Long unitMultiplier;
        long magnitude;
        if (magnitudeString.isEmpty()) {
            throw new TimeParseException("Missing number for unit \"" + unit + "\"");
        }
        try {
            magnitude = Long.valueOf(magnitudeString);
        }
        catch (NumberFormatException e) {
            throw new TimeParseException("Unable to parse number \"" + magnitudeString + "\"", e);
        }
        unit = unit.toLowerCase();
        if (unit.length() > 3 && unit.substring(unit.length() - 3).equals("and")) {
            unit = unit.substring(0, unit.length() - 3);
        }
        if ((unitMultiplier = unitMultipliers.get(unit)) == null) {
            throw new TimeParseException("Unknown time unit \"" + unit + "\"");
        }
        return magnitude * unitMultiplier;
    }

    public static String format(long remaining) {
        int days = TimeUtils.toDays(remaining);
        int hours = TimeUtils.toHours(remaining);
        int minutes = TimeUtils.toMinutes(remaining);
        int seconds = TimeUtils.toSeconds(remaining);
        StringBuilder builder = new StringBuilder();
        if (days != 0) {
            builder.append(days).append(APPEND_DAYS);
            if (hours != 0 && SPACE_AFTER_APPEND) {
                builder.append(" ");
            }
        }
        if (hours != 0) {
            builder.append(hours).append(APPEND_HOURS);
            if (minutes != 0 && SPACE_AFTER_APPEND) {
                builder.append(" ");
            }
        }
        if (minutes != 0) {
            builder.append(minutes).append(APPEND_MINUTES);
            if (seconds != 0 && SPACE_AFTER_APPEND) {
                builder.append(" ");
            }
        }
        if (seconds != 0) {
            builder.append(seconds).append(APPEND_SECONDS);
        }
        return builder.toString();
    }

    private static int toDays(long remaining) {
        return (int)(remaining / 86400L);
    }

    private static int toHours(long remaining) {
        return (int)(remaining % 86400L / 3600L);
    }

    private static int toMinutes(long remaining) {
        return (int)(remaining % 86400L % 3600L / 60L);
    }

    private static int toSeconds(long remaining) {
        return (int)(remaining % 86400L % 3600L % 60L);
    }

    static {
        TimeUtils.addTimeMultiplier(1L, "ms", "milli", "millis", "millisecond", "milliseconds");
        TimeUtils.addTimeMultiplier(50L, "t", "tick", "ticks");
        TimeUtils.addTimeMultiplier(1000L, "s", "sec", "secs", "second", "seconds");
        TimeUtils.addTimeMultiplier(60000L, "m", "min", "mins", "minute", "minutes");
        TimeUtils.addTimeMultiplier(3600000L, "h", "hour", "hours");
        TimeUtils.addTimeMultiplier(86400000L, "d", "day", "days");
        TimeUtils.addTimeMultiplier(31536000000L, "y", "year", "years");
    }

    public static class TimeParseException
    extends RuntimeException {
        public TimeParseException(String reason) {
            super(reason);
        }

        public TimeParseException(String reason, Throwable cause) {
            super(reason, cause);
        }
    }
}

