/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.worldguards;

import com.muhammaddaffa.mdlib.worldguards.WgPlayer;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SimpleWorldGuardAPI {
    public static ProtectedRegion getRegion(String regionId) {
        for (World world : Bukkit.getWorlds()) {
            ProtectedRegion rg = SimpleWorldGuardAPI.getRegion(regionId, world);
            if (rg == null) continue;
            return rg;
        }
        return null;
    }

    public static boolean isInRegion(Location loc, String regionId) {
        for (ProtectedRegion region : SimpleWorldGuardAPI.getRegions(loc)) {
            if (!region.getId().equalsIgnoreCase(regionId)) continue;
            return true;
        }
        return false;
    }

    public static ProtectedRegion getRegion(String regionId, World world) {
        RegionManager regions = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
        if (regions != null) {
            return regions.getRegion(regionId);
        }
        return null;
    }

    public static Map<String, ProtectedRegion> getRegions() {
        HashMap<String, ProtectedRegion> regions = new HashMap<String, ProtectedRegion>();
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        for (World world : Bukkit.getWorlds()) {
            regions.putAll(container.get(BukkitAdapter.adapt((World)world)).getRegions());
        }
        return regions;
    }

    public static Map<String, ProtectedRegion> getRegions(World world) {
        return WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world)).getRegions();
    }

    public static ApplicableRegionSet getRegions(Location loc) {
        return WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)loc));
    }

    public static List<Player> getPlayersInRegion(String regionId) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (WgPlayer wgPlayer : WgPlayer.getPlayerCache().values()) {
            wgPlayer.getRegions().forEach(protectedRegion -> {
                if (regionId.equals(protectedRegion.getId())) {
                    players.add(wgPlayer.getPlayer());
                }
            });
        }
        return players;
    }

    public List<Player> getPlayersInRegion(ProtectedRegion protectedRegion) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (WgPlayer wgPlayer : WgPlayer.getPlayerCache().values()) {
            if (!wgPlayer.getRegions().contains(protectedRegion)) continue;
            players.add(wgPlayer.getPlayer());
        }
        return players;
    }
}

