/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.worldguards.listeners;

import com.muhammaddaffa.mdlib.worldguards.MovementWay;
import com.muhammaddaffa.mdlib.worldguards.SimpleWorldGuardAPI;
import com.muhammaddaffa.mdlib.worldguards.WgPlayer;
import com.muhammaddaffa.mdlib.worldguards.events.RegionLeaveEvent;
import com.muhammaddaffa.mdlib.worldguards.events.RegionLeftEvent;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class RegionListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onLogin(PlayerLoginEvent e) {
        if (e.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        WgPlayer.getPlayerCache().remove(e.getPlayer().getUniqueId());
        WgPlayer.getPlayerCache().put(e.getPlayer().getUniqueId(), new WgPlayer(e.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent e) {
        WgPlayer wp = WgPlayer.get(e.getPlayer().getUniqueId());
        if (wp == null) {
            return;
        }
        wp.updateRegions(MovementWay.SPAWN, e.getPlayer().getLocation(), e.getPlayer().getLocation(), (PlayerEvent)e);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onKick(PlayerKickEvent e) {
        WgPlayer wp = WgPlayer.get(e.getPlayer().getUniqueId());
        if (wp == null) {
            return;
        }
        for (ProtectedRegion region : wp.getRegions()) {
            RegionLeaveEvent leaveEvent = new RegionLeaveEvent(region, e.getPlayer(), MovementWay.DISCONNECT, (PlayerEvent)e);
            RegionLeftEvent leftEvent = new RegionLeftEvent(region, e.getPlayer(), MovementWay.DISCONNECT, (PlayerEvent)e);
            Bukkit.getPluginManager().callEvent((Event)leaveEvent);
            Bukkit.getPluginManager().callEvent((Event)leftEvent);
        }
        SimpleWorldGuardAPI.isInRegion(e.getPlayer().getLocation(), "name");
        wp.getRegions().clear();
        WgPlayer.getPlayerCache().remove(e.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent e) {
        WgPlayer wp = WgPlayer.get(e.getPlayer().getUniqueId());
        if (wp == null) {
            return;
        }
        for (ProtectedRegion region : wp.getRegions()) {
            RegionLeaveEvent leaveEvent = new RegionLeaveEvent(region, e.getPlayer(), MovementWay.DISCONNECT, (PlayerEvent)e);
            RegionLeftEvent leftEvent = new RegionLeftEvent(region, e.getPlayer(), MovementWay.DISCONNECT, (PlayerEvent)e);
            Bukkit.getPluginManager().callEvent((Event)leaveEvent);
            Bukkit.getPluginManager().callEvent((Event)leftEvent);
        }
        wp.getRegions().clear();
        WgPlayer.getPlayerCache().remove(e.getPlayer().getUniqueId());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onMove(PlayerMoveEvent e) {
        WgPlayer wp = WgPlayer.get(e.getPlayer().getUniqueId());
        if (wp == null) {
            return;
        }
        e.setCancelled(wp.updateRegions(MovementWay.MOVE, e.getTo(), e.getFrom(), (PlayerEvent)e));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onMove(PlayerTeleportEvent e) {
        WgPlayer wp = WgPlayer.get(e.getPlayer().getUniqueId());
        if (wp == null) {
            return;
        }
        e.setCancelled(wp.updateRegions(MovementWay.TELEPORT, e.getTo(), e.getFrom(), (PlayerEvent)e));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent e) {
        WgPlayer wp = WgPlayer.get(e.getPlayer().getUniqueId());
        if (wp == null) {
            return;
        }
        wp.updateRegions(MovementWay.SPAWN, e.getRespawnLocation(), e.getPlayer().getLocation(), (PlayerEvent)e);
    }
}

