/*
 * Decompiled with CFR 0.152.
 */
package com.muhammaddaffa.mdlib.xseries.reflection.parser;

import com.muhammaddaffa.mdlib.xseries.reflection.ReflectiveHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.ReflectiveNamespace;
import com.muhammaddaffa.mdlib.xseries.reflection.XReflection;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.ConstructorMemberHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.FieldMemberHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.FlaggedNamedMemberHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.MemberHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.MethodMemberHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.classes.ClassHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.classes.DynamicClassHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.classes.PackageHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.classes.StaticClassHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.jvm.classes.UnknownClassHandle;
import com.muhammaddaffa.mdlib.xseries.reflection.minecraft.MinecraftPackage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ReflectionParser {
    private final String declaration;
    private Pattern pattern;
    private Matcher matcher;
    private ReflectiveNamespace namespace;
    private Map<String, Class<?>> cachedImports;
    private final Set<Flag> flags = EnumSet.noneOf(Flag.class);
    private static final PackageHandle[] PACKAGE_HANDLES = MinecraftPackage.values();
    @Language(value="RegExp")
    private static final String GENERIC = "(?:\\s*<\\s*[.\\w<>\\[\\], ]+\\s*>)?";
    @Language(value="RegExp")
    private static final String ARRAY = "(?:(?:\\[])*)";
    @Language(value="RegExp")
    private static final String PACKAGE_REGEX = "(?:package\\s+(?<package>(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*;\\s*)?";
    @Language(value="RegExp")
    private static final String CLASS_TYPES = "(?<classType>class|interface|enum|record)";
    @Language(value="RegExp")
    private static final String PARAMETERS = "\\s*\\(\\s*(?<parameters>[\\w$_,. ]+)?\\s*\\)";
    @Language(value="RegExp")
    private static final String END_DECL = "\\s*;?\\s*";
    private static final Pattern CLASS = Pattern.compile("(?:package\\s+(?<package>(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*;\\s*)?" + Flag.access$000() + "(?<classType>class|interface|enum|record)" + "\\s+" + ReflectionParser.type("className") + "(?:\\(\\))?(?:\\s+extends\\s+" + ReflectionParser.id("superclasses") + ")?(?:\\s+implements\\s+(?<interfaces>(?:" + ReflectionParser.type(null).array(false) + ")(?:\\s*,\\s*" + ReflectionParser.type(null).array(false) + ")*))?(?:\\s*\\{\\s*})?\\s*");
    private static final Pattern METHOD = Pattern.compile(Flag.access$000() + ReflectionParser.type("methodReturnType") + "\\s+" + ReflectionParser.id("methodName") + "\\s*\\(\\s*(?<parameters>[\\w$_,. ]+)?\\s*\\)" + "\\s*;?\\s*");
    private static final Pattern CONSTRUCTOR = Pattern.compile(Flag.access$000() + "\\s+" + ReflectionParser.id("className") + "\\s*\\(\\s*(?<parameters>[\\w$_,. ]+)?\\s*\\)" + "\\s*;?\\s*");
    private static final Pattern FIELD = Pattern.compile(Flag.access$000() + ReflectionParser.type("fieldType") + "\\s+" + ReflectionParser.id("fieldName") + "\\s*;?\\s*");
    private static final Map<String, Class<?>> PREDEFINED_TYPES = new HashMap();

    public ReflectionParser(@Language(value="Java") String declaration) {
        this.declaration = declaration;
    }

    private static IDHandler id(@NotNull @Language(value="RegExp") String groupName) {
        return new IDHandler(groupName, false);
    }

    private static IDHandler type(@Language(value="RegExp") String groupName) {
        return new IDHandler(groupName, true).generic(true).array(true);
    }

    private ClassHandle[] parseTypes(String[] typeNames) {
        ClassHandle[] classes = new ClassHandle[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            String typeName = typeNames[i];
            typeName = typeName.trim().substring(0, typeName.lastIndexOf(32)).trim();
            classes[i] = this.parseType(typeName);
        }
        return classes;
    }

    private ClassHandle parseType(String typeName) {
        Class clazz;
        if (this.cachedImports == null && this.namespace != null) {
            this.cachedImports = this.namespace.getImports();
        }
        String firstTypeName = typeName;
        typeName = typeName.replace(" ", "");
        int arrayDimension = 0;
        if (typeName.endsWith("[]")) {
            String replaced = typeName.replace("[]", "");
            arrayDimension = (typeName.length() - replaced.length()) / 2;
            typeName = replaced;
        }
        if (typeName.endsWith(">")) {
            typeName = typeName.substring(0, typeName.indexOf(60));
        }
        if ((clazz = this.stringToClass(typeName)) == null) {
            return new UnknownClassHandle(this.getOrCreateNamespace(), firstTypeName + " -> " + typeName);
        }
        if (arrayDimension != 0) {
            clazz = (Class)XReflection.of(clazz).asArray(arrayDimension).unreflect();
        }
        return new StaticClassHandle(this.getOrCreateNamespace(), clazz);
    }

    @Nullable
    private Class<?> stringToClass(String typeName) {
        Class<?> clazz = null;
        if (!typeName.contains(".")) {
            if (this.cachedImports != null) {
                clazz = this.cachedImports.get(typeName);
            }
            if (clazz == null) {
                clazz = PREDEFINED_TYPES.get(typeName);
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private ReflectiveNamespace getOrCreateNamespace() {
        return this.namespace == null ? XReflection.namespaced() : this.namespace;
    }

    public ReflectionParser imports(ReflectiveNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    private void pattern(Pattern pattern, ReflectiveHandle<?> handle) {
        this.pattern = pattern;
        this.matcher = pattern.matcher(this.declaration);
        this.start(handle);
    }

    public <T extends DynamicClassHandle> T parseClass(T classHandle) {
        String className;
        this.pattern(CLASS, classHandle);
        String packageName = this.group("package");
        if (packageName != null && !packageName.isEmpty()) {
            boolean found = false;
            for (PackageHandle pkgHandle : PACKAGE_HANDLES) {
                String targetPackageName = pkgHandle.packageId().toLowerCase(Locale.ENGLISH);
                if (!packageName.startsWith(targetPackageName)) continue;
                if (packageName.indexOf(46) == -1) {
                    classHandle.inPackage(pkgHandle);
                } else {
                    classHandle.inPackage(pkgHandle, packageName.substring(targetPackageName.length() + 1));
                }
                found = true;
                break;
            }
            if (!found) {
                classHandle.inPackage(packageName);
            }
        }
        if ((className = this.group("className")).contains("<")) {
            className = className.substring(0, className.indexOf(60));
        }
        classHandle.named(className);
        return classHandle;
    }

    public <T extends ConstructorMemberHandle> T parseConstructor(T ctorHandle) {
        this.pattern(CONSTRUCTOR, ctorHandle);
        if (this.has("className") && !ctorHandle.getClassHandle().getPossibleNames().contains(this.group("className"))) {
            this.error("Wrong class name associated to constructor, possible names: " + ctorHandle.getClassHandle().getPossibleNames());
        }
        if (this.has("parameters")) {
            ctorHandle.parameters(this.parseTypes(this.group("parameters").split(",")));
        }
        return ctorHandle;
    }

    public <T extends MethodMemberHandle> T parseMethod(T methodHandle) {
        this.pattern(METHOD, methodHandle);
        methodHandle.named(this.group("methodName").split("\\$"));
        methodHandle.returns(this.parseType(this.group("methodReturnType")));
        if (this.has("parameters")) {
            methodHandle.parameters(this.parseTypes(this.group("parameters").split(",")));
        }
        return methodHandle;
    }

    public <T extends FieldMemberHandle> T parseField(T fieldHandle) {
        this.pattern(FIELD, fieldHandle);
        fieldHandle.named(this.group("fieldName").split("\\$"));
        fieldHandle.returns(this.parseType(this.group("fieldType")));
        return fieldHandle;
    }

    private String group(String groupName) {
        return this.matcher.group(groupName);
    }

    private boolean has(String groupName) {
        String group = this.group(groupName);
        return group != null && !group.isEmpty();
    }

    private void start(ReflectiveHandle<?> handle) {
        if (!this.matcher.matches()) {
            this.error("Not a " + handle + " declaration");
        }
        this.parseFlags();
        if (handle instanceof MemberHandle) {
            MemberHandle memberHandle = (MemberHandle)handle;
            if (!ReflectionParser.hasOneOf(this.flags, Flag.PUBLIC, Flag.PROTECTED, Flag.PRIVATE)) {
                Class clazz = (Class)memberHandle.getClassHandle().reflectOrNull();
                if (clazz != null && !clazz.isInterface()) {
                    memberHandle.makeAccessible();
                }
            } else if (ReflectionParser.hasOneOf(this.flags, Flag.PRIVATE, Flag.PROTECTED)) {
                memberHandle.makeAccessible();
            }
            if (handle instanceof FieldMemberHandle && this.flags.contains((Object)Flag.FINAL)) {
                ((FieldMemberHandle)handle).asFinal();
            }
            if (handle instanceof FlaggedNamedMemberHandle && this.flags.contains((Object)Flag.STATIC)) {
                ((FlaggedNamedMemberHandle)handle).asStatic();
            }
        }
    }

    private void parseFlags() {
        if (!this.has("flags")) {
            return;
        }
        String flagsStr = this.group("flags");
        for (String flag : flagsStr.split("\\s+")) {
            if (this.flags.add(Flag.valueOf(flag.toUpperCase(Locale.ENGLISH)))) continue;
            this.error("Repeated flag: " + flag);
        }
        if (ReflectionParser.containsDuplicates(this.flags, Flag.PUBLIC, Flag.PROTECTED, Flag.PRIVATE)) {
            this.error("Duplicate visibility flags");
        }
    }

    @SafeVarargs
    private static <T> boolean containsDuplicates(Collection<T> collection, T ... values) {
        boolean contained = false;
        for (T value : values) {
            if (!collection.contains(value)) continue;
            if (contained) {
                return true;
            }
            contained = true;
        }
        return false;
    }

    @SafeVarargs
    private static <T> boolean hasOneOf(Collection<T> collection, T ... elements) {
        return Arrays.stream(elements).anyMatch(collection::contains);
    }

    private void error(String message) {
        throw new ReflectionParserException(message + " in: " + this.declaration + " (RegEx: " + this.pattern.pattern() + "), (Imports: " + this.cachedImports + ')');
    }

    static {
        Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Void.TYPE, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class, Void.class, Object.class, String.class, CharSequence.class, StringBuilder.class, StringBuffer.class, UUID.class, Optional.class, Map.class, HashMap.class, ConcurrentHashMap.class, LinkedHashMap.class, WeakHashMap.class, List.class, ArrayList.class, Set.class, HashSet.class, Deque.class, Queue.class, LinkedList.class, Date.class, Calendar.class, Duration.class).forEach(x -> PREDEFINED_TYPES.put(x.getSimpleName(), (Class<?>)x));
    }

    private static enum Flag {
        PUBLIC,
        PROTECTED,
        PRIVATE,
        FINAL,
        TRANSIENT,
        ABSTRACT,
        STATIC,
        NATIVE,
        SYNCHRONIZED,
        STRICTFP,
        VOLATILE;

        private static final String FLAGS_REGEX;

        static /* synthetic */ String access$000() {
            return FLAGS_REGEX;
        }

        static {
            FLAGS_REGEX = "(?<flags>(?:(?:" + Arrays.stream(Flag.values()).map(Enum::name).map(x -> x.toLowerCase(Locale.ENGLISH)).collect(Collectors.joining("|")) + ")\\s*)+)?";
        }
    }

    private static final class IDHandler {
        private boolean generic;
        private boolean array;
        private final String groupName;
        private final boolean isFullyQualified;

        private IDHandler(String groupName, boolean isFullyQualified) {
            this.groupName = groupName;
            this.isFullyQualified = isFullyQualified;
        }

        public IDHandler generic(boolean generic) {
            this.generic = generic;
            return this;
        }

        public IDHandler array(boolean array) {
            this.array = array;
            return this;
        }

        public String toString() {
            String type = (this.isFullyQualified ? "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*" : "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") + (this.generic ? ReflectionParser.GENERIC : "") + (this.array ? ReflectionParser.ARRAY : "");
            if (this.groupName == null) {
                return "(?:" + type + ')';
            }
            return "(?<" + this.groupName + '>' + type + ')';
        }
    }

    public static final class ReflectionParserException
    extends RuntimeException {
        public ReflectionParserException(String message) {
            super(message);
        }
    }
}

