/*
 * Decompiled with CFR 0.152.
 */
package me.aglerr.donations.libs;

import com.muhammaddaffa.mdlib.utils.Common;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import me.aglerr.donations.ConfigValue;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class ImageMessageHex {
    private static final char TRANSPARENT_CHAR = ' ';
    private String[] lines;

    public ImageMessageHex(BufferedImage image, int height, char imgChar) {
        Color[][] chatColors = this.toChatColorArray(image, height);
        this.lines = this.toImgMessage(chatColors, imgChar);
    }

    private Color[][] toChatColorArray(BufferedImage image, int height) {
        double ratio = (double)image.getHeight() / (double)image.getWidth();
        int width = (int)((double)height / ratio);
        if (width > 10) {
            width = 10;
        }
        BufferedImage resized = this.resizeImage(image, width, height);
        Color[][] chatImg = new Color[resized.getWidth()][resized.getHeight()];
        for (int x = 0; x < resized.getWidth(); ++x) {
            for (int y = 0; y < resized.getHeight(); ++y) {
                int argb = resized.getRGB(x, y);
                Color color = new Color(argb, true);
                chatImg[x][y] = color.getAlpha() < 128 ? null : new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
        }
        return chatImg;
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        Image scaled = originalImage.getScaledInstance(width, height, 4);
        BufferedImage resized = new BufferedImage(width, height, 2);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage(scaled, 0, 0, null);
        g2d.dispose();
        return resized;
    }

    private String[] toImgMessage(Color[][] colors, char imgchar) {
        this.lines = new String[colors[0].length];
        for (int y = 0; y < colors[0].length; ++y) {
            StringBuilder line = new StringBuilder();
            for (int x = 0; x < colors.length; ++x) {
                Color color = colors[x][y];
                if (color != null) {
                    line.append("&#").append(this.colorToHex(color)).append(imgchar);
                    continue;
                }
                line.append(' ');
            }
            this.lines[y] = Common.color(line.toString()) + String.valueOf(ChatColor.RESET);
        }
        return this.lines;
    }

    private String colorToHex(Color c) {
        return String.format("%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    public ImageMessageHex appendText(String ... text) {
        for (int y = 0; y < this.lines.length; ++y) {
            if (text.length <= y) continue;
            int n = y;
            this.lines[n] = this.lines[n] + " " + text[y];
        }
        return this;
    }

    public void sendToPlayers() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            player.spigot().sendMessage(this.translateHex(ConfigValue.HEADER));
            for (String line : this.lines) {
                player.spigot().sendMessage(this.translateHex(line));
            }
            player.spigot().sendMessage(this.translateHex(ConfigValue.FOOTER));
        });
    }

    private BaseComponent[] translateHex(String message) {
        return TextComponent.fromLegacyText((String)Common.color(message));
    }
}

