/*
 * Decompiled with CFR 0.152.
 */
package me.aglerr.donations.managers;

import com.muhammaddaffa.mdlib.utils.Common;
import com.muhammaddaffa.mdlib.utils.Config;
import me.aglerr.donations.ConfigValue;
import me.aglerr.donations.DonationPlugin;
import me.aglerr.donations.objects.Product;
import me.aglerr.donations.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class DonationGoal {
    private static double donationGoal;
    private static double currentDonation;

    public static String getProgressBar() {
        return Utils.getProgressBar((int)currentDonation, (int)donationGoal, ConfigValue.PROGRESS_BAR_LENGTH, ConfigValue.PROGRESS_BAR_SYMBOL, ConfigValue.PROGRESS_BAR_COMPLETED_COLOR, ConfigValue.PROGRESS_BAR_UNCOMPLETED_COLOR);
    }

    public static String getDonationPercentage() {
        return Common.digits(currentDonation / donationGoal * 100.0);
    }

    public static void handleDonation(Product product) {
        if ((currentDonation += product.getPrice()) >= donationGoal) {
            currentDonation = 0.0;
            ConfigValue.DONATION_GOAL_COMMANDS.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
        }
    }

    public static void reloadDonationGoal() {
        donationGoal = ConfigValue.DONATION_GOAL_AMOUNT;
    }

    public static void onLoad() {
        FileConfiguration data = DonationPlugin.DATA.getConfig();
        donationGoal = ConfigValue.DONATION_GOAL_AMOUNT;
        currentDonation = data.getDouble("donationGoal");
    }

    public static void onSave() {
        Config data = DonationPlugin.DATA;
        FileConfiguration config = data.getConfig();
        config.set("donationGoal", (Object)currentDonation);
        data.saveConfig();
    }

    public static void reset() {
        currentDonation = 0.0;
    }

    public static String getDonationGoal() {
        return Common.digits(donationGoal);
    }

    public static String getCurrentDonation() {
        return Common.digits(currentDonation);
    }
}

