/*
 * Decompiled with CFR 0.152.
 */
package me.aglerr.donations.utils;

import com.muhammaddaffa.mdlib.utils.Common;
import com.muhammaddaffa.mdlib.xseries.XSound;
import java.util.List;
import java.util.Optional;
import me.aglerr.donations.DonationPlugin;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Events {
    private static final DonationPlugin plugin = (DonationPlugin)JavaPlugin.getPlugin(DonationPlugin.class);

    public static void playAllEvents(OfflinePlayer player) {
        Events.eventEffects();
        Events.eventSound();
        Events.eventTitleBar(player);
        Events.eventCommand(player);
    }

    public static void eventEffects() {
        FileConfiguration config = plugin.getConfig();
        if (!config.getBoolean("events.effect.enabled")) {
            return;
        }
        List effects = config.getStringList("events.effect.effects");
        Bukkit.getOnlinePlayers().forEach(player -> {
            for (String effectString : effects) {
                String[] effectSection = effectString.split(";");
                PotionEffectType effectType = PotionEffectType.getByName((String)effectSection[0]);
                if (effectType == null) continue;
                int amplifier = Integer.parseInt(effectSection[1]) + 1;
                int duration = Integer.parseInt(effectSection[2]) * 20;
                PotionEffect potionEffect = new PotionEffect(effectType, duration, amplifier);
                player.removePotionEffect(effectType);
                player.addPotionEffect(potionEffect);
            }
        });
    }

    public static void eventSound() {
        FileConfiguration config = plugin.getConfig();
        List sounds = config.getStringList("events.sounds");
        Bukkit.getOnlinePlayers().forEach(player -> {
            for (String soundString : sounds) {
                Sound sound;
                String[] section = soundString.split(";");
                Optional<XSound> xSound = XSound.matchXSound(section[0]);
                if (!xSound.isPresent() || (sound = xSound.get().parseSound()) == null) continue;
                double volume = Double.parseDouble(section[1]);
                double pitch = Double.parseDouble(section[2]);
                player.playSound(player.getLocation(), sound, (float)volume, (float)pitch);
            }
        });
    }

    public static void eventTitleBar(OfflinePlayer offlinePlayer) {
        FileConfiguration config = plugin.getConfig();
        if (!config.getBoolean("events.titleBar.enabled")) {
            return;
        }
        String title = Common.color(config.getString("events.titleBar.title").replace("{player}", offlinePlayer.getName()));
        String subTitle = Common.color(config.getString("events.titleBar.subTitle").replace("{player}", offlinePlayer.getName()));
        int fadeIn = config.getInt("events.titleBar.fadeIn");
        int stay = config.getInt("events.titleBar.stay");
        int fadeOut = config.getInt("events.titleBar.fadeOut");
        Bukkit.getOnlinePlayers().forEach(player -> Common.sendTitle(player, title, subTitle, fadeIn, stay, fadeOut));
    }

    public static void eventCommand(OfflinePlayer offlinePlayer) {
        FileConfiguration config = plugin.getConfig();
        if (!config.getBoolean("events.command.enabled")) {
            return;
        }
        config.getStringList("events.command.commands").forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("{player}", offlinePlayer.getName())));
    }
}

