/*
 * Decompiled with CFR 0.152.
 */
package me.aglerr.donations.utils;

import com.google.common.base.Strings;
import com.muhammaddaffa.mdlib.utils.Common;
import com.muhammaddaffa.mdlib.utils.Logger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import javax.imageio.ImageIO;
import me.aglerr.donations.ConfigValue;
import me.aglerr.donations.DonationPlugin;
import me.aglerr.donations.libs.ImageChar;
import me.aglerr.donations.libs.ImageMessage;
import me.aglerr.donations.libs.ImageMessageHex;
import me.aglerr.donations.managers.DependencyManager;
import me.aglerr.donations.objects.QueueDonation;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.property.SkinIdentifier;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;

public class Utils {
    public static String[] getStartupLogo() {
        return new String[]{"  _______ _             ____        _       ", " |__   __| |           / __ \\      | |      ", "    | |  | |__   ___  | |  | |_ __ | |_   _ ", "    | |  | '_ \\ / _ \\ | |  | | '_ \\| | | | |", "    | |  | | | |  __/ | |__| | | | | | |_| |", "    |_|  |_| |_|\\___|  \\____/|_| |_|_|\\__, |", "                                       __/ |", "                                      |___/ ", "  ", "                Donations edition", "            Thanks for using and enjoy!", "  "};
    }

    public static void sendStartupLogo() {
        for (String message : Utils.getStartupLogo()) {
            System.out.println(message);
        }
    }

    public static String getMinepicURL(OfflinePlayer player) {
        SkinsRestorer api;
        Optional optional;
        Object url = "https://minepic.org/avatar/8/";
        url = DependencyManager.SKINS_RESTORER_ENABLED ? (String)url + ((optional = (api = DonationPlugin.getSkinsApi()).getPlayerStorage().getSkinIdOfPlayer(player.getUniqueId())).isPresent() ? ((SkinIdentifier)optional.get()).getIdentifier() : player.getName()) : (String)url + (ConfigValue.USE_UUID ? player.getUniqueId().toString() : player.getName());
        return url;
    }

    public static void broadcastDonation(QueueDonation donation) {
        try {
            URL url = new URL(Utils.getMinepicURL(donation.getPlayer()));
            BufferedImage image = ImageIO.read(url);
            if (ConfigValue.BROADCAST_AVATAR_ENABLED) {
                if (DonationPlugin.HEX_AVAILABLE) {
                    ImageMessageHex imageMessageHex = new ImageMessageHex(image, 8, ImageChar.BLOCK.getChar()).appendText(ConfigValue.donationAvatar(donation));
                    imageMessageHex.sendToPlayers();
                } else {
                    ImageMessage imageMessage = new ImageMessage(image, 8, ImageChar.BLOCK.getChar()).appendText(ConfigValue.donationAvatar(donation));
                    imageMessage.sendToPlayers();
                }
            } else if (DonationPlugin.HEX_AVAILABLE) {
                Bukkit.getOnlinePlayers().forEach(player -> ConfigValue.donationNoAvatar(donation).forEach(message -> player.spigot().sendMessage((BaseComponent)new TextComponent(Common.color(message)))));
            } else {
                ConfigValue.donationNoAvatar(donation).forEach(message -> Bukkit.broadcastMessage((String)Common.color(message)));
            }
        }
        catch (IOException ex) {
            Logger.info("&cFailed to send a broadcast donation!");
            ex.printStackTrace();
        }
    }

    public static String getProgressBar(int current, int max, int totalBars, char symbol, ChatColor completedColor, ChatColor notCompletedColor) {
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        return Strings.repeat((String)(String.valueOf(completedColor) + symbol), (int)progressBars) + Strings.repeat((String)(String.valueOf(notCompletedColor) + symbol), (int)(totalBars - progressBars));
    }
}

