/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;

public class ClientSwayUtil {
    private float fallSway = 0.0f;
    private float prevFallSway = 0.0f;
    private int lastTick = -1;

    public void applyFirstPersonSway(PoseStack poseStack, ItemDisplayContext context, float partialTick) {
        if (!ClientSwayUtil.isFirstPerson(context)) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean leftHand = context == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        int handSign = leftHand ? -1 : 1;
        poseStack.m_85837_(0.09375, -0.015625, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(2.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-9.5f));
        if (leftHand) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(19.0f));
        }
        this.applyHeadSway(poseStack, player, partialTick, handSign);
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue()) {
            this.applyMovementBobbing(poseStack, player, partialTick, handSign);
        }
        this.applyFallSway(poseStack, player, partialTick);
    }

    private void applyHeadSway(PoseStack poseStack, LocalPlayer player, float partialTick, int handSign) {
        float bobPitch = Mth.m_14189_((float)partialTick, (float)player.f_108588_, (float)player.f_108586_);
        float headPitch = Mth.m_14189_((float)partialTick, (float)player.f_19860_, (float)player.m_146909_());
        float swayPitch = headPitch - bobPitch;
        float bobYaw = Mth.m_14189_((float)partialTick, (float)player.f_108587_, (float)player.f_108585_);
        float headYaw = Mth.m_14189_((float)partialTick, (float)player.f_20886_, (float)player.f_20885_);
        float swayYaw = headYaw - bobYaw;
        float sprintBoost = player.m_20142_() ? 1.15f : 1.0f;
        float sensitivity = 0.6f * sprintBoost;
        float rollFromYaw = swayYaw * 0.35f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(swayYaw * sensitivity * (float)handSign));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(swayPitch * sensitivity));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rollFromYaw * sensitivity * (float)handSign));
    }

    private void applyMovementBobbing(PoseStack poseStack, LocalPlayer player, float partialTick, int handSign) {
        float deltaWalk = player.f_19787_ - player.f_19867_;
        float walk = -(player.f_19787_ + deltaWalk * partialTick);
        float bob = Mth.m_14179_((float)partialTick, (float)player.f_36099_, (float)player.f_36100_);
        float bobScale = player.m_20142_() ? 0.9f : 0.5f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-(Math.abs(Mth.m_14089_((float)(walk * (float)Math.PI - 0.2f)) * bob) * 3.5f) * bobScale));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-(Mth.m_14031_((float)(walk * (float)Math.PI)) * bob * 2.0f) * bobScale * (float)handSign));
        poseStack.m_85837_((double)(-(Mth.m_14031_((float)(walk * (float)Math.PI)) * bob * 0.15f) * (float)handSign), (double)(Math.abs(Mth.m_14089_((float)(walk * (float)Math.PI)) * bob) * 0.12f), 0.0);
    }

    private void applyFallSway(PoseStack poseStack, LocalPlayer player, float partialTick) {
        int tick = player.f_19797_;
        if (tick != this.lastTick) {
            this.lastTick = tick;
            this.prevFallSway = this.fallSway;
            float deltaY = (float)Mth.m_14008_((double)(player.f_19855_ - player.m_20186_()), (double)-1.0, (double)1.0);
            float pitchNow = Mth.m_14189_((float)1.0f, (float)player.f_19860_, (float)player.m_146909_());
            float pitchFactor = 1.0f - Math.abs(pitchNow) / 90.0f * 0.5f;
            float sensitivityDegrees = player.m_20142_() ? 60.0f : 45.0f;
            float target = deltaY * sensitivityDegrees * pitchFactor;
            if (Math.abs(target) < 0.15f) {
                target = 0.0f;
            }
            this.fallSway = Mth.m_14121_((float)this.fallSway, (float)target, (float)(player.m_20096_() ? 6.0f : 10.0f));
        }
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTick, (float)this.prevFallSway, (float)this.fallSway)));
    }

    private static boolean isFirstPerson(ItemDisplayContext ctx) {
        return ctx == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || ctx == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
    }

    public void reset() {
        this.fallSway = 0.0f;
        this.prevFallSway = 0.0f;
        this.lastTick = -1;
    }
}

