/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.entity.passive;

import dev.xylonity.bonsai.clockwork.common.entity.HostileClockworkEntity;
import dev.xylonity.bonsai.clockwork.common.entity.passive.DragonflyEntity;
import dev.xylonity.bonsai.clockwork.config.ClockworkConfig;
import dev.xylonity.bonsai.clockwork.registry.ClockworkEntities;
import dev.xylonity.bonsai.clockwork.registry.ClockworkItems;
import dev.xylonity.bonsai.clockwork.registry.ClockworkSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BrokenDragonflyEntity
extends HostileClockworkEntity {
    private final RawAnimation ACTIVATE = RawAnimation.begin().thenPlay("activate");
    private final RawAnimation DEACTIVATED = RawAnimation.begin().thenPlay("deactivated");
    public static final EntityDataAccessor<Integer> ACTIVATED_TIMER = SynchedEntityData.m_135353_(BrokenDragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int ANIMATION_ACTIVATE_TICKS = 28;

    public BrokenDragonflyEntity(EntityType<? extends HostileClockworkEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, ClockworkConfig.DRAGONFLY_DEFAULT_HEALTH).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, ClockworkConfig.DRAGONFLY_DEFAULT_WALKING_SPEED).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22280_, ClockworkConfig.DRAGONFLY_DEFAULT_FLYING_SPEED);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVATED_TIMER, (Object)29);
    }

    public void setActivatedTimer(int activatedTicks) {
        this.f_19804_.m_135381_(ACTIVATED_TIMER, (Object)activatedTicks);
    }

    public int getActivatedTimer() {
        return (Integer)this.f_19804_.m_135370_(ACTIVATED_TIMER);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getActivatedTimer() <= 28) {
            if (this.getActivatedTimer() == 0) {
                DragonflyEntity entity = (DragonflyEntity)((EntityType)ClockworkEntities.DRAGONFLY.get()).m_20615_(this.m_9236_());
                if (entity != null) {
                    entity.m_146884_(this.m_20182_());
                    this.m_9236_().m_7967_((Entity)entity);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.generatePoofParticles();
                this.m_146870_();
                return;
            }
            this.setActivatedTimer(this.getActivatedTimer() - 1);
        }
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == ClockworkItems.CLOCKWORK_GEAR.get()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ClockworkSounds.DRAGONFLY_GEAR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!(this.f_19796_.m_188501_() <= 0.3f)) {
                this.generateFailParticles();
                return InteractionResult.FAIL;
            }
            this.setActivatedTimer(this.getActivatedTimer() - 1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20182_().f_82479_, this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20182_().f_82481_, 1, dx, dy, dz, 0.1);
        }
    }

    private void generateFailParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20182_().f_82479_, this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20182_().f_82481_, 1, dx, dy, dz, 0.1);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ActivatedTimer", this.getActivatedTimer());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ActivatedTimer")) {
            this.setActivatedTimer(compound.m_128451_("ActivatedTimer"));
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ClockworkSounds.DRAGONFLY_HURT.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getActivatedTimer() <= 28) {
            event.setAnimation(this.ACTIVATE);
        } else {
            event.setAnimation(this.DEACTIVATED);
        }
        return PlayState.CONTINUE;
    }
}

